/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.io.types;

import org.jpedal.io.ObjectDecoder;
import org.jpedal.io.PdfFileReader;
import org.jpedal.io.types.StreamReaderUtils;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.NumberUtils;

public final class NumberValue {
    private NumberValue() {
    }

    public static int setNumberValue(PdfObject pdfObject, int i, byte[] raw, int PDFkeyInt, PdfFileReader objectReader) {
        int keyStart = i;
        int rawLength = raw.length;
        while (raw[i] != 10 && raw[i] != 13 && raw[i] != 32 && raw[i] != 47 && raw[i] != 60 && raw[i] != 62 && raw[i] != 40 && raw[i] != 46) {
            ++i;
        }
        int number = NumberUtils.parseInt(keyStart, i, raw);
        int jj = StreamReaderUtils.skipSpaces(raw, i);
        if (raw[jj] >= 48 && raw[jj] <= 57) {
            boolean isRef;
            int aa = StreamReaderUtils.skipToEndOfRef(raw, jj);
            boolean bl = isRef = (aa = StreamReaderUtils.skipSpacesOrOtherCharacter(raw, aa, 47)) < rawLength && raw[aa] == 82;
            if (isRef) {
                return NumberValue.readNumberFromIndirectObj(PDFkeyInt, pdfObject, i, raw, objectReader, rawLength, number);
            }
        }
        pdfObject.setIntNumber(PDFkeyInt, number);
        if (ObjectDecoder.debugFastCode) {
            System.out.println(ObjectDecoder.padding + "set numberValue=" + number);
        }
        return i - 1;
    }

    private static int readNumberFromIndirectObj(int PDFkeyInt, PdfObject pdfObject, int i, byte[] raw, PdfFileReader objectReader, int rawLength, int number) {
        int keyStart = i = StreamReaderUtils.skipSpaces(raw, i);
        i = StreamReaderUtils.skipToEndOfRef(raw, i);
        int generation = NumberUtils.parseInt(keyStart, i, raw);
        while (raw[i] == 10 || raw[i] == 13 || raw[i] == 32 || raw[i] == 47 || raw[i] == 60) {
            ++i;
        }
        if (raw[i] != 82) {
            throw new RuntimeException("3. Unexpected value in file - please send to IDRsolutions for analysis");
        }
        byte[] data = objectReader.readObjectAsByteArray(pdfObject, objectReader.isCompressed(number, generation), number, generation);
        if (data == null) {
            pdfObject.setFullyResolved(false);
            if (ObjectDecoder.debugFastCode) {
                System.out.println(ObjectDecoder.padding + "Data not yet loaded");
            }
            LogWriter.writeLog("[Linearized] " + pdfObject.getObjectRefAsString() + " not yet available (8)");
            return rawLength;
        }
        int[] pos = NumberValue.extractDataFromIndirectRef(data);
        number = NumberUtils.parseInt(pos[0], pos[1], data);
        pdfObject.setIntNumber(PDFkeyInt, number);
        if (ObjectDecoder.debugFastCode) {
            System.out.println(ObjectDecoder.padding + "set numberValue=" + number);
        }
        return i - 1;
    }

    public static int[] extractDataFromIndirectRef(byte[] data) {
        int count;
        int j = 0;
        int len = data.length;
        if ((len <= 1 || data[0] != 60 || data[1] != 60) && len > 3) {
            j = 3;
            while (data[j - 1] != 106 && data[j - 2] != 98 && data[j - 3] != 111) {
                if (++j != len) continue;
                j = 0;
                break;
            }
        }
        if (len > 1) {
            j = StreamReaderUtils.skipSpaces(data, j);
        }
        for (count = j; count < len && data[count] != 9 && data[count] != 10 && data[count] != 13 && data[count] != 32; ++count) {
        }
        return new int[]{j, count};
    }
}

