/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.io.types;

import org.jpedal.io.PdfFileReader;
import org.jpedal.io.types.Array;
import org.jpedal.io.types.StreamReaderUtils;
import org.jpedal.objects.raw.PdfObject;

public class KeyArray
extends Array {
    public KeyArray(PdfFileReader pdfFileReader, int i, byte[] raw) {
        super(pdfFileReader, i, 14, raw);
    }

    @Override
    boolean isSingleKey() {
        return StreamReaderUtils.isRef(this.arrayData, this.j2);
    }

    @Override
    void fillArray(int elementCount, PdfObject pdfObject) {
        byte[][] finalByteValues = new byte[elementCount][];
        for (int a = 0; a < elementCount; ++a) {
            finalByteValues[a] = KeyArray.sanitiseOutput((byte[])this.valuesRead.get(a));
        }
        pdfObject.setKeyArray(this.PDFkeyInt, finalByteValues);
    }

    private static byte[] sanitiseOutput(byte[] bytes) {
        if (bytes != null) {
            int length = bytes.length;
            for (int i = 0; i < length; ++i) {
                if (bytes[i] != 10) continue;
                bytes[i] = 32;
            }
        }
        return bytes;
    }
}

