/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.io.types;

import org.jpedal.io.ObjectDecoder;
import org.jpedal.io.PdfFileReader;
import org.jpedal.io.types.ArrayHandler;
import org.jpedal.io.types.Dictionary;
import org.jpedal.io.types.Name;
import org.jpedal.io.types.NumberValue;
import org.jpedal.io.types.StreamReaderUtils;
import org.jpedal.io.types.TextStream;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.utils.LogWriter;

public final class General {
    private General() {
    }

    public static int readGeneral(PdfObject pdfObject, int i, byte[] raw, int PDFkeyInt, PdfFileReader objectReader) {
        if (ObjectDecoder.debugFastCode) {
            System.out.println(ObjectDecoder.padding + "general case " + i);
        }
        int jj = i;
        int j = i + 1;
        byte[] data = raw;
        int typeFound = 0;
        boolean isNumber = true;
        boolean isRef = false;
        boolean isString = false;
        String objRef = pdfObject.getObjectRefAsString();
        do {
            if (data[j] == 82 && !isString) {
                isRef = true;
                int end = j;
                j = i;
                i = end;
                while (data[j] == 91 || data[j] == 32 || data[j] == 13 || data[j] == 10) {
                    ++j;
                }
                int[] values = StreamReaderUtils.readRefFromStream(data, j);
                int refStart = j;
                int ref = values[0];
                int generation = values[1];
                j = values[2];
                if (PDFkeyInt == 30 && ref == pdfObject.getObjectRefID()) {
                    return i;
                }
                if (data[j] != 82) {
                    throw new RuntimeException("ref=" + ref + " gen=" + ref + " 1. Unexpected value " + data[j] + " in file - please send to IDRsolutions for analysis char=" + (char)data[j]);
                }
                objRef = new String(data, refStart, 1 + j - refStart);
                boolean isCompressed = objectReader.isCompressed(ref, generation);
                data = objectReader.readObjectAsByteArray(pdfObject, isCompressed, ref, generation);
                if (data == null) {
                    pdfObject.setFullyResolved(false);
                    if (ObjectDecoder.debugFastCode) {
                        System.out.println(ObjectDecoder.padding + "Data not yet loaded");
                    }
                    i = raw.length;
                    break;
                }
                int firstChar = 0;
                if (data.length <= 2 || data[0] != 60 || data[1] != 60) {
                    firstChar = General.findFirstChar(data, firstChar);
                }
                isString = data[firstChar] == 40;
                jj = !isCompressed ? General.skipStartObj(data) : 0;
                j = jj;
                if (ObjectDecoder.debugFastCode) {
                    System.out.println(j + " >>" + new String(data) + "<<next=" + (char)data[j]);
                }
            } else {
                if (data[j] == 91 || data[j] == 40 || data[j] == 60) break;
                if (data[j] == 62 || data[j] == 47) {
                    typeFound = 1;
                    break;
                }
                if (data[j] != 32 && data[j] != 10 && data[j] != 13 && data[j] != 9 && data[j] != 46 && (data[j] < 48 || data[j] > 57)) {
                    isNumber = false;
                }
            }
            if (data[j] == 91) continue;
            ++j;
        } while (j != data.length);
        if (data != null) {
            jj = General.processData(pdfObject, PDFkeyInt, objectReader, jj, data, typeFound, isNumber, objRef);
        }
        if (!isRef) {
            return jj;
        }
        return i;
    }

    private static int processData(PdfObject pdfObject, int PDFkeyInt, PdfFileReader objectReader, int jj, byte[] data, int typeFound, boolean isNumber, String objRef) {
        if (data[jj = StreamReaderUtils.skipSpaces(data, jj)] == 47 && General.getKeyCount(jj, data) == 0) {
            jj = Name.setNameStringValue(pdfObject, jj, data, PDFkeyInt, objectReader);
        } else if (data[jj] == 40) {
            jj = TextStream.readTextStream(pdfObject, jj, data, PDFkeyInt, objectReader);
        } else if (data[jj] == 91) {
            jj = ArrayHandler.setArray(pdfObject, jj, data, PDFkeyInt, objectReader);
        } else if (typeFound == 0) {
            try {
                jj = Dictionary.readDictionaryFromRefOrDirect(pdfObject, objRef, jj, data, PDFkeyInt, objectReader);
            }
            catch (Exception e) {
                LogWriter.writeLog("Exception: " + e.getMessage());
            }
        } else {
            jj = isNumber ? NumberValue.setNumberValue(pdfObject, jj, data, PDFkeyInt, objectReader) : Name.setNameStringValue(pdfObject, jj, data, PDFkeyInt, objectReader);
        }
        return jj;
    }

    private static int findFirstChar(byte[] newData, int firstChar) {
        int newLength = newData.length - 3;
        for (int aa = 3; aa < newLength; ++aa) {
            if (newData[aa - 2] == 111 && newData[aa - 1] == 98 && newData[aa] == 106) {
                firstChar = aa + 1;
                firstChar = StreamReaderUtils.skipSpaces(newData, firstChar);
                aa = newLength;
                continue;
            }
            if (newData[aa] > 47 && newData[aa] < 58 || newData[aa] == 111 || newData[aa] == 98 || newData[aa] == 106 || newData[aa] == 82 || newData[aa] == 32 || newData[aa] == 10 || newData[aa] == 13) continue;
            aa = newLength;
            firstChar = 0;
        }
        return firstChar;
    }

    private static int skipStartObj(byte[] data) {
        int jj = 3;
        if (data.length <= 3) {
            jj = 0;
        } else {
            while (data[jj - 2] != 111 || data[jj - 1] != 98 || data[jj] != 106) {
                if (++jj != data.length) continue;
                jj = 0;
                break;
            }
        }
        if (data[jj] != 91 && data[jj] != 40 && data[jj] != 60) {
            ++jj;
        }
        jj = StreamReaderUtils.skipSpaces(data, jj);
        return jj;
    }

    private static int getKeyCount(int jj, byte[] data) {
        int count = 0;
        for (int aa = jj + 1; aa < data.length; ++aa) {
            if (data[aa] != 47) continue;
            ++count;
        }
        return count;
    }
}

