/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.io.types;

import org.jpedal.io.PdfFileReader;
import org.jpedal.objects.raw.FormObject;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.utils.StringUtils;

public final class Form {
    private Form() {
    }

    public static void setFieldNames(PdfObject pdfObject, PdfFileReader objectReader) {
        String fieldName = pdfObject.getTextStreamValue(36);
        if (fieldName != null) {
            String parent = pdfObject.getStringKey(1110793845);
            boolean isMultiple = false;
            while (parent != null) {
                FormObject parentObj = new FormObject(parent, false);
                objectReader.readObject(parentObj);
                String newName = parentObj.getTextStreamValue(36);
                if (newName == null) break;
                if (!fieldName.equals(newName) || !parent.equals(pdfObject.getObjectRefAsString())) {
                    fieldName = newName + '.' + fieldName;
                    isMultiple = true;
                }
                parent = parentObj.getParentRef();
            }
            if (isMultiple) {
                pdfObject.setTextStreamValue(36, StringUtils.toBytes(fieldName));
            }
        }
    }
}

