/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.io.security;

public class CryptoIDR {
    private final byte[] password;
    private final int passwordLength;
    private int bytesProcessed;

    public CryptoIDR(byte[] password) {
        if (password == null) {
            password = "mabel".getBytes();
        }
        this.password = password;
        this.passwordLength = password.length;
    }

    public void skip(long n) {
        this.bytesProcessed = (int)((long)this.bytesProcessed + n);
    }

    public byte[] encrypt(byte[] pdfBytes, int salt) {
        int length = pdfBytes.length;
        byte[] returnBytes = new byte[length];
        for (int i = 0; i < length; ++i) {
            returnBytes[i] = this.encrypt(pdfBytes[i], salt + i);
        }
        return returnBytes;
    }

    public byte[] decrypt(byte[] pdfBytes, int salt) {
        int length = pdfBytes.length;
        byte[] returnBytes = new byte[length];
        for (int i = 0; i < length; ++i) {
            returnBytes[i] = this.decrypt(pdfBytes[i], salt + i);
        }
        return returnBytes;
    }

    private byte encrypt(byte b, int salt) {
        int remainder = salt % this.passwordLength;
        byte realSalt = this.password[remainder];
        b = ~b;
        b = (byte)(b ^ realSalt);
        return b;
    }

    private byte decrypt(byte b, int salt) {
        int remainder = salt % this.passwordLength;
        byte realSalt = this.password[remainder];
        b = (byte)(b ^ realSalt);
        b = ~b;
        return b;
    }

    public byte[] encrypt(byte[] data) {
        data = this.encrypt(data, this.bytesProcessed);
        this.bytesProcessed += data.length;
        return data;
    }

    public byte encrypt(byte data, boolean rollOn) {
        data = this.encrypt(data, this.bytesProcessed);
        if (rollOn) {
            ++this.bytesProcessed;
        }
        return data;
    }

    public byte[] decrypt(byte[] data) {
        data = this.decrypt(data, this.bytesProcessed);
        this.bytesProcessed += data.length;
        return data;
    }

    public byte[] decrypt(byte[] data, int offset, int length) {
        byte[] returnBytes = new byte[length];
        System.arraycopy(data, offset, returnBytes, 0, length);
        return this.decrypt(returnBytes);
    }

    public int getBytesProcessed() {
        return this.bytesProcessed;
    }
}

