/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.images;

public final class SamplingFactory {
    public static int none;
    public static final int medium = 1;
    public static final int high = 2;
    public static final int print_enable = 3;
    public static final int print_disable = 4;
    public static final int mediumAndSharpen = 5;
    public static final int highAndSharpen = 6;
    public static int downsampleLevel;
    public static boolean isPrintDownsampleEnabled;
    public static boolean kernelSharpen;
    private static double[][] sharpenKernel;

    private SamplingFactory() {
    }

    public static void setDownsampleMode(String newLevel) {
        if (newLevel == null) {
            newLevel = System.getProperty("org.jpedal.downsample");
        }
        if (newLevel != null) {
            switch (newLevel) {
                case "high": 
                case "\"high\"": {
                    downsampleLevel = 2;
                    break;
                }
                case "medium": 
                case "\"medium\"": {
                    downsampleLevel = 1;
                    break;
                }
                case "none": 
                case "\"none\"": {
                    downsampleLevel = none;
                    break;
                }
                case "print_disable": 
                case "\"print_disable\"": {
                    isPrintDownsampleEnabled = false;
                    break;
                }
                case "print_enable": 
                case "\"print_enable\"": {
                    isPrintDownsampleEnabled = true;
                    break;
                }
            }
        }
    }

    public static void setDownsampleMode(int newLevel) {
        if (newLevel == 2 || newLevel == 6 || newLevel == 1 || newLevel == 5 || newLevel == none) {
            downsampleLevel = newLevel;
        } else if (newLevel == 4) {
            isPrintDownsampleEnabled = false;
        } else if (newLevel == 3) {
            isPrintDownsampleEnabled = true;
        }
    }

    public static void setSharpenKernel(double[][] userKernel) {
        sharpenKernel = userKernel;
    }

    public static double[][] getSharpenKernel() {
        return sharpenKernel;
    }

    static {
        downsampleLevel = 2;
        isPrintDownsampleEnabled = true;
        sharpenKernel = new double[][]{{0.0, -1.0, 0.0}, {-1.0, 5.0, -1.0}, {0.0, -1.0, 0.0}};
    }
}

