/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.function;

import org.jpedal.function.PDFFunction;
import org.jpedal.function.PDFGenericFunction;

public class PDFExponential
extends PDFGenericFunction
implements PDFFunction {
    private float[] C0 = new float[]{0.0f};
    private final float N;
    private final float[] diffs;
    private final float[] output;
    private final float domain0;
    private final float domain1;

    public PDFExponential(float N2, float[] C0, float[] C1, float[] domain, float[] range) {
        super(domain, range);
        this.N = N2;
        if (C0 != null) {
            this.C0 = C0;
        }
        float[] c1 = new float[]{1.0f};
        if (C1 != null) {
            c1 = C1;
        }
        int returnValues = this.C0.length;
        this.diffs = new float[returnValues];
        for (int i = 0; i < this.diffs.length; ++i) {
            this.diffs[i] = c1[i] - this.C0[i];
        }
        this.output = new float[returnValues];
        this.domain0 = domain[0];
        this.domain1 = domain[1];
    }

    @Override
    public float[] computeStitch(float[] subinput) {
        return this.compute(subinput);
    }

    @Override
    public float[] compute(float[] values) {
        int i;
        float x = PDFExponential.min(PDFExponential.max(values[0], this.domain0), this.domain1);
        if ((double)this.N != 1.0) {
            x = (float)Math.pow(x, this.N);
        }
        for (i = 0; i < this.C0.length; ++i) {
            this.output[i] = this.C0[i] + x * this.diffs[i];
        }
        if (this.range != null) {
            for (i = 0; i < this.C0.length; ++i) {
                this.output[i] = PDFExponential.min(PDFExponential.max(this.output[i], this.range[i * 2]), this.range[i * 2 + 1]);
            }
        }
        return this.output;
    }
}

