/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.fonts.tt.cmap;

import java.util.ArrayList;
import org.jpedal.fonts.tt.FontFile2;
import org.jpedal.fonts.tt.cmap.Format;
import org.jpedal.utils.LogWriter;

public class Format2
implements Format {
    private int[] subHeaders;
    private int[] firstCode;
    private int[] entryCount;
    private int[] idDelta;
    private int[] glyphIdArray;

    @Override
    public boolean readTable(FontFile2 currentFontFile, int subtableID, int[] CMAPlength, int[] CMAPlang) {
        try {
            int idRangeOffset;
            int start = currentFontFile.getPointer() - 2;
            CMAPlength[subtableID] = currentFontFile.getNextUint16();
            CMAPlang[subtableID] = currentFontFile.getNextUint16();
            this.subHeaders = new int[256];
            for (int i2 = 0; i2 < 256; ++i2) {
                this.subHeaders[i2] = currentFontFile.getNextUint16() << 3;
            }
            ArrayList<Integer> raw_firstCode = new ArrayList<Integer>();
            ArrayList<Integer> raw_entryCount = new ArrayList<Integer>();
            ArrayList<Integer> raw_idDelta = new ArrayList<Integer>();
            int glyphsRead = 0;
            do {
                raw_firstCode.add(currentFontFile.getNextUint16());
                int glyphCount = currentFontFile.getNextUint16();
                glyphsRead += glyphCount;
                raw_entryCount.add(glyphCount);
                raw_idDelta.add(currentFontFile.getNextUint16());
                idRangeOffset = currentFontFile.getNextUint16();
            } while (CMAPlength[subtableID] - (currentFontFile.getPointer() - start) > idRangeOffset);
            this.firstCode = raw_firstCode.stream().mapToInt(i -> i).toArray();
            this.entryCount = raw_entryCount.stream().mapToInt(i -> i).toArray();
            this.idDelta = raw_idDelta.stream().mapToInt(i -> i).toArray();
            this.glyphIdArray = new int[glyphsRead];
            for (int glyph = 0; glyph < glyphsRead; ++glyph) {
                this.glyphIdArray[glyph] = currentFontFile.getNextUint16();
            }
        }
        catch (Exception e) {
            LogWriter.writeLog(e);
        }
        return true;
    }

    @Override
    public int getValue(int index, int value) {
        int i = index & 0xFF00;
        int j = index & 0xFF;
        int k = this.subHeaders[i];
        if (j < this.firstCode[i] || j > this.firstCode[i] + this.entryCount[i]) {
            return 0;
        }
        int p = this.glyphIdArray[j];
        if (p == 0) {
            return 0;
        }
        return p + this.idDelta[i];
    }
}

