/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.fonts.tt;

import java.awt.geom.GeneralPath;

class PathData {
    private int x1;
    private int y1;
    private int x2;
    private int y2;
    private int x3;
    private int y3;
    private final int[] pX;
    private final int[] pY;
    private final boolean[] onCurve;
    private final boolean[] endOfContour;
    private boolean isFirstDraw = true;
    boolean checkEnd;
    private final GeneralPath current_path = new GeneralPath(1);

    PathData(int[] pX, int[] pY, boolean[] onCurve, boolean[] endOfContour) {
        this.pX = pX;
        this.pY = pY;
        this.onCurve = onCurve;
        this.endOfContour = endOfContour;
        this.x1 = pX[0];
        this.y1 = pY[0];
        this.current_path.moveTo(this.x1, this.y1);
    }

    public GeneralPath getPath() {
        return this.current_path;
    }

    private static int midPt(int a, int b) {
        return a + (b - a) / 2;
    }

    public void straightLine(int p1) {
        this.x3 = this.pX[p1];
        this.y3 = this.pY[p1];
        this.current_path.lineTo(this.x3, this.y3);
        this.isFirstDraw = false;
    }

    public void moveTo(int x, int y) {
        this.current_path.moveTo(x, y);
    }

    public void completeCurve() {
        this.current_path.curveTo(this.x1, this.y1, this.x2, this.y2, this.x3, this.y3);
    }

    public void closePath() {
        this.current_path.closePath();
    }

    public int calcCurvePoints(int p, int p1, int p2, int pm1, int fc, int j) {
        this.checkEnd = false;
        if (this.onCurve[p] && !this.onCurve[p1] && this.onCurve[p2]) {
            this.x1 = this.pX[p];
            this.y1 = this.pY[p];
            this.x2 = this.pX[p1];
            this.y2 = this.pY[p1];
            this.x3 = this.pX[p2];
            this.y3 = this.pY[p2];
            ++j;
            this.checkEnd = true;
        } else if (this.onCurve[p] && !this.onCurve[p1] && !this.onCurve[p2]) {
            this.x1 = this.pX[p];
            this.y1 = this.pY[p];
            this.x2 = this.pX[p1];
            this.y2 = this.pY[p1];
            this.x3 = PathData.midPt(this.pX[p1], this.pX[p2]);
            this.y3 = PathData.midPt(this.pY[p1], this.pY[p2]);
            ++j;
            this.checkEnd = true;
        } else if (!(this.onCurve[p] || this.onCurve[p1] || this.endOfContour[p2] && fc - p2 != 1)) {
            this.x1 = PathData.midPt(this.pX[pm1], this.pX[p]);
            this.y1 = PathData.midPt(this.pY[pm1], this.pY[p]);
            this.x2 = this.pX[p];
            this.y2 = this.pY[p];
            this.x3 = PathData.midPt(this.pX[p], this.pX[p1]);
            this.y3 = PathData.midPt(this.pY[p], this.pY[p1]);
        } else if (!this.onCurve[p] && this.onCurve[p1]) {
            this.x1 = PathData.midPt(this.pX[pm1], this.pX[p]);
            this.y1 = PathData.midPt(this.pY[pm1], this.pY[p]);
            this.x2 = this.pX[p];
            this.y2 = this.pY[p];
            this.x3 = this.pX[p1];
            this.y3 = this.pY[p1];
        }
        if (this.isFirstDraw) {
            this.current_path.moveTo(this.x1, this.y1);
            this.isFirstDraw = false;
        }
        return j;
    }
}

