/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.color;

import java.util.Arrays;

class LimitedArray {
    private final float[][] keys = new float[256][];
    private final int[] values = new int[256];
    private int iter;
    private float[] lk = new float[0];
    private int lv;

    LimitedArray() {
        for (int i = 0; i < 256; ++i) {
            this.keys[i] = new float[0];
        }
    }

    public int get(float[] k) {
        if (Arrays.equals(this.lk, k)) {
            return this.lv;
        }
        for (int i = 0; i < 256; ++i) {
            int keyLength = this.keys[i].length;
            if (keyLength != k.length) continue;
            boolean matches = true;
            for (int j = 0; j < keyLength; ++j) {
                if (this.keys[i][j] == k[j]) continue;
                matches = false;
                break;
            }
            if (!matches) continue;
            this.lk = this.keys[i];
            this.lv = this.values[i];
            return this.lv;
        }
        return 0;
    }

    public void put(float[] k, int v) {
        this.iter &= 0xFF;
        this.keys[this.iter] = Arrays.copyOf(k, k.length);
        this.values[this.iter] = v;
        this.lk = this.keys[this.iter];
        this.lv = this.values[this.iter];
        ++this.iter;
    }
}

