/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.color;

import com.idrsolutions.image.jpeg2000.EnumeratedSpace;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import org.jpedal.color.FastColorSpaceCMYK;
import org.jpedal.color.GenericColorSpace;
import org.jpedal.color.PdfColor;
import org.jpedal.io.ColorSpaceConvertor;

public class DeviceCMYKColorSpace
extends GenericColorSpace {
    private float lastC = -1.0f;
    private float lastM = -1.0f;
    private float lastY = -1.0f;
    private float lastK = -1.0f;
    private static final ColorSpace CMYK = new FastColorSpaceCMYK();

    @Override
    public void invalidateCaching(int color) {
        super.invalidateCaching(color);
        this.lastC = -1.0f;
        this.lastM = -1.0f;
        this.lastY = -1.0f;
        this.lastK = -1.0f;
    }

    public DeviceCMYKColorSpace() {
        this.componentCount = 4;
        this.cs = CMYK;
        this.setType(1498837125);
    }

    @Override
    public BufferedImage dataToRGB(byte[] data, int width, int height) {
        return ColorSpaceConvertor.convertFromICCCMYK(width, height, data);
    }

    @Override
    public final void setColor(float[] operand) {
        int length = operand.length;
        if (this.getIndexedMap() != null && !this.isConverted) {
            operand = this.flattenIndexedValue(operand);
            length = 4;
        }
        this.c = 1.0f;
        this.y = 1.0f;
        this.m = 1.0f;
        this.k = 1.0f;
        switch (length) {
            case 1: {
                this.c = operand[0];
                this.m = operand[0];
                this.y = operand[0];
                this.k = operand[0];
                break;
            }
            case 2: {
                this.c = operand[0];
                this.m = operand[1];
                break;
            }
            case 3: {
                this.c = operand[0];
                this.m = operand[1];
                this.y = operand[2];
                break;
            }
            default: {
                this.c = operand[0];
                this.m = operand[1];
                this.y = operand[2];
                this.k = operand[3];
            }
        }
        if (this.lastC != this.c || this.lastM != this.m || this.lastY != this.y || this.lastK != this.k) {
            this.lastC = this.c;
            this.lastM = this.m;
            this.lastY = this.y;
            this.lastK = this.k;
            int cc = (int)(this.c * 255.0f);
            int mm = (int)(this.m * 255.0f);
            int yy = (int)(this.y * 255.0f);
            int kk = (int)(this.k * 255.0f);
            int bb = EnumeratedSpace.getStaticRGB(cc, mm, yy, kk);
            this.currentColor = new PdfColor(bb);
        }
    }

    @Override
    public byte[] dataToRGBByteArray(byte[] data, int w, int h) {
        byte[] output = new byte[w * h * 3];
        EnumeratedSpace.convertCMYKToRGB(data, output);
        return output;
    }

    @Override
    public final byte[] convertIndexToRGB(byte[] index) {
        this.isConverted = true;
        return this.convert4Index(index);
    }
}

