/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.pdf.color.shading;

import com.idrsolutions.pdf.color.shading.CoonsContext;
import com.idrsolutions.pdf.color.shading.FreeFormShadeContext;
import com.idrsolutions.pdf.color.shading.LatticeFormShadeContext;
import com.idrsolutions.pdf.color.shading.RadialContext;
import com.idrsolutions.pdf.color.shading.Shading123;
import com.idrsolutions.pdf.color.shading.TensorContext;
import java.awt.PaintContext;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.io.Serializable;
import org.jpedal.color.ColorspaceFactory;
import org.jpedal.color.GenericColorSpace;
import org.jpedal.color.PdfPaint;
import org.jpedal.function.FunctionFactory;
import org.jpedal.function.PDFFunction;
import org.jpedal.io.PdfObjectReader;
import org.jpedal.objects.GraphicsState;
import org.jpedal.objects.raw.PdfArrayIterator;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.parser.ParserOptions;
import org.jpedal.parser.image.PDFObjectToImage;
import org.jpedal.utils.Matrix;

public class ShadedPaint
implements PdfPaint,
Serializable {
    private static final int FUNCTION = 1;
    private static final int AXIAL = 2;
    private static final int RADIAL = 3;
    private static final int FREEFORM = 4;
    private static final int LATTICEFORM = 5;
    private static final int COONS = 6;
    private static final int TENSOR = 7;
    private PDFFunction[] function;
    private int type;
    protected float scaling;
    protected int cropH;
    private float[][] gtm;
    private PaintContext context;
    private ParserOptions parser;
    private PdfObjectReader currentPdfFile;
    private GraphicsState gs;

    public ShadedPaint(PdfObject Shading, GenericColorSpace shadingColorSpace, PdfObjectReader currentPdfFile, float[][] matrix, float[] xobjCoords, GraphicsState gs, ParserOptions parser) {
        this.type = Shading.getInt(1487255197);
        this.currentPdfFile = currentPdfFile;
        this.parser = parser;
        this.gs = gs;
        float[] background = Shading.getFloatArray(1921025959);
        PdfArrayIterator keys = Shading.getMixedArray(1518239089);
        int functionCount = keys.getTokenCount();
        if (functionCount > 0) {
            PdfObject[] subFunction = new PdfObject[functionCount];
            for (int i = 0; i < functionCount; ++i) {
                byte[] nextValue = keys.getNextValueAsByte(true);
                subFunction[i] = ColorspaceFactory.getFunctionObjectFromRefOrDirect(currentPdfFile, nextValue);
            }
            this.function = new PDFFunction[subFunction.length];
            int imax = subFunction.length;
            for (int i1 = 0; i1 < imax; ++i1) {
                this.function[i1] = FunctionFactory.getFunction(subFunction[i1], currentPdfFile);
            }
        }
        switch (this.type) {
            case 1: 
            case 2: {
                this.context = new Shading123(this.type, shadingColorSpace, background, Shading, matrix, this.function, xobjCoords);
                break;
            }
            case 3: {
                this.context = new RadialContext(shadingColorSpace, background, Shading, matrix, this.function);
                break;
            }
            case 4: {
                this.context = new FreeFormShadeContext(shadingColorSpace, background, Shading, matrix, this.function);
                break;
            }
            case 5: {
                this.context = new LatticeFormShadeContext(shadingColorSpace, background, Shading, matrix, this.function);
                break;
            }
            case 6: {
                this.context = new CoonsContext(shadingColorSpace, background, Shading, matrix, this.function);
                break;
            }
            case 7: {
                this.context = new TensorContext(shadingColorSpace, background, Shading, matrix, this.function);
            }
        }
    }

    protected ShadedPaint() {
    }

    @Override
    public PaintContext createContext(ColorModel cm, Rectangle db, Rectangle2D ub, AffineTransform xform, RenderingHints hints) {
        PdfObject gObj;
        PdfObject smask;
        float[][] xm = Matrix.fromAffine(xform);
        BufferedImage lumImage = null;
        float x1 = (float)ub.getMinX();
        float y1 = (float)ub.getMinY();
        float w = (float)ub.getWidth();
        float h = (float)ub.getHeight();
        if (this.gs != null && (smask = this.gs.SMask) != null && (gObj = smask.getDictionary(23)) != null && smask.getNameAsConstant(35) == -2139971891) {
            this.currentPdfFile.checkResolved(gObj);
            w = w == 0.0f ? 1.0f : w;
            h = h == 0.0f ? 3.0f : h;
            lumImage = PDFObjectToImage.getImageFromFloatCoordinates(gObj, x1, x1 + w, y1, y1 + h, this.currentPdfFile, this.parser, 1, 1.0f, true, 1.0f);
        }
        switch (this.type) {
            case 1: 
            case 2: {
                ((Shading123)this.context).updateXForm(xm, this.gtm);
                if (lumImage == null) break;
                ((Shading123)this.context).setLuminosityMask(lumImage, x1, y1);
                break;
            }
            case 3: {
                ((RadialContext)this.context).updateXForm(xm, this.gtm);
                if (lumImage == null) break;
                ((RadialContext)this.context).setLuminosityMask(lumImage, (int)x1, (int)y1);
                break;
            }
            case 4: {
                ((FreeFormShadeContext)this.context).updateXForm(xm, this.gtm);
                if (lumImage == null) break;
                ((FreeFormShadeContext)this.context).setLuminosityMask(lumImage, x1, y1, w, h);
                break;
            }
            case 5: {
                ((LatticeFormShadeContext)this.context).updateXForm(xm, this.gtm);
                break;
            }
            case 6: {
                ((CoonsContext)this.context).updateXForm(xm, this.gtm);
                break;
            }
            case 7: {
                ((TensorContext)this.context).updateXForm(xm, this.gtm);
            }
        }
        return this.context;
    }

    @Override
    public int getTransparency() {
        return 0;
    }

    @Override
    public void setScaling(double cropH, float scaling) {
        this.scaling = scaling;
        this.cropH = (int)cropH;
    }

    @Override
    public boolean isPattern() {
        return true;
    }

    @Override
    public int getRGB() {
        if (this.type == 2) {
            return ((Shading123)this.context).getAverageColor();
        }
        return 0;
    }

    @Override
    public boolean isTexture() {
        return false;
    }

    @Override
    public void setGlyphMatrix(float[][] gtm) {
        this.gtm = gtm;
    }

    @Override
    public void setGS(GraphicsState gs) {
        this.gs = gs;
    }
}

