/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.pdf.color.shading;

import com.idrsolutions.pdf.color.shading.BitReader;
import com.idrsolutions.pdf.color.shading.ShadingFactory;
import com.idrsolutions.pdf.color.shading.ShadingUtils;
import java.awt.PaintContext;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DataBufferInt;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.util.ArrayList;
import java.util.List;
import org.jpedal.color.GenericColorSpace;
import org.jpedal.function.PDFFunction;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.utils.Matrix;

class LatticeFormShadeContext
implements PaintContext {
    private final GenericColorSpace shadingColorSpace;
    private final float[] background;
    private float[][] toUserSpace = Matrix.getIdentity();
    private final float[][] toShadeSpace;
    private final float[] decodeArr;
    private final PDFFunction[] function;
    private final int nComp;
    private final float[] triCoords;
    private final List<Integer> triColors;
    private final int triCount;

    LatticeFormShadeContext(GenericColorSpace shadingColorSpace, float[] background, PdfObject shadingObject, float[][] mm, PDFFunction[] function) {
        this.shadingColorSpace = shadingColorSpace;
        int bitsPerComponent = shadingObject.getInt(-1344207655);
        int bitsPerFlag = shadingObject.getInt(1500422077);
        int bitsPerCoordinate = shadingObject.getInt(-335950113);
        this.decodeArr = shadingObject.getFloatArray(859785322);
        this.function = function;
        this.background = background;
        this.nComp = (this.decodeArr.length - 4) / 2;
        int verticesPerRow = shadingObject.getInt(-1180057884);
        float[][] caller = mm != null ? mm : Matrix.getIdentity();
        Object shadeMatrix = Matrix.getIdentity();
        float[] inputs = shadingObject.getFloatArray(1145198201);
        if (inputs != null) {
            shadeMatrix = new float[][]{{inputs[0], inputs[1], 0.0f}, {inputs[2], inputs[3], 0.0f}, {inputs[4], inputs[5], 1.0f}};
        }
        float[][] shader = Matrix.concatenate(caller, shadeMatrix);
        this.toShadeSpace = Matrix.inverse(shader);
        boolean hasSmallBits = bitsPerFlag < 8 || bitsPerComponent < 8 || bitsPerCoordinate < 8;
        BitReader reader = new BitReader(shadingObject.getDecodedStream(), hasSmallBits);
        double bitCoordScaling = 1.0 / (double)((1L << bitsPerCoordinate) - 1L);
        double bitCompScaling = 1.0 / (double)((1L << bitsPerComponent) - 1L);
        ArrayList<Point2D> trianglesPoints = new ArrayList<Point2D>();
        this.triColors = new ArrayList<Integer>();
        ArrayList<Point2D> pList = new ArrayList<Point2D>();
        ArrayList<Integer> cList = new ArrayList<Integer>();
        while (reader.getPointer() < reader.getTotalBitLen()) {
            Point2D p = LatticeFormShadeContext.getPointCoords(reader, bitCoordScaling, bitsPerCoordinate, this.decodeArr);
            int c = this.getPointColor(reader, bitCompScaling, bitsPerComponent);
            pList.add(p);
            cList.add(c);
        }
        int totalRows = pList.size() / verticesPerRow;
        for (int ii = 0; ii < totalRows - 1; ++ii) {
            int mRows = ii * totalRows;
            for (int nn = 0; nn < verticesPerRow - 1; ++nn) {
                int nm = nn + mRows;
                int[] t = new int[6];
                t[0] = nm;
                t[1] = t[3] = nm + 1;
                t[2] = t[4] = nm + verticesPerRow;
                t[5] = nm + verticesPerRow + 1;
                for (int aT : t) {
                    trianglesPoints.add((Point2D)pList.get(aT));
                    this.triColors.add((Integer)cList.get(aT));
                }
            }
        }
        this.triCoords = new float[trianglesPoints.size() * 2];
        int p = 0;
        for (Point2D trianglesPoint : trianglesPoints) {
            this.triCoords[p++] = (float)trianglesPoint.getX();
            this.triCoords[p++] = (float)trianglesPoint.getY();
        }
        this.triCount = this.triCoords.length / 6;
    }

    public void updateXForm(float[][] xFormMatrix, float[][] gm) {
        float[][] xm = xFormMatrix;
        if (gm != null) {
            xm = Matrix.concatenate(xm, Matrix.inverse(gm));
        }
        this.toUserSpace = Matrix.inverse(xm);
    }

    @Override
    public void dispose() {
    }

    @Override
    public ColorModel getColorModel() {
        return ColorModel.getRGBdefault();
    }

    private static Point2D getPointCoords(BitReader reader, double bitScaling, int bps, float[] decode) {
        long x_ = reader.readBitsAsLong(bps);
        long y_ = reader.readBitsAsLong(bps);
        double x = (double)x_ * bitScaling * (double)(decode[1] - decode[0]) + (double)decode[0];
        double y = (double)y_ * bitScaling * (double)(decode[3] - decode[2]) + (double)decode[2];
        return new Point2D.Double(x, y);
    }

    private int getPointColor(BitReader reader, double bitScaling, int bps) {
        float[] components = new float[this.nComp];
        int i = 0;
        int j = 4;
        while (i < this.nComp) {
            long ci = reader.readBitsAsLong(bps);
            components[i] = (float)((double)ci * bitScaling * (double)(this.decodeArr[j + 1] - this.decodeArr[j]) + (double)this.decodeArr[j]);
            ++i;
            j += 2;
        }
        return this.calculateColor(components);
    }

    @Override
    public Raster getRaster(int startX, int startY, int w, int h) {
        WritableRaster raster = new BufferedImage(w, h, 2).getRaster();
        int[] data = ((DataBufferInt)raster.getDataBuffer()).getData();
        if (this.background != null) {
            ShadingUtils.setBackground(w, h, data, this.shadingColorSpace, this.background);
        }
        for (int i = 0; i < h; ++i) {
            block1: for (int j = 0; j < w; ++j) {
                float[] src = new float[]{startX + j, startY + i};
                src = Matrix.transformPoint(this.toUserSpace, src[0], src[1]);
                src = Matrix.transformPoint(this.toShadeSpace, src[0], src[1]);
                float x = src[0];
                float y = src[1];
                for (int t = 0; t < this.triCount; ++t) {
                    int p = t * 3;
                    int pp = p << 1;
                    float x1 = this.triCoords[pp];
                    float y1 = this.triCoords[pp + 1];
                    float x2 = this.triCoords[pp + 2];
                    float y2 = this.triCoords[pp + 3];
                    float x3 = this.triCoords[pp + 4];
                    float y3 = this.triCoords[pp + 5];
                    float d1 = x - x3;
                    float d2 = x3 - x2;
                    float d3 = x1 - x3;
                    float d4 = y - y3;
                    float d5 = y2 - y3;
                    float d = d5 * d3 + d2 * (y1 - y3);
                    if (d == 0.0f) continue;
                    float w1 = (d5 * d1 + d2 * d4) / d;
                    float w2 = ((y3 - y1) * d1 + d3 * d4) / d;
                    float w3 = 1.0f - w1 - w2;
                    if (w1 < 0.0f || w2 < 0.0f || w3 < 0.0f) continue;
                    int c1 = this.triColors.get(p);
                    int c2 = this.triColors.get(p + 1);
                    int c3 = this.triColors.get(p + 2);
                    int v1 = c1 >> 16 & 0xFF;
                    int v2 = c2 >> 16 & 0xFF;
                    int v3 = c3 >> 16 & 0xFF;
                    int r = (int)(w1 * (float)v1 + w2 * (float)v2 + w3 * (float)v3);
                    v1 = c1 >> 8 & 0xFF;
                    v2 = c2 >> 8 & 0xFF;
                    v3 = c3 >> 8 & 0xFF;
                    int g = (int)(w1 * (float)v1 + w2 * (float)v2 + w3 * (float)v3);
                    v1 = c1 & 0xFF;
                    v2 = c2 & 0xFF;
                    v3 = c3 & 0xFF;
                    int b = (int)(w1 * (float)v1 + w2 * (float)v2 + w3 * (float)v3);
                    data[i * w + j] = 0xFF000000 | r << 16 | g << 8 | b;
                    continue block1;
                }
            }
        }
        return raster;
    }

    private int calculateColor(float[] val) {
        if (this.function != null) {
            float[] colValues = ShadingFactory.applyFunctions(this.function, val);
            this.shadingColorSpace.setColor(colValues);
        } else {
            this.shadingColorSpace.setColor(val);
        }
        return this.shadingColorSpace.getColor().getRGB();
    }
}

