/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.utility;

import com.idrsolutions.image.utility.DataWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class WriterFileBig
implements DataWriter {
    private static final int MAXLEN = 8192;
    private static final int MINP = 8182;
    private int p;
    private int len;
    private final OutputStream out;
    private final byte[] buf = new byte[8192];

    public WriterFileBig(File file) throws IOException {
        this.out = new FileOutputStream(file);
    }

    public WriterFileBig(OutputStream stream) {
        this.out = stream;
    }

    @Override
    public void putU8(int x) throws IOException {
        if (this.p > 8182) {
            this.flushNow();
        }
        this.buf[this.p++] = (byte)x;
    }

    @Override
    public void putU16(int x) throws IOException {
        if (this.p > 8182) {
            this.flushNow();
        }
        this.buf[this.p++] = (byte)(x >>> 8 & 0xFF);
        this.buf[this.p++] = (byte)(x & 0xFF);
    }

    @Override
    public void putU24(int x) throws IOException {
        if (this.p > 8182) {
            this.flushNow();
        }
        this.buf[this.p++] = (byte)(x >>> 16 & 0xFF);
        this.buf[this.p++] = (byte)(x >>> 8 & 0xFF);
        this.buf[this.p++] = (byte)(x & 0xFF);
    }

    @Override
    public void putU32(int x) throws IOException {
        if (this.p > 8182) {
            this.flushNow();
        }
        this.buf[this.p++] = (byte)(x >>> 24 & 0xFF);
        this.buf[this.p++] = (byte)(x >>> 16 & 0xFF);
        this.buf[this.p++] = (byte)(x >>> 8 & 0xFF);
        this.buf[this.p++] = (byte)(x & 0xFF);
    }

    @Override
    public void putU64(long x) throws IOException {
        if (this.p > 8182) {
            this.flushNow();
        }
        this.buf[this.p++] = (byte)(x >>> 56 & 0xFFL);
        this.buf[this.p++] = (byte)(x >>> 48 & 0xFFL);
        this.buf[this.p++] = (byte)(x >>> 40 & 0xFFL);
        this.buf[this.p++] = (byte)(x >>> 32 & 0xFFL);
        this.buf[this.p++] = (byte)(x >>> 24 & 0xFFL);
        this.buf[this.p++] = (byte)(x >>> 16 & 0xFFL);
        this.buf[this.p++] = (byte)(x >>> 8 & 0xFFL);
        this.buf[this.p++] = (byte)(x & 0xFFL);
    }

    @Override
    public void write(byte[] copyTo) throws IOException {
        if (copyTo.length + this.p > 8182) {
            this.flushNow();
            this.out.write(copyTo);
            this.len += copyTo.length;
        } else {
            System.arraycopy(copyTo, 0, this.buf, this.p, copyTo.length);
            this.p += copyTo.length;
        }
    }

    @Override
    public int getLength() {
        return this.len + this.p;
    }

    private void flushNow() throws IOException {
        this.out.write(this.buf, 0, this.p);
        this.len += this.p;
        this.p = 0;
        this.out.flush();
    }

    @Override
    public void close() throws IOException {
        this.flushNow();
        this.out.close();
    }
}

