/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.utility;

import com.idrsolutions.image.utility.DataWriter;

public class WriterByteBig
implements DataWriter {
    private int p;
    private final byte[] dd;

    public WriterByteBig(byte[] data) {
        this.dd = data;
    }

    @Override
    public void putU8(int x) {
        this.dd[this.p++] = (byte)x;
    }

    @Override
    public void putU16(int v) {
        this.dd[this.p++] = (byte)(v >> 8 & 0xFF);
        this.dd[this.p++] = (byte)(v & 0xFF);
    }

    @Override
    public void putU24(int v) {
        this.dd[this.p++] = (byte)(v >> 16 & 0xFF);
        this.dd[this.p++] = (byte)(v >> 8 & 0xFF);
        this.dd[this.p++] = (byte)(v & 0xFF);
    }

    @Override
    public void putU32(int v) {
        this.dd[this.p++] = (byte)(v >> 24 & 0xFF);
        this.dd[this.p++] = (byte)(v >> 16 & 0xFF);
        this.dd[this.p++] = (byte)(v >> 8 & 0xFF);
        this.dd[this.p++] = (byte)(v & 0xFF);
    }

    @Override
    public void putU64(long v) {
        this.dd[this.p++] = (byte)(v >> 56 & 0xFFL);
        this.dd[this.p++] = (byte)(v >> 48 & 0xFFL);
        this.dd[this.p++] = (byte)(v >> 40 & 0xFFL);
        this.dd[this.p++] = (byte)(v >> 32 & 0xFFL);
        this.dd[this.p++] = (byte)(v >> 24 & 0xFFL);
        this.dd[this.p++] = (byte)(v >> 16 & 0xFFL);
        this.dd[this.p++] = (byte)(v >> 8 & 0xFFL);
        this.dd[this.p++] = (byte)(v & 0xFFL);
    }

    @Override
    public void write(byte[] copyTo) {
        System.arraycopy(copyTo, 0, this.dd, this.p, copyTo.length);
        this.p += copyTo.length;
    }

    public void seek(int v) {
        this.p = v;
    }

    @Override
    public int getLength() {
        return this.dd.length;
    }

    public int getPosition() {
        return this.p;
    }

    @Override
    public void close() {
    }
}

