/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.utility;

import com.idrsolutions.image.Encoder;
import com.idrsolutions.image.bmp.BmpEncoder;
import com.idrsolutions.image.bmp.options.BmpEncoderOptions;
import com.idrsolutions.image.encoder.OutputFormat;
import com.idrsolutions.image.encoder.options.EncoderOptions;
import com.idrsolutions.image.heic.HeicEncoder;
import com.idrsolutions.image.heic.options.HeicEncoderOptions;
import com.idrsolutions.image.jpeg.JpegEncoder;
import com.idrsolutions.image.jpeg.options.JpegEncoderOptions;
import com.idrsolutions.image.jpeg2000.Jpeg2000Encoder;
import com.idrsolutions.image.jpeg2000.options.Jpeg2000EncoderOptions;
import com.idrsolutions.image.pdf.PdfEncoder;
import com.idrsolutions.image.pdf.options.PdfEncoderOptions;
import com.idrsolutions.image.png.PngEncoder;
import com.idrsolutions.image.png.options.PngEncoderOptions;
import com.idrsolutions.image.tiff.TiffEncoder;
import com.idrsolutions.image.tiff.options.TiffEncoderOptions;
import com.idrsolutions.image.webp.WebpEncoder;
import com.idrsolutions.image.webp.options.WebpEncoderOptions;

public final class SupportedFormats {
    private static final String[][] supportedEncoders;
    private static final String[][] supportedDecoders;
    private static final Object[][] enumFromString;

    private SupportedFormats() {
    }

    public static Encoder getEncoder(OutputFormat format, EncoderOptions options) {
        switch (format) {
            case BMP: {
                return new BmpEncoder(options);
            }
            case HEIC: {
                return new HeicEncoder(options);
            }
            case JPEG: {
                return new JpegEncoder(options);
            }
            case JPEG2000: {
                return new Jpeg2000Encoder(options);
            }
            case PDF: {
                return new PdfEncoder(options);
            }
            case PNG: {
                return new PngEncoder(options);
            }
            case TIFF: {
                return new TiffEncoder((TiffEncoderOptions)options);
            }
            case WEBP: {
                return new WebpEncoder(options);
            }
        }
        return null;
    }

    public static EncoderOptions getEncoderOptions(OutputFormat format) {
        switch (format) {
            case BMP: {
                return new BmpEncoderOptions();
            }
            case HEIC: {
                return new HeicEncoderOptions();
            }
            case JPEG: {
                return new JpegEncoderOptions();
            }
            case JPEG2000: {
                return new Jpeg2000EncoderOptions();
            }
            case PDF: {
                return new PdfEncoderOptions();
            }
            case PNG: {
                return new PngEncoderOptions();
            }
            case TIFF: {
                return new TiffEncoderOptions();
            }
            case WEBP: {
                return new WebpEncoderOptions();
            }
        }
        return null;
    }

    public static String[][] getSupportedImageEncoders() {
        return supportedEncoders;
    }

    public static String[][] getSupportedImageDecoders() {
        return supportedDecoders;
    }

    public static boolean hasEncoderSupportForImageFormat(String format) {
        boolean formatFound = false;
        if (format != null && !format.isEmpty()) {
            String[][] stringArray = supportedEncoders;
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String[] supportedAlternative;
                for (String supported : supportedAlternative = stringArray[i]) {
                    if (!supported.equalsIgnoreCase(format)) continue;
                    formatFound = true;
                    break;
                }
                if (formatFound) break;
            }
        }
        return formatFound;
    }

    public static boolean hasDecoderSupportForImageFormat(String format) {
        boolean formatFound = false;
        if (format != null && !format.isEmpty()) {
            String[][] stringArray = supportedDecoders;
            int n = stringArray.length;
            block0: for (int i = 0; i < n; ++i) {
                String[] supportedAlternative;
                for (String supported : supportedAlternative = stringArray[i]) {
                    if (!supported.equalsIgnoreCase(format)) continue;
                    formatFound = true;
                    continue block0;
                }
            }
        }
        return formatFound;
    }

    public static OutputFormat getEnumFromString(String format) {
        if (format != null && !format.isEmpty()) {
            format = format.toLowerCase();
            Object[][] objectArray = enumFromString;
            int n = objectArray.length;
            for (int i = 0; i < n; ++i) {
                Object[] supported;
                for (Object supportedl : supported = objectArray[i]) {
                    if (!supportedl.equals(format)) continue;
                    return (OutputFormat)((Object)supported[0]);
                }
            }
        }
        return null;
    }

    static {
        ClassLoader loader = SupportedFormats.class.getClassLoader();
        String jdeliClassPath = "com/idrsolutions/image/JDeli.class";
        boolean iSJDeliPresent = loader.getResource("com/idrsolutions/image/JDeli.class") != null;
        supportedDecoders = iSJDeliPresent ? new String[][]{{"bmp"}, {"dcm"}, {"emf"}, {"gif"}, {"heic", "heif"}, {"jpx", "jp2"}, {"jpeg", "jpg"}, {"png"}, {"psd"}, {"sgi", "rgb"}, {"tif", "tiff"}, {"webp"}, {"wmf"}} : new String[][]{{"bmp"}, {"gif"}, {"jpx", "jp2"}, {"jpeg", "jpg"}, {"png"}, {"tif", "tiff"}};
        supportedEncoders = new String[][]{{"bmp"}, {"heic", "heif"}, {"jpeg", "jpg"}, {"jpx", "jp2"}, {"pdf"}, {"png"}, {"tif", "tiff"}, {"webp"}};
        enumFromString = new Object[][]{{OutputFormat.BMP, "bmp"}, {OutputFormat.HEIC, "heic", "heif"}, {OutputFormat.JPEG, "jpeg", "jpg"}, {OutputFormat.JPEG2000, "jpx", "jp2"}, {OutputFormat.PDF, "pdf"}, {OutputFormat.PNG, "png"}, {OutputFormat.TIFF, "tif", "tiff"}, {OutputFormat.WEBP, "webp"}};
    }
}

