/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.utility;

import com.idrsolutions.image.utility.PixGet;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferUShort;

public class PixGet8
implements PixGet {
    private final short[] pix;
    private final int stripe;
    private int p;
    private int r;
    private int g;
    private int b;

    public PixGet8(BufferedImage image) {
        this.pix = ((DataBufferUShort)image.getRaster().getDataBuffer()).getData();
        this.stripe = image.getWidth();
    }

    @Override
    public boolean hasAlpha() {
        return false;
    }

    @Override
    public int getRGB(int x, int y) {
        this.p = this.pix[y * this.stripe + x] & 0xFFFF;
        this.r = (this.p >> 11) * 255 / 31;
        this.g = (this.p >> 5 & 0x3F) * 255 / 63;
        this.b = (this.p & 0x1F) * 255 / 31;
        return this.r << 16 | this.g << 8 | this.b;
    }

    @Override
    public int getARGB(int x, int y) {
        this.p = this.pix[y * this.stripe + x] & 0xFFFF;
        this.r = (this.p >> 11) * 255 / 31;
        this.g = (this.p >> 5 & 0x3F) * 255 / 63;
        this.b = (this.p & 0x1F) * 255 / 31;
        return 0xFF000000 | this.r << 16 | this.g << 8 | this.b;
    }
}

