/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.utility;

import com.idrsolutions.image.utility.PixGet;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;

public class PixGet7
implements PixGet {
    private final byte[] pix;
    private final int stripe;
    private int a;
    private int r;
    private int g;
    private int b;
    private int p;

    public PixGet7(BufferedImage image) {
        this.pix = ((DataBufferByte)image.getRaster().getDataBuffer()).getData();
        this.stripe = image.getWidth() * 4;
    }

    @Override
    public boolean hasAlpha() {
        return true;
    }

    @Override
    public int getRGB(int x, int y) {
        this.p = y * this.stripe + x * 4;
        this.a = this.pix[this.p] & 0xFF;
        this.b = this.pix[this.p + 1] & 0xFF;
        this.g = this.pix[this.p + 2] & 0xFF;
        this.r = this.pix[this.p + 3] & 0xFF;
        return this.a << 24 | this.r << 16 | this.g << 8 | this.b;
    }

    @Override
    public int getARGB(int x, int y) {
        this.p = y * this.stripe + x * 4;
        this.a = this.pix[this.p] & 0xFF;
        this.b = this.pix[this.p + 1] & 0xFF;
        this.g = this.pix[this.p + 2] & 0xFF;
        this.r = this.pix[this.p + 3] & 0xFF;
        return this.a << 24 | this.r << 16 | this.g << 8 | this.b;
    }
}

