/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.utility;

import com.idrsolutions.image.ImageFormat;
import com.idrsolutions.image.utility.DataByteBig;
import com.idrsolutions.image.utility.DataByteLittle;

public final class ImageTypeFinder {
    private static boolean isHeic(byte[] data) {
        if (data[4] != 102 || data[5] != 116 || data[6] != 121 || data[7] != 112) {
            return false;
        }
        String brand = new String(data, 8, 4);
        if ("heic".equals(brand) || "heix".equals(brand) || "avif".equals(brand)) {
            return true;
        }
        brand = new String(data);
        return brand.contains("heic") || brand.contains("heix") || brand.contains("avif");
    }

    private ImageTypeFinder() {
    }

    private static boolean isPNG(byte[] data) {
        byte[] pngMark = new byte[]{-119, 80, 78, 71, 13, 10, 26, 10};
        for (int i = 0; i < pngMark.length; ++i) {
            if (data[i] == pngMark[i]) continue;
            return false;
        }
        return true;
    }

    private static boolean isTiff(byte[] data) {
        return data[0] == 73 && data[1] == 73 || data[0] == 77 && data[1] == 77;
    }

    private static boolean isJpeg(byte[] data) {
        return (data[0] & 0xFF) == 255 && (data[1] & 0xFF) == 216;
    }

    private static boolean isJpeg2000(byte[] data) {
        if ((data[0] & 0xFF) == 255 && (data[1] & 0xFF) == 79) {
            return true;
        }
        DataByteBig buff = new DataByteBig(data);
        int signLen = buff.getU32();
        int signType = buff.getU32();
        return signLen == 12 && signType == 1783636000;
    }

    private static boolean isGif(byte[] data) {
        return data[0] == 71 && data[1] == 73 && data[2] == 70 && data[3] == 56 && data[4] == 55 | data[4] == 57 && data[5] == 97;
    }

    private static boolean isPsd(byte[] data) {
        DataByteBig buff = new DataByteBig(data);
        int signLen = buff.getU32();
        return signLen == 943870035;
    }

    private static boolean isWebp(byte[] data) {
        String str = new String(data);
        return str.startsWith("RIFF") && str.contains("WEBP");
    }

    private static boolean isBmp(byte[] data) {
        int TYPE_BM = 19778;
        int type = data[0] & 0xFF | (data[1] & 0xFF) << 8;
        return type == 19778;
    }

    private static boolean isDicom(byte[] data) {
        return data.length > 132 && data[128] == 68 && data[129] == 73 && data[130] == 67 && data[131] == 77;
    }

    private static boolean isSGI(byte[] data) {
        int sgi474 = data[0] << 8 | data[1] & 0xFF;
        byte format = data[2];
        return sgi474 == 474 && (format == 0 || format == 1);
    }

    private static boolean isWMF(byte[] data) {
        DataByteLittle reader = new DataByteLittle(data);
        int key = reader.getU32();
        return key == -1698247209;
    }

    private static boolean isEMF(byte[] data) {
        DataByteLittle reader = new DataByteLittle(data);
        int key = reader.getU32();
        return key == 1;
    }

    public static ImageFormat getImageType(byte[] test) {
        if (ImageTypeFinder.isBmp(test)) {
            return ImageFormat.BMP_IMAGE;
        }
        if (ImageTypeFinder.isDicom(test)) {
            return ImageFormat.DICOM_IMAGE;
        }
        if (ImageTypeFinder.isEMF(test)) {
            return ImageFormat.EMF_IMAGE;
        }
        if (ImageTypeFinder.isGif(test)) {
            return ImageFormat.GIF_IMAGE;
        }
        if (ImageTypeFinder.isHeic(test)) {
            return ImageFormat.HEIC_IMAGE;
        }
        if (ImageTypeFinder.isJpeg(test)) {
            return ImageFormat.JPEG_IMAGE;
        }
        if (ImageTypeFinder.isJpeg2000(test)) {
            return ImageFormat.JPEG2000_IMAGE;
        }
        if (ImageTypeFinder.isPNG(test)) {
            return ImageFormat.PNG_IMAGE;
        }
        if (ImageTypeFinder.isPsd(test)) {
            return ImageFormat.PSD_IMAGE;
        }
        if (ImageTypeFinder.isTiff(test)) {
            return ImageFormat.TIFF_IMAGE;
        }
        if (ImageTypeFinder.isWebp(test)) {
            return ImageFormat.WEBP_IMAGE;
        }
        if (ImageTypeFinder.isSGI(test)) {
            return ImageFormat.SGI_IMAGE;
        }
        if (ImageTypeFinder.isWMF(test)) {
            return ImageFormat.WMF_IMAGE;
        }
        return ImageFormat.UNSUPPORTED_IMAGE;
    }
}

