/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.tiff;

import java.util.HashMap;

public enum IFDKeys {
    ImageWidth(256),
    ImageHeight(257),
    BitsPerSample(258),
    Compression(259),
    PhotometricInterpolation(262),
    FillOrder(266),
    StripOffsets(273),
    SamplesPerPixel(277),
    RowsPerStrip(278),
    StripByteCounts(279),
    Xresolution(282),
    Yresolution(283),
    PlanarConfiguration(284),
    T4Options(292),
    T6Options(293),
    ResolutionUnit(296),
    Predictor(317),
    ColorMap(320),
    TileWidth(322),
    TileLength(323),
    TIleOffsets(324),
    TIleByteCounts(325),
    SampleFormat(339),
    JPEGTables(347),
    JPEGProc(512),
    JPEGInterchangeFormat(513),
    JPEGInterchangeFormatLength(514),
    JPEGRestartInterval(515),
    JPEGQTables(519),
    JPEGDCTables(520),
    JPEGACTables(521),
    XMP(700),
    ICC(34675),
    JDELI_UNSUPPORTED(-1);

    final int value;
    private static final HashMap<Integer, IFDKeys> lookup;

    private IFDKeys(int val) {
        this.value = val;
    }

    public static IFDKeys getIFDKey(int val) {
        IFDKeys key = lookup.get(val);
        if (key == null) {
            return JDELI_UNSUPPORTED;
        }
        return key;
    }

    static {
        lookup = new HashMap();
        for (IFDKeys value : IFDKeys.values()) {
            lookup.put(value.value, value);
        }
    }
}

