/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.heic.common;

final class HeicMath {
    private HeicMath() {
    }

    static int clip3(int x, int y, int z) {
        return z < x ? x : Math.min(z, y);
    }

    static int clipBitDepth(int v, int bitDepth) {
        int z = (1 << bitDepth) - 1;
        return Math.max(0, Math.min(v, z));
    }

    static int log2(int bits) {
        int log = 0;
        if ((bits & 0xFFFF0000) != 0) {
            bits >>>= 16;
            log = 16;
        }
        if (bits > 255) {
            bits >>>= 8;
            log += 8;
        }
        if (bits > 15) {
            bits >>>= 4;
            log += 4;
        }
        if (bits > 3) {
            bits >>>= 2;
            log += 2;
        }
        return log + (bits >>> 1);
    }

    static int log2Ceil(int val) {
        int n = 0;
        while (val > 1 << n) {
            ++n;
        }
        return n;
    }

    static int ceilDiv(int num, int denom) {
        return (num + denom - 1) / denom;
    }
}

