/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.heic;

import com.idrsolutions.image.Encoder;
import com.idrsolutions.image.JDeliImage;
import com.idrsolutions.image.encoder.options.EncoderOptions;
import com.idrsolutions.image.heic.common.HStruct;
import com.idrsolutions.image.heic.options.HeicEncoderOptions;
import com.idrsolutions.image.util.ImageUtils;
import com.idrsolutions.image.utility.ByteWriter;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.OutputStream;

public class HeicEncoder
extends JDeliImage
implements Encoder {
    private HeicEncoderOptions encoderOptions = new HeicEncoderOptions();

    public HeicEncoder(EncoderOptions format) {
        if (format != null) {
            this.encoderOptions = (HeicEncoderOptions)format;
        }
    }

    public HeicEncoder() {
    }

    public HeicEncoderOptions getEncoderOptions() {
        return this.encoderOptions;
    }

    public void setEncoderOptions(HeicEncoderOptions encoderOptions) {
        this.encoderOptions = encoderOptions;
    }

    @Override
    public void write(BufferedImage image, OutputStream bos) throws IOException {
        BufferedImage imageToCompress = ImageUtils.fixSubBufferedImage(image);
        ByteWriter writer = new ByteWriter();
        HStruct.write(imageToCompress, writer);
        writer.writeToStream(bos);
    }
}

