/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image;

import com.idrsolutions.image.Decoder;
import com.idrsolutions.image.Encoder;
import com.idrsolutions.image.ImageFormat;
import com.idrsolutions.image.JDeliImage;
import com.idrsolutions.image.bmp.BmpDecoder;
import com.idrsolutions.image.bmp.options.BmpMetadata;
import com.idrsolutions.image.encoder.OutputFormat;
import com.idrsolutions.image.encoder.options.EncoderOptions;
import com.idrsolutions.image.encoder.options.Metadata;
import com.idrsolutions.image.gif.GifDecoder;
import com.idrsolutions.image.gif.options.GifMetadata;
import com.idrsolutions.image.heic.options.HeicMetadata;
import com.idrsolutions.image.jpeg.ARGBJpegDecoder;
import com.idrsolutions.image.jpeg.JpegDecoder;
import com.idrsolutions.image.jpeg2000.Jpeg2000Decoder;
import com.idrsolutions.image.jpeg2000.options.Jpeg2000Metadata;
import com.idrsolutions.image.jpeg2000.options.JpegMetadata;
import com.idrsolutions.image.pdf.PdfEncoder;
import com.idrsolutions.image.png.PngDecoder;
import com.idrsolutions.image.png.options.PngMetadata;
import com.idrsolutions.image.process.ImageProcessingOps;
import com.idrsolutions.image.tiff.TiffDecoder;
import com.idrsolutions.image.tiff.TiffEncoder;
import com.idrsolutions.image.tiff.options.TiffMetadata;
import com.idrsolutions.image.utility.ImageTypeFinder;
import com.idrsolutions.image.utility.SupportedFormats;
import com.idrsolutions.image.webp.options.WebpMetadata;
import java.awt.image.BufferedImage;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.HashMap;
import org.jpedal.utils.LogWriter;

public class JDeli
extends JDeliImage {
    public static void convert(File inputFile, File outputFile) throws Exception {
        JDeli.convert(inputFile, outputFile, null);
    }

    public static void convert(File inputFile, EncoderOptions outputOptions, File outputFile) throws Exception {
        OutputFormat inputFormatName = SupportedFormats.getEnumFromString(JDeli.getFileFormat(inputFile.getAbsolutePath()));
        JDeli.convert(inputFormatName, inputFile, null, outputFile, outputOptions);
    }

    public static void convert(File inputFile, File outputFile, ImageProcessingOps conversions) throws Exception {
        OutputFormat inputFormatName = SupportedFormats.getEnumFromString(JDeli.getFileFormat(inputFile.getAbsolutePath()));
        OutputFormat formatName = SupportedFormats.getEnumFromString(JDeli.getFileFormat(outputFile.getAbsolutePath()));
        if (formatName == null) {
            throw new IOException("No filetype specified in path " + outputFile);
        }
        EncoderOptions enc = SupportedFormats.getEncoderOptions(formatName);
        JDeli.convert(inputFormatName, inputFile, conversions, outputFile, enc);
    }

    static void convert(OutputFormat inputFormatName, File inputFile, ImageProcessingOps conversions, File outputFile, EncoderOptions options) throws Exception {
        if (inputFile != null) {
            if (inputFormatName == OutputFormat.TIFF) {
                if (options.getOutputFormat() == OutputFormat.PDF) {
                    PdfEncoder pdf = new PdfEncoder();
                    pdf.write(inputFile, outputFile);
                } else {
                    TiffDecoder decoder = new TiffDecoder();
                    int imageCount = decoder.getImageCount(inputFile);
                    TiffEncoder tiff = new TiffEncoder();
                    for (int i = 0; i < imageCount; ++i) {
                        BufferedImage image = decoder.readImageAt(i, inputFile);
                        if (conversions != null) {
                            image = conversions.apply(image);
                        }
                        if (imageCount <= 1) {
                            JDeli.write(image, options, outputFile);
                            continue;
                        }
                        if (options.getOutputFormat() == OutputFormat.TIFF) {
                            tiff.append(image, outputFile.getAbsolutePath());
                            continue;
                        }
                        JDeli.write(image, options, new File(outputFile.getAbsolutePath().substring(0, outputFile.getAbsolutePath().lastIndexOf(46)) + "_page_" + (i + 1) + '.' + JDeli.getFileFormat(outputFile.getAbsolutePath())));
                    }
                }
            } else if ("dcm".equalsIgnoreCase(JDeli.getFileFormat(inputFile.getAbsolutePath()))) {
                Decoder decoder = JDeli.getDecoder(ImageFormat.DICOM_IMAGE);
                if (decoder != null) {
                    int imageCount = decoder.getImageCount(inputFile);
                    for (int i = 0; i < imageCount; ++i) {
                        BufferedImage image = decoder.readImageAt(i, inputFile);
                        if (conversions != null) {
                            image = conversions.apply(image);
                        }
                        if (options.getOutputFormat() == OutputFormat.PDF || imageCount <= 1) {
                            JDeli.write(image, options, outputFile);
                            continue;
                        }
                        if (options.getOutputFormat() == OutputFormat.TIFF) {
                            TiffEncoder tiff = new TiffEncoder();
                            tiff.append(image, outputFile.getAbsolutePath());
                            continue;
                        }
                        JDeli.write(image, options, new File(outputFile.getAbsolutePath().substring(0, outputFile.getAbsolutePath().lastIndexOf(46)) + "_page_" + (i + 1) + '.' + JDeli.getFileFormat(outputFile.getAbsolutePath())));
                    }
                }
            } else {
                BufferedImage image = JDeli.read(inputFile, null);
                if (conversions != null) {
                    image = conversions.apply(image);
                }
                JDeli.write(image, options, outputFile);
            }
        }
    }

    public static BufferedImage process(ImageProcessingOps conversions, BufferedImage image) {
        if (conversions != null) {
            return conversions.apply(image);
        }
        return image;
    }

    static String getFileFormat(String absolutePath) {
        int pos = absolutePath.lastIndexOf(46);
        if (pos == -1 && pos == absolutePath.length() - 1) {
            return null;
        }
        return absolutePath.substring(pos + 1);
    }

    public static void convert(InputStream inputFile, OutputStream outputFile, String format) throws Exception {
        BufferedImage image = JDeli.read(inputFile);
        JDeli.write(image, format, outputFile);
    }

    public static byte[] convert(byte[] inputData, String format) throws Exception {
        BufferedImage image = JDeli.read(inputData);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        JDeli.write(image, format, (OutputStream)bos);
        bos.close();
        return bos.toByteArray();
    }

    public static Metadata getImageInfo(File imageFile) throws Exception {
        byte[] bytes = JDeli.getTestBytes(imageFile);
        if (bytes.length == 0) {
            throw new RuntimeException("Zero Length file " + imageFile);
        }
        ImageFormat type = ImageTypeFinder.getImageType(bytes);
        Metadata metadata = JDeli.getImageMetadataType(type);
        JDeli.setImageMetaData(metadata, imageFile.getPath(), type);
        return metadata;
    }

    public static Metadata getImageInfo(byte[] imageBytes) throws Exception {
        File tempFile = File.createTempFile("jdeli-", ".tmp");
        Files.write(tempFile.toPath(), imageBytes, new OpenOption[0]);
        Metadata metadata = JDeli.getImageInfo(tempFile);
        tempFile.delete();
        return metadata;
    }

    public static Metadata getImageInfo(InputStream inputStream) throws Exception {
        File tempFile = File.createTempFile("jdeli-", ".tmp");
        byte[] buffer = new byte[inputStream.available()];
        inputStream.read(buffer);
        try (FileOutputStream os = new FileOutputStream(tempFile);){
            os.write(buffer);
            os.flush();
        }
        Metadata metadata = JDeli.getImageInfo(tempFile);
        inputStream.close();
        tempFile.delete();
        return metadata;
    }

    private static Object getClassFromPath(String path) {
        Object instance = null;
        try {
            Class<?> c = Class.forName(path);
            instance = c.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ReflectiveOperationException ex) {
            LogWriter.writeLog(ex);
        }
        return instance;
    }

    private static Metadata getImageMetadataType(ImageFormat imageType) {
        switch (imageType) {
            case BMP_IMAGE: {
                return new BmpMetadata();
            }
            case DICOM_IMAGE: {
                return (Metadata)JDeli.getClassFromPath("com.idrsolutions.image.dicom.options.DicomMetadata");
            }
            case EMF_IMAGE: {
                return (Metadata)JDeli.getClassFromPath("com.idrsolutions.image.emf.options.EmfMetadata");
            }
            case GIF_IMAGE: {
                return new GifMetadata();
            }
            case HEIC_IMAGE: {
                return new HeicMetadata();
            }
            case JPEG_IMAGE: {
                return new JpegMetadata();
            }
            case JPEG2000_IMAGE: {
                return new Jpeg2000Metadata();
            }
            case PNG_IMAGE: {
                return new PngMetadata();
            }
            case PSD_IMAGE: {
                return (Metadata)JDeli.getClassFromPath("com.idrsolutions.image.psd.options.PsdMetadata");
            }
            case SGI_IMAGE: {
                return (Metadata)JDeli.getClassFromPath("com.idrsolutions.image.sgi.options.SgiMetadata");
            }
            case TIFF_IMAGE: {
                return new TiffMetadata();
            }
            case WEBP_IMAGE: {
                return new WebpMetadata();
            }
            case WMF_IMAGE: {
                return (Metadata)JDeli.getClassFromPath("com.idrsolutions.image.wmf.options.WmfMetadata");
            }
        }
        return null;
    }

    private static void setImageMetaData(Metadata metadata, String imageFile, ImageFormat type) throws Exception {
        BufferedImage img = JDeli.getBufferedImage(new File(imageFile), type, metadata);
        if (img != null) {
            metadata.setHeight(img.getHeight());
            metadata.setWidth(img.getWidth());
            metadata.setReadable(JDeli.isImageSupportedForInput(imageFile.substring(imageFile.lastIndexOf(46) + 1)));
            metadata.setWritable(JDeli.isImageSupportedForOutput(imageFile.substring(imageFile.lastIndexOf(46) + 1)));
        }
    }

    public static BufferedImage read(File imageFile) throws Exception {
        byte[] bytes = JDeli.getTestBytes(imageFile);
        if (bytes.length == 0) {
            throw new RuntimeException("Zero Length file " + imageFile);
        }
        ImageFormat type = ImageTypeFinder.getImageType(bytes);
        return JDeli.getBufferedImage(imageFile, type, null);
    }

    private static Decoder getDecoder(ImageFormat type) {
        switch (type) {
            case BMP_IMAGE: {
                return new BmpDecoder();
            }
            case DICOM_IMAGE: {
                return (Decoder)JDeli.getClassFromPath("com.idrsolutions.image.dicom.DicomDecoder");
            }
            case EMF_IMAGE: {
                return (Decoder)JDeli.getClassFromPath("com.idrsolutions.image.emf.EmfDecoder");
            }
            case GIF_IMAGE: {
                return new GifDecoder();
            }
            case HEIC_IMAGE: {
                return (Decoder)JDeli.getClassFromPath("com.idrsolutions.image.heic.HeicDecoder");
            }
            case JPEG_IMAGE: {
                return new JpegDecoder();
            }
            case JPEG2000_IMAGE: {
                return new Jpeg2000Decoder();
            }
            case PNG_IMAGE: {
                return new PngDecoder();
            }
            case PSD_IMAGE: {
                return (Decoder)JDeli.getClassFromPath("com.idrsolutions.image.psd.PsdDecoder");
            }
            case SGI_IMAGE: {
                return (Decoder)JDeli.getClassFromPath("com.idrsolutions.image.sgi.SgiDecoder");
            }
            case TIFF_IMAGE: {
                return new TiffDecoder();
            }
            case WEBP_IMAGE: {
                return (Decoder)JDeli.getClassFromPath("com.idrsolutions.image.webp.WebpDecoder");
            }
            case WMF_IMAGE: {
                return (Decoder)JDeli.getClassFromPath("com.idrsolutions.image.wmf.WmfDecoder");
            }
        }
        return null;
    }

    private static BufferedImage getBufferedImage(File imageFile, ImageFormat type, Metadata metadata) throws Exception {
        Decoder dec = JDeli.getDecoder(type);
        if (dec != null) {
            if (metadata != null) {
                dec.setMetadata(metadata);
            }
            return dec.read(imageFile);
        }
        return null;
    }

    private static byte[] getTestBytes(File imageFile) throws IOException {
        byte[] test;
        try (FileInputStream fis = new FileInputStream(imageFile);){
            test = new byte[Math.min(140, (int)imageFile.length())];
            fis.read(test);
        }
        return test;
    }

    public static BufferedImage read(File imageFile, HashMap<String, String> map) throws Exception {
        byte[] test = JDeli.getTestBytes(imageFile);
        if (map != null && map.containsKey("DECODE_4_COMPONENTS_AS_ARGB") && "true".equalsIgnoreCase(map.get("DECODE_4_COMPONENTS_AS_ARGB")) && ImageTypeFinder.getImageType(test) == ImageFormat.JPEG_IMAGE) {
            try (FileInputStream fis = new FileInputStream(imageFile);){
                byte[] data = new byte[(int)imageFile.length()];
                fis.read(data);
                BufferedImage bufferedImage = ARGBJpegDecoder.read(data);
                return bufferedImage;
            }
        }
        return JDeli.read(imageFile);
    }

    public static BufferedImage read(byte[] data, HashMap<String, String> map) throws Exception {
        if (map != null && map.containsKey("decode_4_components_as_argb") && "true".equalsIgnoreCase(map.get("decode_4_components_as_argb")) && ImageTypeFinder.getImageType(data) == ImageFormat.JPEG_IMAGE) {
            return ARGBJpegDecoder.read(data);
        }
        return JDeli.read(data);
    }

    public static BufferedImage read(byte[] data) throws Exception {
        ImageFormat type = ImageTypeFinder.getImageType(data);
        Decoder dec = JDeli.getDecoder(type);
        if (dec != null) {
            return dec.read(data);
        }
        return null;
    }

    public static BufferedImage read(InputStream is, HashMap<String, String> map) throws Exception {
        try (ByteArrayOutputStream buffer = new ByteArrayOutputStream();){
            int nRead;
            byte[] data = new byte[2048];
            while ((nRead = is.read(data, 0, data.length)) != -1) {
                buffer.write(data, 0, nRead);
            }
            BufferedImage bufferedImage = JDeli.read(buffer.toByteArray(), map);
            return bufferedImage;
        }
    }

    public static BufferedImage read(InputStream is) throws Exception {
        try (ByteArrayOutputStream buffer = new ByteArrayOutputStream();){
            int nRead;
            byte[] data = new byte[2048];
            while ((nRead = is.read(data, 0, data.length)) != -1) {
                buffer.write(data, 0, nRead);
            }
            BufferedImage bufferedImage = JDeli.read(buffer.toByteArray());
            return bufferedImage;
        }
    }

    public static void write(BufferedImage image, EncoderOptions options, File outputFile) throws Exception {
        BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(outputFile));
        JDeli.write(image, options, (OutputStream)bos);
        bos.close();
    }

    public static void write(BufferedImage image, OutputFormat format, File outputFile) throws Exception {
        BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(outputFile));
        JDeli.write(image, format, (OutputStream)bos);
        bos.close();
    }

    public static void write(BufferedImage image, String formatName, File outputFile) throws Exception {
        BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(outputFile));
        JDeli.write(image, formatName, (OutputStream)bos);
        bos.close();
    }

    public static boolean isImageSupportedForOutput(String formatName) {
        return SupportedFormats.hasEncoderSupportForImageFormat(formatName);
    }

    public static boolean isImageSupportedForInput(String formatName) {
        return SupportedFormats.hasDecoderSupportForImageFormat(formatName);
    }

    public static void write(BufferedImage image, String formatName, OutputStream stream) throws Exception {
        if (!JDeli.isImageSupportedForOutput(formatName)) {
            throw new IOException("The format Name " + formatName + " not supported yet for writing");
        }
        JDeli.write(image, SupportedFormats.getEnumFromString(formatName), stream);
    }

    public static void write(BufferedImage image, EncoderOptions options, OutputStream outputStream) throws Exception {
        OutputFormat format = options.getOutputFormat();
        Encoder enc = JDeli.getEncoder(format, options);
        if (enc != null) {
            enc.write(image, outputStream);
        }
    }

    public static void write(BufferedImage image, OutputFormat format, OutputStream outputStream) throws Exception {
        Encoder enc = JDeli.getEncoder(format, null);
        if (enc != null) {
            enc.write(image, outputStream);
        }
    }

    private static Encoder getEncoder(OutputFormat format, EncoderOptions options) {
        return SupportedFormats.getEncoder(format, options);
    }
}

