/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.base;

import java.io.Serializable;
import net.sf.jasperreports.engine.JRDatasetRun;
import net.sf.jasperreports.engine.JRElementDataset;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRGroup;
import net.sf.jasperreports.engine.base.JRBaseObjectFactory;

public abstract class JRBaseElementDataset
implements JRElementDataset,
Serializable {
    private static final long serialVersionUID = 10200L;
    protected byte resetType = 1;
    protected byte incrementType = (byte)5;
    protected JRGroup resetGroup = null;
    protected JRGroup incrementGroup = null;
    protected JRDatasetRun datasetRun;
    protected JRExpression incrementWhenExpression;

    protected JRBaseElementDataset() {
    }

    protected JRBaseElementDataset(JRElementDataset dataset) {
        if (dataset != null) {
            this.resetType = dataset.getResetType();
            this.incrementType = dataset.getIncrementType();
            this.resetGroup = dataset.getResetGroup();
            this.incrementGroup = dataset.getIncrementGroup();
            this.datasetRun = dataset.getDatasetRun();
            this.incrementWhenExpression = dataset.getIncrementWhenExpression();
        }
    }

    protected JRBaseElementDataset(JRElementDataset dataset, JRBaseObjectFactory factory) {
        factory.put(dataset, this);
        this.resetType = dataset.getResetType();
        this.incrementType = dataset.getIncrementType();
        this.resetGroup = factory.getGroup(dataset.getResetGroup());
        this.incrementGroup = factory.getGroup(dataset.getIncrementGroup());
        this.datasetRun = factory.getDatasetRun(dataset.getDatasetRun());
        this.incrementWhenExpression = factory.getExpression(dataset.getIncrementWhenExpression());
    }

    @Override
    public byte getResetType() {
        return this.resetType;
    }

    @Override
    public byte getIncrementType() {
        return this.incrementType;
    }

    @Override
    public JRGroup getResetGroup() {
        return this.resetGroup;
    }

    @Override
    public JRGroup getIncrementGroup() {
        return this.incrementGroup;
    }

    @Override
    public JRDatasetRun getDatasetRun() {
        return this.datasetRun;
    }

    @Override
    public JRExpression getIncrementWhenExpression() {
        return this.incrementWhenExpression;
    }
}

