/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.rtf.parser.properties;

import com.lowagie.text.rtf.parser.ctrlwords.RtfCtrlWordData;
import com.lowagie.text.rtf.parser.properties.RtfPropertyListener;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;

public class RtfProperty {
    public static final int OFF = 0;
    public static final int ON = 1;
    public static final String COLOR = "color.";
    public static final String CHARACTER = "character.";
    public static final String PARAGRAPH = "paragraph.";
    public static final String SECTION = "section.";
    public static final String DOCUMENT = "document.";
    public static final String COLOR_FG = "color.fg";
    public static final String COLOR_BG = "color.bg";
    public static final String CHARACTER_BOLD = "character.bold";
    public static final String CHARACTER_UNDERLINE = "character.underline";
    public static final String CHARACTER_ITALIC = "character.italic";
    public static final String CHARACTER_SIZE = "character.size";
    public static final String CHARACTER_FONT = "character.font";
    public static final String CHARACTER_STYLE = "character.style";
    public static final int JUSTIFY_LEFT = 0;
    public static final int JUSTIFY_RIGHT = 1;
    public static final int JUSTIFY_CENTER = 2;
    public static final int JUSTIFY_FULL = 3;
    public static final String PARAGRAPH_INDENT_LEFT = "paragraph.indentLeft";
    public static final String PARAGRAPH_INDENT_RIGHT = "paragraph.indentRight";
    public static final String PARAGRAPH_INDENT_FIRST_LINE = "paragraph.indentFirstLine";
    public static final String PARAGRAPH_JUSTIFICATION = "paragraph.justification";
    public static final String PARAGRAPH_BORDER = "paragraph.border";
    public static final String PARAGRAPH_BORDER_CELL = "paragraph.borderCell";
    public static final int PARAGRAPH_BORDER_NIL = 0;
    public static final int PARAGRAPH_BORDER_BOTTOM = 1;
    public static final int PARAGRAPH_BORDER_TOP = 2;
    public static final int PARAGRAPH_BORDER_LEFT = 4;
    public static final int PARAGRAPH_BORDER_RIGHT = 8;
    public static final int PARAGRAPH_BORDER_DIAGONAL_UL_LR = 16;
    public static final int PARAGRAPH_BORDER_DIAGONAL_UR_LL = 32;
    public static final int PARAGRAPH_BORDER_TABLE_HORIZONTAL = 64;
    public static final int PARAGRAPH_BORDER_TABLE_VERTICAL = 128;
    public static final int PGN_DECIMAL = 0;
    public static final int PGN_ROMAN_NUMERAL_UPPERCASE = 1;
    public static final int PGN_ROMAN_NUMERAL_LOWERCASE = 2;
    public static final int PGN_LETTER_UPPERCASE = 3;
    public static final int PGN_LETTER_LOWERCASE = 4;
    public static final int SBK_NONE = 0;
    public static final int SBK_COLUMN = 1;
    public static final int SBK_EVEN = 2;
    public static final int SBK_ODD = 3;
    public static final int SBK_PAGE = 4;
    public static final String SECTION_NUMBER_OF_COLUMNS = "section.numberOfColumns";
    public static final String SECTION_BREAK_TYPE = "section.SectionBreakType";
    public static final String SECTION_PAGE_NUMBER_POSITION_X = "section.pageNumberPositionX";
    public static final String SECTION_PAGE_NUMBER_POSITION_Y = "section.pageNumberPositionY";
    public static final String SECTION_PAGE_NUMBER_FORMAT = "section.pageNumberFormat";
    public static final String PAGE_PORTRAIT = "0";
    public static final String PAGE_LANDSCAPE = "1";
    public static final String DOCUMENT_PAGE_WIDTH_TWIPS = "document.pageWidthTwips";
    public static final String DOCUMENT_PAGE_HEIGHT_TWIPS = "document.pageHeightTwips";
    public static final String DOCUMENT_MARGIN_LEFT_TWIPS = "document.marginLeftTwips";
    public static final String DOCUMENT_MARGIN_TOP_TWIPS = "document.marginTopTwips";
    public static final String DOCUMENT_MARGIN_RIGHT_TWIPS = "document.marginRightTwips";
    public static final String DOCUMENT_MARGIN_BOTTOM_TWIPS = "document.marginBottomTwips";
    public static final String DOCUMENT_PAGE_NUMBER_START = "document.pageNumberStart";
    public static final String DOCUMENT_ENABLE_FACING_PAGES = "document.enableFacingPages";
    public static final String DOCUMENT_PAGE_ORIENTATION = "document.pageOrientation";
    public static final String DOCUMENT_DEFAULT_FONT_NUMER = "document.defaultFontNumber";
    protected HashMap properties = new HashMap();
    private boolean modifiedCharacter = false;
    private boolean modifiedParagraph = false;
    private boolean modifiedSection = false;
    private boolean modifiedDocument = false;
    private ArrayList listeners = new ArrayList();

    public void setToDefault() {
        this.setToDefault(COLOR);
        this.setToDefault(CHARACTER);
        this.setToDefault(PARAGRAPH);
        this.setToDefault(SECTION);
        this.setToDefault(DOCUMENT);
    }

    public void setToDefault(String string) {
        if (COLOR.equals(string)) {
            this.setProperty(COLOR_FG, new Color(0, 0, 0));
            this.setProperty(COLOR_BG, new Color(255, 255, 255));
            return;
        }
        if (CHARACTER.equals(string)) {
            this.setProperty(CHARACTER_BOLD, 0);
            this.setProperty(CHARACTER_UNDERLINE, 0);
            this.setProperty(CHARACTER_ITALIC, 0);
            this.setProperty(CHARACTER_SIZE, 24);
            this.setProperty(CHARACTER_FONT, 0);
            return;
        }
        if (PARAGRAPH.equals(string)) {
            this.setProperty(PARAGRAPH_INDENT_LEFT, 0);
            this.setProperty(PARAGRAPH_INDENT_RIGHT, 0);
            this.setProperty(PARAGRAPH_INDENT_FIRST_LINE, 0);
            this.setProperty(PARAGRAPH_JUSTIFICATION, 0);
            this.setProperty(PARAGRAPH_BORDER, 0);
            this.setProperty(PARAGRAPH_BORDER_CELL, 0);
            return;
        }
        if (SECTION.equals(string)) {
            this.setProperty(SECTION_NUMBER_OF_COLUMNS, 0);
            this.setProperty(SECTION_BREAK_TYPE, 0);
            this.setProperty(SECTION_PAGE_NUMBER_POSITION_X, 0);
            this.setProperty(SECTION_PAGE_NUMBER_POSITION_Y, 0);
            this.setProperty(SECTION_PAGE_NUMBER_FORMAT, 0);
            return;
        }
        if (DOCUMENT.equals(string)) {
            this.setProperty(DOCUMENT_PAGE_WIDTH_TWIPS, 12240);
            this.setProperty(DOCUMENT_PAGE_HEIGHT_TWIPS, 15480);
            this.setProperty(DOCUMENT_MARGIN_LEFT_TWIPS, 1800);
            this.setProperty(DOCUMENT_MARGIN_TOP_TWIPS, 1440);
            this.setProperty(DOCUMENT_MARGIN_RIGHT_TWIPS, 1800);
            this.setProperty(DOCUMENT_MARGIN_BOTTOM_TWIPS, 1440);
            this.setProperty(DOCUMENT_PAGE_NUMBER_START, 1);
            this.setProperty(DOCUMENT_ENABLE_FACING_PAGES, 1);
            this.setProperty(DOCUMENT_PAGE_ORIENTATION, PAGE_PORTRAIT);
            this.setProperty(DOCUMENT_DEFAULT_FONT_NUMER, 0);
            return;
        }
    }

    public boolean toggleProperty(RtfCtrlWordData rtfCtrlWordData) {
        String string = rtfCtrlWordData.specialHandler;
        if (string == null || string.length() == 0) {
            return false;
        }
        Object object = this.getProperty(string);
        if (object == null) {
            object = new Integer(1);
        } else {
            if (object instanceof Integer) {
                int n = (Integer)object;
                if (n != 0) {
                    this.removeProperty(string);
                }
                return true;
            }
            if (object instanceof Long) {
                long l = ((Long)object).intValue();
                if (l != 0L) {
                    this.removeProperty(string);
                }
                return true;
            }
        }
        this.setProperty(string, object);
        return true;
    }

    public boolean setProperty(RtfCtrlWordData rtfCtrlWordData) {
        String string = rtfCtrlWordData.specialHandler;
        String string2 = rtfCtrlWordData.param;
        this.setProperty(string, string2);
        return true;
    }

    private boolean setProperty(String string, Object object) {
        long l;
        long l2;
        int n;
        int n2;
        if (string == null || object == null) {
            return false;
        }
        Object object2 = this.getProperty(string);
        if (object2 instanceof Integer && object instanceof Integer ? (n2 = ((Integer)object2).intValue()) == (n = ((Integer)object).intValue()) : object2 instanceof Long && object instanceof Long && (l2 = (long)((Long)object2).intValue()) == (l = (long)((Long)object).intValue())) {
            return true;
        }
        this.beforeChange(string);
        this.properties.put(string, object);
        this.afterChange(string);
        this.setModified(string, true);
        return true;
    }

    private boolean setProperty(String string, int n) {
        int n2;
        if (string == null) {
            return false;
        }
        Object object = this.getProperty(string);
        if (object instanceof Integer && (n2 = ((Integer)object).intValue()) == n) {
            return true;
        }
        this.beforeChange(string);
        this.properties.put(string, new Integer(n));
        this.afterChange(string);
        this.setModified(string, true);
        return true;
    }

    private boolean addToProperty(String string, int n) {
        if (string == null) {
            return false;
        }
        int n2 = (Integer)this.properties.get(string);
        if ((n2 | n) == n2) {
            return true;
        }
        this.beforeChange(string);
        this.properties.put(string, new Integer(n2 |= n));
        this.afterChange(string);
        this.setModified(string, true);
        return true;
    }

    private boolean setProperty(String string, long l) {
        long l2;
        if (string == null) {
            return false;
        }
        Object object = this.getProperty(string);
        if (object instanceof Long && (l2 = ((Long)object).longValue()) == l) {
            return true;
        }
        this.beforeChange(string);
        this.properties.put(string, new Long(l));
        this.afterChange(string);
        this.setModified(string, true);
        return true;
    }

    private boolean addToProperty(String string, long l) {
        if (string == null) {
            return false;
        }
        long l2 = (Long)this.properties.get(string);
        if ((l2 | l) == l2) {
            return true;
        }
        this.beforeChange(string);
        this.properties.put(string, new Long(l2 |= l));
        this.afterChange(string);
        this.setModified(string, true);
        return true;
    }

    private boolean removeProperty(String string) {
        if (string == null) {
            return false;
        }
        if (this.properties.containsKey(string)) {
            this.beforeChange(string);
            this.properties.remove(string);
            this.afterChange(string);
            this.setModified(string, true);
        }
        return true;
    }

    public Object getProperty(String string) {
        return this.properties.get(string);
    }

    public HashMap getProperties(String string) {
        HashMap hashMap = new HashMap();
        if (!this.properties.isEmpty()) {
            for (String string2 : this.properties.keySet()) {
                if (!string2.startsWith(string)) continue;
                hashMap.put(string2, this.properties.get(string2));
            }
        }
        return hashMap;
    }

    public boolean isModified() {
        return this.modifiedCharacter || this.modifiedParagraph || this.modifiedSection || this.modifiedDocument;
    }

    public void setModified(String string, boolean bl) {
        if (string.startsWith(CHARACTER)) {
            this.setModifiedCharacter(bl);
        } else if (string.startsWith(PARAGRAPH)) {
            this.setModifiedParagraph(bl);
        } else if (string.startsWith(SECTION)) {
            this.setModifiedSection(bl);
        } else if (string.startsWith(DOCUMENT)) {
            this.setModifiedDocument(bl);
        }
    }

    public boolean isModifiedCharacter() {
        return this.modifiedCharacter;
    }

    public void setModifiedCharacter(boolean bl) {
        this.modifiedCharacter = bl;
    }

    public boolean isModifiedParagraph() {
        return this.modifiedParagraph;
    }

    public void setModifiedParagraph(boolean bl) {
        this.modifiedParagraph = bl;
    }

    public boolean isModifiedSection() {
        return this.modifiedSection;
    }

    public void setModifiedSection(boolean bl) {
        this.modifiedSection = bl;
    }

    public boolean isModifiedDocument() {
        return this.modifiedDocument;
    }

    public void setModifiedDocument(boolean bl) {
        this.modifiedDocument = bl;
    }

    public void addRtfPropertyListener(RtfPropertyListener rtfPropertyListener) {
        this.listeners.add(rtfPropertyListener);
    }

    public void removeRtfPropertyListener(RtfPropertyListener rtfPropertyListener) {
        this.listeners.remove(rtfPropertyListener);
    }

    public void beforeChange(String string) {
        for (RtfPropertyListener rtfPropertyListener : this.listeners) {
            rtfPropertyListener.beforePropertyChange(string);
        }
        if (string.startsWith(CHARACTER) || string.startsWith(PARAGRAPH) || string.startsWith(SECTION) || string.startsWith(DOCUMENT)) {
            // empty if block
        }
    }

    public void afterChange(String string) {
        for (RtfPropertyListener rtfPropertyListener : this.listeners) {
            rtfPropertyListener.afterPropertyChange(string);
        }
        if (string.startsWith(CHARACTER) || string.startsWith(PARAGRAPH) || string.startsWith(SECTION) || string.startsWith(DOCUMENT)) {
            // empty if block
        }
    }
}

