/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.rtf.list;

import com.lowagie.text.Chunk;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.Font;
import com.lowagie.text.List;
import com.lowagie.text.ListItem;
import com.lowagie.text.RomanList;
import com.lowagie.text.factories.RomanAlphabetFactory;
import com.lowagie.text.factories.RomanNumberFactory;
import com.lowagie.text.rtf.RtfBasicElement;
import com.lowagie.text.rtf.RtfElement;
import com.lowagie.text.rtf.RtfExtendedElement;
import com.lowagie.text.rtf.document.RtfDocument;
import com.lowagie.text.rtf.list.RtfListItem;
import com.lowagie.text.rtf.list.RtfListTable;
import com.lowagie.text.rtf.style.RtfFont;
import com.lowagie.text.rtf.style.RtfFontList;
import com.lowagie.text.rtf.style.RtfParagraphStyle;
import com.lowagie.text.rtf.text.RtfParagraph;
import java.awt.Color;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;

public class RtfList
extends RtfElement
implements RtfExtendedElement {
    private static final byte[] LIST_LEVEL = "\\listlevel".getBytes();
    private static final byte[] LIST_LEVEL_TYPE = "\\levelnfc".getBytes();
    private static final byte[] LIST_LEVEL_TYPE_NEW = "\\levelnfcn".getBytes();
    private static final byte[] LIST_LEVEL_ALIGNMENT = "\\leveljc".getBytes();
    private static final byte[] LIST_LEVEL_ALIGNMENT_NEW = "\\leveljcn".getBytes();
    private static final byte[] LIST_LEVEL_START_AT = "\\levelstartat".getBytes();
    private static final byte[] LIST_LEVEL_TEXT = "\\leveltext".getBytes();
    private static final byte[] LIST_LEVEL_STYLE_NUMBERED_BEGIN = "\\'02\\'".getBytes();
    private static final byte[] LIST_LEVEL_STYLE_NUMBERED_END = ".;".getBytes();
    private static final byte[] LIST_LEVEL_STYLE_BULLETED_BEGIN = "\\'01".getBytes();
    private static final byte[] LIST_LEVEL_STYLE_BULLETED_END = ";".getBytes();
    private static final byte[] LIST_LEVEL_NUMBERS_BEGIN = "\\levelnumbers".getBytes();
    private static final byte[] LIST_LEVEL_NUMBERS_NUMBERED = "\\'01".getBytes();
    private static final byte[] LIST_LEVEL_NUMBERS_END = ";".getBytes();
    private static final byte[] LIST_LEVEL_FIRST_INDENT = "\\fi".getBytes();
    private static final byte[] LIST_LEVEL_SYMBOL_INDENT = "\\tx".getBytes();
    private static final byte[] LIST_LEVEL_NUMBER = "\\ilvl".getBytes();
    private static final byte[] TAB = "\\tab".getBytes();
    private static final byte[] LIST_TEXT = "\\listtext".getBytes();
    private static final byte[] LIST_NUMBER_END = ".".getBytes();
    private static final int LIST_TYPE_BULLET = 0;
    private static final int LIST_TYPE_NUMBERED = 1;
    private static final int LIST_TYPE_UPPER_LETTERS = 2;
    private static final int LIST_TYPE_LOWER_LETTERS = 3;
    private static final int LIST_TYPE_UPPER_ROMAN = 4;
    private static final int LIST_TYPE_LOWER_ROMAN = 5;
    private ArrayList items;
    private int listLevel = 0;
    private int firstIndent = 0;
    private int leftIndent = 0;
    private int rightIndent = 0;
    private int symbolIndent = 0;
    private int listNumber = this.document.getDocumentHeader().getListNumber(this);
    private int listType = 0;
    private RtfFont fontNumber;
    private RtfFont fontBullet;
    private int alignment = 0;
    private RtfList parentList = null;
    private String bulletCharacter = "\u00b7";

    public RtfList(RtfDocument rtfDocument, List list) {
        super(rtfDocument);
        this.items = new ArrayList();
        if (list.getSymbolIndent() > 0.0f && list.getIndentationLeft() > 0.0f) {
            this.firstIndent = (int)((double)list.getSymbolIndent() * 20.0 * -1.0);
            this.leftIndent = (int)((double)(list.getIndentationLeft() + list.getSymbolIndent()) * 20.0);
        } else if (list.getSymbolIndent() > 0.0f) {
            this.firstIndent = (int)((double)list.getSymbolIndent() * 20.0 * -1.0);
            this.leftIndent = (int)((double)list.getSymbolIndent() * 20.0);
        } else if (list.getIndentationLeft() > 0.0f) {
            this.firstIndent = 0;
            this.leftIndent = (int)((double)list.getIndentationLeft() * 20.0);
        } else {
            this.firstIndent = 0;
            this.leftIndent = 0;
        }
        this.rightIndent = (int)((double)list.getIndentationRight() * 20.0);
        this.symbolIndent = (int)((double)(list.getSymbolIndent() + list.getIndentationLeft()) * 20.0);
        if (list instanceof RomanList) {
            this.listType = list.isLowercase() ? 5 : 4;
        } else if (list.isNumbered()) {
            this.listType = 1;
        } else if (list.isLettered()) {
            this.listType = list.isLowercase() ? 3 : 2;
        }
        for (int i = 0; i < list.getItems().size(); ++i) {
            try {
                RtfBasicElement rtfBasicElement;
                Element element = (Element)list.getItems().get(i);
                if (element.type() == 10) {
                    element = new ListItem((Chunk)element);
                }
                if (element instanceof ListItem) {
                    this.alignment = ((ListItem)element).getAlignment();
                }
                if ((rtfBasicElement = rtfDocument.getMapper().mapElement(element)) instanceof RtfList) {
                    ((RtfList)rtfBasicElement).setListNumber(this.listNumber);
                    ((RtfList)rtfBasicElement).setListLevel(this.listLevel + 1);
                    ((RtfList)rtfBasicElement).setParent(this);
                } else if (rtfBasicElement instanceof RtfListItem) {
                    ((RtfListItem)rtfBasicElement).setParent(this);
                    ((RtfListItem)rtfBasicElement).inheritListSettings(this.listNumber, this.listLevel + 1);
                }
                this.items.add(rtfBasicElement);
                continue;
            }
            catch (DocumentException documentException) {
                documentException.printStackTrace();
            }
        }
        if (this.listLevel == 0) {
            this.correctIndentation();
        }
        this.fontNumber = new RtfFont(this.document, new Font(2, 10.0f, 0, new Color(0, 0, 0)));
        if (list.getSymbol() != null && list.getSymbol().getFont() != null && !list.getSymbol().getContent().startsWith("-") && list.getSymbol().getContent().length() > 0) {
            this.fontBullet = new RtfFont(this.document, list.getSymbol().getFont());
            this.bulletCharacter = list.getSymbol().getContent().substring(0, 1);
        } else {
            this.fontBullet = new RtfFont(this.document, new Font(3, 10.0f, 0, new Color(0, 0, 0)));
        }
    }

    private void writeIndentation(OutputStream outputStream) throws IOException {
        outputStream.write(LIST_LEVEL_FIRST_INDENT);
        outputStream.write(this.intToByteArray(this.firstIndent));
        outputStream.write(RtfParagraphStyle.INDENT_LEFT);
        outputStream.write(this.intToByteArray(this.leftIndent));
        outputStream.write(RtfParagraphStyle.INDENT_RIGHT);
        outputStream.write(this.intToByteArray(this.rightIndent));
    }

    public void writeDefinition(OutputStream outputStream) throws IOException {
        outputStream.write(OPEN_GROUP);
        outputStream.write(LIST_LEVEL);
        outputStream.write(LIST_LEVEL_TYPE);
        switch (this.listType) {
            case 0: {
                outputStream.write(this.intToByteArray(23));
                break;
            }
            case 1: {
                outputStream.write(this.intToByteArray(0));
                break;
            }
            case 2: {
                outputStream.write(this.intToByteArray(3));
                break;
            }
            case 3: {
                outputStream.write(this.intToByteArray(4));
                break;
            }
            case 4: {
                outputStream.write(this.intToByteArray(1));
                break;
            }
            case 5: {
                outputStream.write(this.intToByteArray(2));
            }
        }
        outputStream.write(LIST_LEVEL_TYPE_NEW);
        switch (this.listType) {
            case 0: {
                outputStream.write(this.intToByteArray(23));
                break;
            }
            case 1: {
                outputStream.write(this.intToByteArray(0));
                break;
            }
            case 2: {
                outputStream.write(this.intToByteArray(3));
                break;
            }
            case 3: {
                outputStream.write(this.intToByteArray(4));
                break;
            }
            case 4: {
                outputStream.write(this.intToByteArray(1));
                break;
            }
            case 5: {
                outputStream.write(this.intToByteArray(2));
            }
        }
        outputStream.write(LIST_LEVEL_ALIGNMENT);
        outputStream.write(this.intToByteArray(0));
        outputStream.write(LIST_LEVEL_ALIGNMENT_NEW);
        outputStream.write(this.intToByteArray(0));
        outputStream.write(LIST_LEVEL_START_AT);
        outputStream.write(this.intToByteArray(1));
        outputStream.write(OPEN_GROUP);
        outputStream.write(LIST_LEVEL_TEXT);
        if (this.listType != 0) {
            outputStream.write(LIST_LEVEL_STYLE_NUMBERED_BEGIN);
            if (this.listLevel < 10) {
                outputStream.write(this.intToByteArray(0));
            }
            outputStream.write(this.intToByteArray(this.listLevel));
            outputStream.write(LIST_LEVEL_STYLE_NUMBERED_END);
        } else {
            outputStream.write(LIST_LEVEL_STYLE_BULLETED_BEGIN);
            this.document.filterSpecialChar(outputStream, this.bulletCharacter, false, false);
            outputStream.write(LIST_LEVEL_STYLE_BULLETED_END);
        }
        outputStream.write(CLOSE_GROUP);
        outputStream.write(OPEN_GROUP);
        outputStream.write(LIST_LEVEL_NUMBERS_BEGIN);
        if (this.listType != 0) {
            outputStream.write(LIST_LEVEL_NUMBERS_NUMBERED);
        }
        outputStream.write(LIST_LEVEL_NUMBERS_END);
        outputStream.write(CLOSE_GROUP);
        outputStream.write(RtfFontList.FONT_NUMBER);
        if (this.listType != 0) {
            outputStream.write(this.intToByteArray(this.fontNumber.getFontNumber()));
        } else {
            outputStream.write(this.intToByteArray(this.fontBullet.getFontNumber()));
        }
        this.writeIndentation(outputStream);
        outputStream.write(LIST_LEVEL_SYMBOL_INDENT);
        outputStream.write(this.intToByteArray(this.leftIndent));
        outputStream.write(CLOSE_GROUP);
        outputStream.write("\n".getBytes());
        for (int i = 0; i < this.items.size(); ++i) {
            RtfElement rtfElement;
            RtfElement rtfElement2 = (RtfElement)this.items.get(i);
            if (rtfElement2 instanceof RtfList) {
                rtfElement = (RtfList)rtfElement2;
                ((RtfList)rtfElement).writeDefinition(outputStream);
                break;
            }
            if (rtfElement2 instanceof RtfListItem && ((RtfListItem)(rtfElement = (RtfListItem)rtfElement2)).writeDefinition(outputStream)) break;
        }
    }

    protected void writeListBeginning(OutputStream outputStream) throws IOException {
        outputStream.write(RtfParagraph.PARAGRAPH_DEFAULTS);
        if (this.inTable) {
            outputStream.write(RtfParagraph.IN_TABLE);
        }
        switch (this.alignment) {
            case 0: {
                outputStream.write(RtfParagraphStyle.ALIGN_LEFT);
                break;
            }
            case 2: {
                outputStream.write(RtfParagraphStyle.ALIGN_RIGHT);
                break;
            }
            case 1: {
                outputStream.write(RtfParagraphStyle.ALIGN_CENTER);
                break;
            }
            case 3: 
            case 8: {
                outputStream.write(RtfParagraphStyle.ALIGN_JUSTIFY);
            }
        }
        this.writeIndentation(outputStream);
        outputStream.write(RtfFont.FONT_SIZE);
        outputStream.write(this.intToByteArray(this.fontNumber.getFontSize() * 2));
        if (this.symbolIndent > 0) {
            outputStream.write("\\tx".getBytes());
            outputStream.write(this.intToByteArray(this.leftIndent));
        }
    }

    protected void writeListNumbers(OutputStream outputStream) throws IOException {
        outputStream.write(RtfListTable.LIST_NUMBER);
        outputStream.write(this.intToByteArray(this.listNumber));
        if (this.listLevel > 0) {
            outputStream.write(LIST_LEVEL_NUMBER);
            outputStream.write(this.intToByteArray(this.listLevel));
        }
    }

    public void writeContent(OutputStream outputStream) throws IOException {
        outputStream.write(OPEN_GROUP);
        int n = 0;
        for (int i = 0; i < this.items.size(); ++i) {
            RtfElement rtfElement = (RtfElement)this.items.get(i);
            if (rtfElement instanceof RtfListItem) {
                ++n;
                this.writeListBeginning(outputStream);
                this.writeListNumbers(outputStream);
                outputStream.write(OPEN_GROUP);
                outputStream.write(LIST_TEXT);
                outputStream.write(RtfParagraph.PARAGRAPH_DEFAULTS);
                if (this.inTable) {
                    outputStream.write(RtfParagraph.IN_TABLE);
                }
                outputStream.write(RtfFontList.FONT_NUMBER);
                if (this.listType != 0) {
                    outputStream.write(this.intToByteArray(this.fontNumber.getFontNumber()));
                } else {
                    outputStream.write(this.intToByteArray(this.fontBullet.getFontNumber()));
                }
                this.writeIndentation(outputStream);
                outputStream.write(DELIMITER);
                if (this.listType != 0) {
                    switch (this.listType) {
                        case 1: {
                            outputStream.write(this.intToByteArray(n));
                            break;
                        }
                        case 2: {
                            outputStream.write(RomanAlphabetFactory.getUpperCaseString(n).getBytes());
                            break;
                        }
                        case 3: {
                            outputStream.write(RomanAlphabetFactory.getLowerCaseString(n).getBytes());
                            break;
                        }
                        case 4: {
                            outputStream.write(RomanNumberFactory.getUpperCaseString(n).getBytes());
                            break;
                        }
                        case 5: {
                            outputStream.write(RomanNumberFactory.getLowerCaseString(n).getBytes());
                        }
                    }
                    outputStream.write(LIST_NUMBER_END);
                } else {
                    this.document.filterSpecialChar(outputStream, this.bulletCharacter, true, false);
                }
                outputStream.write(TAB);
                outputStream.write(CLOSE_GROUP);
                rtfElement.writeContent(outputStream);
                if (i < this.items.size() - 1 || !this.inTable || this.listLevel > 0) {
                    outputStream.write(RtfParagraph.PARAGRAPH);
                }
                outputStream.write("\n".getBytes());
                continue;
            }
            if (!(rtfElement instanceof RtfList)) continue;
            rtfElement.writeContent(outputStream);
            outputStream.write("\n".getBytes());
        }
        outputStream.write(CLOSE_GROUP);
        if (!this.inTable) {
            outputStream.write(RtfParagraph.PARAGRAPH_DEFAULTS);
        }
    }

    public int getListLevel() {
        return this.listLevel;
    }

    public void setListLevel(int n) {
        this.listLevel = n;
        if (this.listLevel != 0) {
            this.document.getDocumentHeader().freeListNumber(this);
            for (int i = 0; i < this.items.size(); ++i) {
                if (!(this.items.get(i) instanceof RtfList)) continue;
                ((RtfList)this.items.get(i)).setListNumber(this.listNumber);
                ((RtfList)this.items.get(i)).setListLevel(this.listLevel + 1);
            }
        } else {
            this.listNumber = this.document.getDocumentHeader().getListNumber(this);
        }
    }

    protected void setParent(RtfList rtfList) {
        this.parentList = rtfList;
    }

    public int getListNumber() {
        return this.listNumber;
    }

    public void setListNumber(int n) {
        this.listNumber = n;
    }

    public void setInTable(boolean bl) {
        super.setInTable(bl);
        for (int i = 0; i < this.items.size(); ++i) {
            ((RtfBasicElement)this.items.get(i)).setInTable(bl);
        }
    }

    public void setInHeader(boolean bl) {
        super.setInHeader(bl);
        for (int i = 0; i < this.items.size(); ++i) {
            ((RtfBasicElement)this.items.get(i)).setInHeader(bl);
        }
    }

    protected void correctIndentation() {
        if (this.parentList != null) {
            this.leftIndent = this.leftIndent + this.parentList.getLeftIndent() + this.parentList.getFirstIndent();
        }
        for (int i = 0; i < this.items.size(); ++i) {
            if (this.items.get(i) instanceof RtfList) {
                ((RtfList)this.items.get(i)).correctIndentation();
                continue;
            }
            if (!(this.items.get(i) instanceof RtfListItem)) continue;
            ((RtfListItem)this.items.get(i)).correctIndentation();
        }
    }

    private int getLeftIndent() {
        return this.leftIndent;
    }

    private int getFirstIndent() {
        return this.firstIndent;
    }
}

