/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud.api.collections;

import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.solr.cloud.api.collections.DeleteReplicaCmd;
import org.apache.solr.cloud.api.collections.OverseerCollectionMessageHandler;
import org.apache.solr.cloud.overseer.OverseerAction;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.ClusterState;
import org.apache.solr.common.cloud.Replica;
import org.apache.solr.common.cloud.Slice;
import org.apache.solr.common.cloud.ZkNodeProps;
import org.apache.solr.common.cloud.ZkStateReader;
import org.apache.solr.common.params.CollectionParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.common.util.TimeSource;
import org.apache.solr.common.util.Utils;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeleteShardCmd
implements OverseerCollectionMessageHandler.Cmd {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final OverseerCollectionMessageHandler ocmh;
    private final TimeSource timeSource;

    public DeleteShardCmd(OverseerCollectionMessageHandler ocmh) {
        this.ocmh = ocmh;
        this.timeSource = ocmh.cloudManager.getTimeSource();
    }

    @Override
    public void call(ClusterState clusterState, ZkNodeProps message, NamedList results) throws Exception {
        String extCollectionName = message.getStr("collection");
        String sliceId = message.getStr("shard");
        boolean followAliases = message.getBool("followAliases", false);
        String collectionName = followAliases ? this.ocmh.cloudManager.getClusterStateProvider().resolveSimpleAlias(extCollectionName) : extCollectionName;
        log.info("Delete shard invoked");
        Slice slice = clusterState.getCollection(collectionName).getSlice(sliceId);
        if (slice == null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "No shard with name " + sliceId + " exists for collection " + collectionName);
        }
        Slice.State state = slice.getState();
        if (slice.getRange() != null && state != Slice.State.INACTIVE && state != Slice.State.RECOVERY && state != Slice.State.CONSTRUCTION || state == Slice.State.RECOVERY_FAILED) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "The slice: " + slice.getName() + " is currently " + state + ". Only non-active (or custom-hashed) slices can be deleted.");
        }
        if (state == Slice.State.RECOVERY) {
            HashMap<String, String> propMap = new HashMap<String, String>();
            propMap.put("operation", OverseerAction.UPDATESHARDSTATE.toLower());
            propMap.put(sliceId, Slice.State.CONSTRUCTION.toString());
            propMap.put("collection", collectionName);
            ZkNodeProps m = new ZkNodeProps(propMap);
            this.ocmh.overseer.offerStateUpdate(Utils.toJSON((Object)m));
        }
        String asyncId = message.getStr("async");
        try {
            List<ZkNodeProps> replicas = this.getReplicasForSlice(collectionName, slice);
            CountDownLatch cleanupLatch = new CountDownLatch(replicas.size());
            for (ZkNodeProps r : replicas) {
                ZkNodeProps replica = r.plus(message.getProperties()).plus("parallel", (Object)"true").plus("async", (Object)asyncId);
                if (log.isInfoEnabled()) {
                    log.info("Deleting replica for collection={} shard={} on node={}", new Object[]{replica.getStr("collection"), replica.getStr("shard"), replica.getStr("node")});
                }
                NamedList deleteResult = new NamedList();
                try {
                    ((DeleteReplicaCmd)this.ocmh.commandMap.get(CollectionParams.CollectionAction.DELETEREPLICA)).deleteReplica(clusterState, replica, deleteResult, () -> {
                        SimpleOrderedMap success;
                        cleanupLatch.countDown();
                        if (deleteResult.get("failure") != null) {
                            NamedList namedList3 = results;
                            synchronized (namedList3) {
                                results.add("failure", (Object)String.format(Locale.ROOT, "Failed to delete replica for collection=%s shard=%s on node=%s", replica.getStr("collection"), replica.getStr("shard"), replica.getStr("node_name")));
                            }
                        }
                        if ((success = (SimpleOrderedMap)deleteResult.get("success")) != null) {
                            NamedList namedList4 = results;
                            synchronized (namedList4) {
                                results.add("success", (Object)success);
                            }
                        }
                    });
                }
                catch (KeeperException e) {
                    log.warn("Error deleting replica: {}", (Object)r, (Object)e);
                    cleanupLatch.countDown();
                }
                catch (Exception e) {
                    log.warn("Error deleting replica: {}", (Object)r, (Object)e);
                    cleanupLatch.countDown();
                    throw e;
                }
            }
            log.debug("Waiting for delete shard action to complete");
            cleanupLatch.await(1L, TimeUnit.MINUTES);
            ZkNodeProps m = new ZkNodeProps(new String[]{"operation", CollectionParams.CollectionAction.DELETESHARD.toLower(), "collection", collectionName, "shard", sliceId});
            ZkStateReader zkStateReader = this.ocmh.zkStateReader;
            this.ocmh.overseer.offerStateUpdate(Utils.toJSON((Object)m));
            zkStateReader.waitForState(collectionName, 45L, TimeUnit.SECONDS, c -> c.getSlice(sliceId) == null);
            log.info("Successfully deleted collection: {} , shard: {}", (Object)collectionName, (Object)sliceId);
        }
        catch (SolrException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Error executing delete operation for collection: " + collectionName + " shard: " + sliceId, (Throwable)e);
        }
    }

    private List<ZkNodeProps> getReplicasForSlice(String collectionName, Slice slice) {
        ArrayList<ZkNodeProps> sourceReplicas = new ArrayList<ZkNodeProps>();
        for (Replica replica : slice.getReplicas()) {
            ZkNodeProps props = new ZkNodeProps(new String[]{"collection", collectionName, "shard", slice.getName(), "core", replica.getCoreName(), "replica", replica.getName(), "node", replica.getNodeName()});
            sourceReplicas.add(props);
        }
        return sourceReplicas;
    }
}

