/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.fill;

import java.awt.Color;
import java.awt.font.TextAttribute;
import java.text.AttributedString;
import java.util.HashMap;
import java.util.Map;
import net.sf.jasperreports.engine.JRBox;
import net.sf.jasperreports.engine.JRFont;
import net.sf.jasperreports.engine.JRReportFont;
import net.sf.jasperreports.engine.JRStyle;
import net.sf.jasperreports.engine.JRTextElement;
import net.sf.jasperreports.engine.JRTextField;
import net.sf.jasperreports.engine.fill.JRBaseFiller;
import net.sf.jasperreports.engine.fill.JRFillCloneFactory;
import net.sf.jasperreports.engine.fill.JRFillElement;
import net.sf.jasperreports.engine.fill.JRFillObjectFactory;
import net.sf.jasperreports.engine.fill.TextMeasurer;
import net.sf.jasperreports.engine.util.JRFontUtil;
import net.sf.jasperreports.engine.util.JRStyleResolver;
import net.sf.jasperreports.engine.util.JRStyledText;
import org.xml.sax.SAXException;

public abstract class JRFillTextElement
extends JRFillElement
implements JRTextElement {
    private boolean isLeftToRight = true;
    private TextMeasurer textMeasurer = null;
    private float lineSpacingFactor = 0.0f;
    private float leadingOffset = 0.0f;
    private float textHeight = 0.0f;
    private int textStart = 0;
    private int textEnd = 0;
    private String rawText = null;
    private JRStyledText styledText = null;
    private Map styledTextAttributesMap = new HashMap();
    protected TextChopper textChopper = null;
    protected final JRReportFont reportFont;
    private static TextChopper simpleTextChopper = new TextChopper(){

        @Override
        public String chop(JRFillTextElement textElement, int startIndex, int endIndex) {
            return textElement.getStyledText().getText().substring(startIndex, endIndex);
        }
    };
    private static TextChopper styledTextChopper = new TextChopper(){

        @Override
        public String chop(JRFillTextElement textElement, int startIndex, int endIndex) {
            return textElement.filler.getStyledTextParser().write(textElement.getStyledTextAttributes(), new AttributedString(textElement.getStyledText().getAttributedString().getIterator(), startIndex, endIndex).getIterator(), textElement.getText().substring(startIndex, endIndex));
        }
    };

    protected JRFillTextElement(JRBaseFiller filler, JRTextElement textElement, JRFillObjectFactory factory) {
        super(filler, textElement, factory);
        this.reportFont = factory.getReportFont(textElement.getReportFont());
        this.createTextMeasurer();
        this.createTextChopper();
    }

    protected JRFillTextElement(JRFillTextElement textElement, JRFillCloneFactory factory) {
        super(textElement, factory);
        this.reportFont = textElement.reportFont;
        this.createTextMeasurer();
        this.createTextChopper();
    }

    private void createTextMeasurer() {
        this.textMeasurer = new TextMeasurer(this);
    }

    private void createTextChopper() {
        this.textChopper = this.isStyledText() ? styledTextChopper : simpleTextChopper;
    }

    @Override
    public byte getMode() {
        return JRStyleResolver.getMode(this, (byte)2);
    }

    @Override
    public byte getTextAlignment() {
        return JRStyleResolver.getHorizontalAlignment(this);
    }

    @Override
    public void setTextAlignment(byte horizontalAlignment) {
    }

    @Override
    public byte getHorizontalAlignment() {
        return JRStyleResolver.getHorizontalAlignment(this);
    }

    @Override
    public Byte getOwnHorizontalAlignment() {
        return ((JRTextElement)this.parent).getOwnHorizontalAlignment();
    }

    @Override
    public void setHorizontalAlignment(byte horizontalAlignment) {
    }

    @Override
    public void setHorizontalAlignment(Byte horizontalAlignment) {
    }

    @Override
    public byte getVerticalAlignment() {
        return JRStyleResolver.getVerticalAlignment(this);
    }

    @Override
    public Byte getOwnVerticalAlignment() {
        return ((JRTextElement)this.parent).getOwnVerticalAlignment();
    }

    @Override
    public void setVerticalAlignment(byte verticalAlignment) {
    }

    @Override
    public void setVerticalAlignment(Byte verticalAlignment) {
    }

    @Override
    public byte getRotation() {
        return JRStyleResolver.getRotation(this);
    }

    @Override
    public Byte getOwnRotation() {
        return ((JRTextElement)this.parent).getOwnRotation();
    }

    @Override
    public void setRotation(byte rotation) {
    }

    @Override
    public void setRotation(Byte rotation) {
    }

    @Override
    public byte getLineSpacing() {
        return JRStyleResolver.getLineSpacing(this);
    }

    @Override
    public Byte getOwnLineSpacing() {
        return ((JRTextElement)this.parent).getOwnLineSpacing();
    }

    @Override
    public void setLineSpacing(byte lineSpacing) {
    }

    @Override
    public void setLineSpacing(Byte lineSpacing) {
    }

    @Override
    public boolean isStyledText() {
        return JRStyleResolver.isStyledText(this);
    }

    @Override
    public Boolean isOwnStyledText() {
        return ((JRTextElement)this.parent).isOwnStyledText();
    }

    @Override
    public void setStyledText(boolean isStyledText) {
    }

    @Override
    public void setStyledText(Boolean isStyledText) {
    }

    @Override
    public JRBox getBox() {
        return this;
    }

    @Override
    public JRFont getFont() {
        return this;
    }

    protected Map getStyledTextAttributes() {
        JRStyle style = this.getStyle();
        HashMap<TextAttribute, Color> styledTextAttributes = (HashMap<TextAttribute, Color>)this.styledTextAttributesMap.get(style);
        if (styledTextAttributes == null) {
            styledTextAttributes = new HashMap<TextAttribute, Color>();
            JRFontUtil.setAttributes(styledTextAttributes, this);
            styledTextAttributes.put(TextAttribute.FOREGROUND, this.getForecolor());
            if (this.getMode() == 1) {
                styledTextAttributes.put(TextAttribute.BACKGROUND, this.getBackcolor());
            }
            this.styledTextAttributesMap.put(style, styledTextAttributes);
        }
        return styledTextAttributes;
    }

    protected float getLineSpacingFactor() {
        return this.lineSpacingFactor;
    }

    protected void setLineSpacingFactor(float lineSpacingFactor) {
        this.lineSpacingFactor = lineSpacingFactor;
    }

    protected float getLeadingOffset() {
        return this.leadingOffset;
    }

    protected void setLeadingOffset(float leadingOffset) {
        this.leadingOffset = leadingOffset;
    }

    protected byte getRunDirection() {
        return this.isLeftToRight ? (byte)0 : 1;
    }

    protected float getTextHeight() {
        return this.textHeight;
    }

    protected void setTextHeight(float textHeight) {
        this.textHeight = textHeight;
    }

    protected int getTextStart() {
        return this.textStart;
    }

    protected void setTextStart(int textStart) {
        this.textStart = textStart;
    }

    protected int getTextEnd() {
        return this.textEnd;
    }

    protected void setTextEnd(int textEnd) {
        this.textEnd = textEnd;
    }

    protected String getRawText() {
        return this.rawText;
    }

    protected void setRawText(String rawText) {
        this.rawText = rawText;
        this.styledText = null;
    }

    @Override
    protected void reset() {
        super.reset();
        this.isLeftToRight = true;
        this.lineSpacingFactor = 0.0f;
        this.leadingOffset = 0.0f;
        this.textHeight = 0.0f;
    }

    @Override
    protected void rewind() {
        this.textStart = 0;
        this.textEnd = 0;
    }

    protected JRStyledText getStyledText() {
        String text;
        if (this.styledText == null && (text = this.getRawText()) != null) {
            if (this.isStyledText()) {
                try {
                    this.styledText = this.filler.getStyledTextParser().parse(this.getStyledTextAttributes(), text, true);
                }
                catch (SAXException sAXException) {
                    // empty catch block
                }
            }
            if (this.styledText == null) {
                this.styledText = new JRStyledText();
                this.styledText.append(text);
                this.styledText.addRun(new JRStyledText.Run(this.getStyledTextAttributes(), 0, text.length()));
            }
        }
        return this.styledText;
    }

    public String getText() {
        JRStyledText tmpStyledText = this.getStyledText();
        if (tmpStyledText == null) {
            return null;
        }
        return tmpStyledText.getText();
    }

    protected void chopTextElement(int availableStretchHeight) {
        JRStyledText tmpStyledText = this.getStyledText();
        if (tmpStyledText == null) {
            return;
        }
        String remainingText = this.getText().substring(this.getTextEnd());
        if (remainingText.length() == 0) {
            return;
        }
        this.textMeasurer.measure(tmpStyledText, remainingText, this.getTextEnd(), availableStretchHeight);
        this.isLeftToRight = this.textMeasurer.isLeftToRight();
        this.setTextHeight(this.textMeasurer.getTextHeight());
        if (this.getRotation() == 0) {
            if (this.parent != null && this.parent instanceof JRTextField && ((JRTextField)this.parent).isStretchWithOverflow()) {
                this.setStretchHeight((int)this.getTextHeight() + this.getTopPadding() + this.getBottomPadding());
            } else {
                this.setStretchHeight(this.getHeight());
            }
        } else {
            this.setStretchHeight(this.getHeight());
        }
        this.setTextStart(this.getTextEnd());
        this.setTextEnd(this.textMeasurer.getTextOffset());
        this.setLineSpacingFactor(this.textMeasurer.getLineSpacingFactor());
        this.setLeadingOffset(this.textMeasurer.getLeadingOffset());
    }

    @Override
    public byte getBorder() {
        return JRStyleResolver.getBorder(this);
    }

    @Override
    public Byte getOwnBorder() {
        return ((JRBox)((Object)this.parent)).getOwnBorder();
    }

    @Override
    public void setBorder(byte border) {
    }

    @Override
    public Color getBorderColor() {
        return JRStyleResolver.getBorderColor(this, this.getForecolor());
    }

    @Override
    public Color getOwnBorderColor() {
        return ((JRBox)((Object)this.parent)).getOwnBorderColor();
    }

    @Override
    public void setBorderColor(Color borderColor) {
    }

    @Override
    public int getPadding() {
        return JRStyleResolver.getPadding(this);
    }

    @Override
    public Integer getOwnPadding() {
        return ((JRBox)((Object)this.parent)).getOwnPadding();
    }

    @Override
    public void setPadding(int padding) {
    }

    @Override
    public byte getTopBorder() {
        return JRStyleResolver.getTopBorder(this);
    }

    @Override
    public Byte getOwnTopBorder() {
        return ((JRBox)((Object)this.parent)).getOwnTopBorder();
    }

    @Override
    public void setTopBorder(byte topBorder) {
    }

    @Override
    public Color getTopBorderColor() {
        return JRStyleResolver.getTopBorderColor(this, this.getForecolor());
    }

    @Override
    public Color getOwnTopBorderColor() {
        return ((JRBox)((Object)this.parent)).getOwnTopBorderColor();
    }

    @Override
    public void setTopBorderColor(Color topBorderColor) {
    }

    @Override
    public int getTopPadding() {
        return JRStyleResolver.getTopPadding(this);
    }

    @Override
    public Integer getOwnTopPadding() {
        return ((JRBox)((Object)this.parent)).getOwnTopPadding();
    }

    @Override
    public void setTopPadding(int topPadding) {
    }

    @Override
    public byte getLeftBorder() {
        return JRStyleResolver.getLeftBorder(this);
    }

    @Override
    public Byte getOwnLeftBorder() {
        return ((JRBox)((Object)this.parent)).getOwnLeftBorder();
    }

    @Override
    public void setLeftBorder(byte leftBorder) {
    }

    @Override
    public Color getLeftBorderColor() {
        return JRStyleResolver.getLeftBorderColor(this, this.getForecolor());
    }

    @Override
    public Color getOwnLeftBorderColor() {
        return ((JRBox)((Object)this.parent)).getOwnLeftBorderColor();
    }

    @Override
    public void setLeftBorderColor(Color leftBorderColor) {
    }

    @Override
    public int getLeftPadding() {
        return JRStyleResolver.getLeftPadding(this);
    }

    @Override
    public Integer getOwnLeftPadding() {
        return ((JRBox)((Object)this.parent)).getOwnLeftPadding();
    }

    @Override
    public void setLeftPadding(int leftPadding) {
    }

    @Override
    public byte getBottomBorder() {
        return JRStyleResolver.getBottomBorder(this);
    }

    @Override
    public Byte getOwnBottomBorder() {
        return ((JRBox)((Object)this.parent)).getOwnBottomBorder();
    }

    @Override
    public void setBottomBorder(byte bottomBorder) {
    }

    @Override
    public Color getBottomBorderColor() {
        return JRStyleResolver.getBottomBorderColor(this, this.getForecolor());
    }

    @Override
    public Color getOwnBottomBorderColor() {
        return ((JRBox)((Object)this.parent)).getOwnBottomBorderColor();
    }

    @Override
    public void setBottomBorderColor(Color bottomBorderColor) {
    }

    @Override
    public int getBottomPadding() {
        return JRStyleResolver.getBottomPadding(this);
    }

    @Override
    public Integer getOwnBottomPadding() {
        return ((JRBox)((Object)this.parent)).getOwnBottomPadding();
    }

    @Override
    public void setBottomPadding(int bottomPadding) {
    }

    @Override
    public byte getRightBorder() {
        return JRStyleResolver.getRightBorder(this);
    }

    @Override
    public Byte getOwnRightBorder() {
        return ((JRBox)((Object)this.parent)).getOwnRightBorder();
    }

    @Override
    public void setRightBorder(byte rightBorder) {
    }

    @Override
    public Color getRightBorderColor() {
        return JRStyleResolver.getRightBorderColor(this, this.getForecolor());
    }

    @Override
    public Color getOwnRightBorderColor() {
        return ((JRBox)((Object)this.parent)).getOwnRightBorderColor();
    }

    @Override
    public void setRightBorderColor(Color rightBorderColor) {
    }

    @Override
    public int getRightPadding() {
        return JRStyleResolver.getRightPadding(this);
    }

    @Override
    public Integer getOwnRightPadding() {
        return ((JRBox)((Object)this.parent)).getOwnRightPadding();
    }

    @Override
    public void setRightPadding(int rightPadding) {
    }

    @Override
    public JRReportFont getReportFont() {
        return this.reportFont;
    }

    @Override
    public void setReportFont(JRReportFont reportFont) {
    }

    @Override
    public String getFontName() {
        return JRStyleResolver.getFontName(this);
    }

    @Override
    public String getOwnFontName() {
        return ((JRFont)((Object)this.parent)).getOwnFontName();
    }

    @Override
    public void setFontName(String fontName) {
    }

    @Override
    public boolean isBold() {
        return JRStyleResolver.isBold(this);
    }

    @Override
    public Boolean isOwnBold() {
        return ((JRFont)((Object)this.parent)).isOwnBold();
    }

    @Override
    public void setBold(boolean isBold) {
    }

    @Override
    public void setBold(Boolean isBold) {
    }

    @Override
    public boolean isItalic() {
        return JRStyleResolver.isItalic(this);
    }

    @Override
    public Boolean isOwnItalic() {
        return ((JRFont)((Object)this.parent)).isOwnItalic();
    }

    @Override
    public void setItalic(boolean isItalic) {
    }

    @Override
    public void setItalic(Boolean isItalic) {
    }

    @Override
    public boolean isUnderline() {
        return JRStyleResolver.isUnderline(this);
    }

    @Override
    public Boolean isOwnUnderline() {
        return ((JRFont)((Object)this.parent)).isOwnUnderline();
    }

    @Override
    public void setUnderline(boolean isUnderline) {
    }

    @Override
    public void setUnderline(Boolean isUnderline) {
    }

    @Override
    public boolean isStrikeThrough() {
        return JRStyleResolver.isStrikeThrough(this);
    }

    @Override
    public Boolean isOwnStrikeThrough() {
        return ((JRFont)((Object)this.parent)).isOwnStrikeThrough();
    }

    @Override
    public void setStrikeThrough(boolean isStrikeThrough) {
    }

    @Override
    public void setStrikeThrough(Boolean isStrikeThrough) {
    }

    @Override
    public int getFontSize() {
        return JRStyleResolver.getFontSize(this);
    }

    @Override
    public Integer getOwnFontSize() {
        return ((JRFont)((Object)this.parent)).getOwnFontSize();
    }

    @Override
    public void setFontSize(int size) {
    }

    @Override
    public void setFontSize(Integer size) {
    }

    @Override
    public int getSize() {
        return this.getFontSize();
    }

    @Override
    public Integer getOwnSize() {
        return this.getOwnFontSize();
    }

    @Override
    public void setSize(int size) {
    }

    @Override
    public void setSize(Integer size) {
    }

    @Override
    public String getPdfFontName() {
        return JRStyleResolver.getPdfFontName(this);
    }

    @Override
    public String getOwnPdfFontName() {
        return ((JRFont)((Object)this.parent)).getOwnPdfFontName();
    }

    @Override
    public void setPdfFontName(String pdfFontName) {
    }

    @Override
    public String getPdfEncoding() {
        return JRStyleResolver.getPdfEncoding(this);
    }

    @Override
    public String getOwnPdfEncoding() {
        return ((JRFont)((Object)this.parent)).getOwnPdfEncoding();
    }

    @Override
    public void setPdfEncoding(String pdfEncoding) {
    }

    @Override
    public boolean isPdfEmbedded() {
        return JRStyleResolver.isPdfEmbedded(this);
    }

    @Override
    public Boolean isOwnPdfEmbedded() {
        return ((JRFont)((Object)this.parent)).isOwnPdfEmbedded();
    }

    @Override
    public void setPdfEmbedded(boolean isPdfEmbedded) {
        this.setPdfEmbedded(isPdfEmbedded ? Boolean.TRUE : Boolean.FALSE);
    }

    @Override
    public void setPdfEmbedded(Boolean isPdfEmbedded) {
    }

    @Override
    public void setBorder(Byte border) {
    }

    @Override
    public void setPadding(Integer padding) {
    }

    @Override
    public void setTopBorder(Byte topBorder) {
    }

    @Override
    public void setTopPadding(Integer topPadding) {
    }

    @Override
    public void setLeftBorder(Byte leftBorder) {
    }

    @Override
    public void setLeftPadding(Integer leftPadding) {
    }

    @Override
    public void setBottomBorder(Byte bottomBorder) {
    }

    @Override
    public void setBottomPadding(Integer bottomPadding) {
    }

    @Override
    public void setRightBorder(Byte rightBorder) {
    }

    @Override
    public void setRightPadding(Integer rightPadding) {
    }

    @Override
    public void setHeight(int height) {
        super.setHeight(height);
        this.createTextMeasurer();
    }

    @Override
    public void setWidth(int width) {
        super.setWidth(width);
        this.createTextMeasurer();
    }

    protected static interface TextChopper {
        public String chop(JRFillTextElement var1, int var2, int var3);
    }
}

