/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.base;

import java.io.IOException;
import java.io.ObjectInputStream;
import net.sf.jasperreports.engine.JRAbstractObjectFactory;
import net.sf.jasperreports.engine.JRChild;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRExpressionCollector;
import net.sf.jasperreports.engine.JRGroup;
import net.sf.jasperreports.engine.JRHyperlinkHelper;
import net.sf.jasperreports.engine.JRHyperlinkParameter;
import net.sf.jasperreports.engine.JRTextField;
import net.sf.jasperreports.engine.base.JRBaseHyperlink;
import net.sf.jasperreports.engine.base.JRBaseObjectFactory;
import net.sf.jasperreports.engine.base.JRBaseTextElement;
import net.sf.jasperreports.engine.util.JRStyleResolver;
import net.sf.jasperreports.engine.xml.JRXmlWriter;

public class JRBaseTextField
extends JRBaseTextElement
implements JRTextField {
    private static final long serialVersionUID = 10200L;
    protected boolean isStretchWithOverflow = false;
    protected byte evaluationTime = 1;
    protected String pattern;
    protected Boolean isBlankWhenNull = null;
    protected byte hyperlinkType = 0;
    protected String linkType;
    protected byte hyperlinkTarget = 1;
    private JRHyperlinkParameter[] hyperlinkParameters;
    protected JRGroup evaluationGroup = null;
    protected JRExpression expression = null;
    protected JRExpression anchorNameExpression = null;
    protected JRExpression hyperlinkReferenceExpression = null;
    protected JRExpression hyperlinkAnchorExpression = null;
    protected JRExpression hyperlinkPageExpression = null;
    private JRExpression hyperlinkTooltipExpression;
    protected int bookmarkLevel = 0;

    protected JRBaseTextField(JRTextField textField, JRBaseObjectFactory factory) {
        super(textField, factory);
        this.isStretchWithOverflow = textField.isStretchWithOverflow();
        this.evaluationTime = textField.getEvaluationTime();
        this.pattern = textField.getOwnPattern();
        this.isBlankWhenNull = textField.isOwnBlankWhenNull();
        this.linkType = textField.getLinkType();
        this.hyperlinkTarget = textField.getHyperlinkTarget();
        this.hyperlinkParameters = JRBaseHyperlink.copyHyperlinkParameters(textField, factory);
        this.evaluationGroup = factory.getGroup(textField.getEvaluationGroup());
        this.expression = factory.getExpression(textField.getExpression());
        this.anchorNameExpression = factory.getExpression(textField.getAnchorNameExpression());
        this.hyperlinkReferenceExpression = factory.getExpression(textField.getHyperlinkReferenceExpression());
        this.hyperlinkAnchorExpression = factory.getExpression(textField.getHyperlinkAnchorExpression());
        this.hyperlinkPageExpression = factory.getExpression(textField.getHyperlinkPageExpression());
        this.hyperlinkTooltipExpression = factory.getExpression(textField.getHyperlinkTooltipExpression());
        this.bookmarkLevel = textField.getBookmarkLevel();
    }

    @Override
    public boolean isStretchWithOverflow() {
        return this.isStretchWithOverflow;
    }

    @Override
    public void setStretchWithOverflow(boolean isStretchWithOverflow) {
        this.isStretchWithOverflow = isStretchWithOverflow;
    }

    @Override
    public byte getEvaluationTime() {
        return this.evaluationTime;
    }

    @Override
    public String getPattern() {
        return JRStyleResolver.getPattern(this);
    }

    @Override
    public String getOwnPattern() {
        return this.pattern;
    }

    @Override
    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    @Override
    public boolean isBlankWhenNull() {
        return JRStyleResolver.isBlankWhenNull(this);
    }

    @Override
    public Boolean isOwnBlankWhenNull() {
        return this.isBlankWhenNull;
    }

    @Override
    public void setBlankWhenNull(Boolean isBlank) {
        this.isBlankWhenNull = isBlank;
    }

    @Override
    public void setBlankWhenNull(boolean isBlank) {
        this.isBlankWhenNull = isBlank ? Boolean.TRUE : Boolean.FALSE;
    }

    @Override
    public byte getHyperlinkType() {
        return JRHyperlinkHelper.getHyperlinkType(this);
    }

    @Override
    public byte getHyperlinkTarget() {
        return this.hyperlinkTarget;
    }

    @Override
    public JRGroup getEvaluationGroup() {
        return this.evaluationGroup;
    }

    @Override
    public JRExpression getExpression() {
        return this.expression;
    }

    @Override
    public JRExpression getAnchorNameExpression() {
        return this.anchorNameExpression;
    }

    @Override
    public JRExpression getHyperlinkReferenceExpression() {
        return this.hyperlinkReferenceExpression;
    }

    @Override
    public JRExpression getHyperlinkAnchorExpression() {
        return this.hyperlinkAnchorExpression;
    }

    @Override
    public JRExpression getHyperlinkPageExpression() {
        return this.hyperlinkPageExpression;
    }

    @Override
    public JRChild getCopy(JRAbstractObjectFactory factory) {
        return factory.getTextField(this);
    }

    @Override
    public void collectExpressions(JRExpressionCollector collector) {
        collector.collect(this);
    }

    @Override
    public void writeXml(JRXmlWriter xmlWriter) throws IOException {
        xmlWriter.writeTextField(this);
    }

    @Override
    public int getBookmarkLevel() {
        return this.bookmarkLevel;
    }

    @Override
    public String getLinkType() {
        return this.linkType;
    }

    @Override
    public JRHyperlinkParameter[] getHyperlinkParameters() {
        return this.hyperlinkParameters;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.normalizeLinkType();
    }

    protected void normalizeLinkType() {
        if (this.linkType == null) {
            this.linkType = JRHyperlinkHelper.getLinkType(this.hyperlinkType);
        }
        this.hyperlinkType = 0;
    }

    @Override
    public JRExpression getHyperlinkTooltipExpression() {
        return this.hyperlinkTooltipExpression;
    }
}

