/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.gcp.storage.consumer;

import coldfusion.cloud.util.ConsumerMap;
import coldfusion.cloud.util.ConsumerValidator;
import coldfusion.cloud.util.FieldTypecastUtil;
import coldfusion.cloud.util.ValidatorFiller;
import coldfusion.cloud.validator.EmptyListValidator;
import coldfusion.cloud.validator.NotNullValidator;
import coldfusion.gcp.storage.consumer.BlobInfoConsumer;
import coldfusion.gcp.storage.consumer.BlobWriteOptionConsumer;
import coldfusion.gcp.storage.request.BlobWriteOptionBuilder;
import coldfusion.gcp.storage.request.UploadObjectBuilder;
import com.google.cloud.storage.BlobInfo;
import com.google.cloud.storage.Storage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class UploadObjectConsumer
extends ConsumerMap<UploadObjectBuilder> {
    private static final long serialVersionUID = 1L;
    private final FieldTypecastUtil cast = FieldTypecastUtil.INSTANCE;
    private static UploadObjectConsumer instance;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static UploadObjectConsumer getInstance() {
        if (instance != null) return instance;
        Class<UploadObjectConsumer> clazz = UploadObjectConsumer.class;
        synchronized (UploadObjectConsumer.class) {
            if (instance != null) return instance;
            instance = new UploadObjectConsumer();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private UploadObjectConsumer() {
        this.put("object", new ConsumerValidator((uploadObjectBuilder, value) -> uploadObjectBuilder.setObject(value), Collections.singletonList(NotNullValidator.INSTANCE)));
        this.put("blobInfo", new ConsumerValidator((downloadObjectBuilder, value) -> {
            Map blobInfoReq = this.cast.getMapProperty(value);
            BlobInfo.Builder builder = BlobInfo.newBuilder((String)"", (String)"");
            ValidatorFiller.INSTANCE.fillObject((Object)builder, blobInfoReq, (ConsumerMap)BlobInfoConsumer.getInstance());
            BlobInfo blobInfo = builder.build();
            downloadObjectBuilder.setBlobInfo(blobInfo);
        }, Collections.singletonList(NotNullValidator.INSTANCE)));
        this.put("blobWriteOption", new ConsumerValidator((downloadObjectBuilder, value) -> {
            List obj = this.cast.getListProperty(value);
            ArrayList<Storage.BlobWriteOption> list = new ArrayList<Storage.BlobWriteOption>();
            for (int i = 0; i < obj.size(); ++i) {
                Map storageBlobWriteOpt = this.cast.getStringObjectMapProperty(obj.get(i));
                BlobWriteOptionBuilder blobWriteOptionBuilder = new BlobWriteOptionBuilder();
                ValidatorFiller.INSTANCE.fillObject((Object)blobWriteOptionBuilder, storageBlobWriteOpt, (ConsumerMap)BlobWriteOptionConsumer.getInstance());
                list.addAll(blobWriteOptionBuilder.getBlobWriteOption());
            }
            downloadObjectBuilder.setBlobWriteOption(list);
        }, Collections.singletonList(new EmptyListValidator("blobWriteOption"))));
    }
}

