/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.gcp.storage.consumer;

import coldfusion.cloud.util.ConsumerMap;
import coldfusion.cloud.util.ConsumerValidator;
import coldfusion.cloud.util.FieldTypecastUtil;
import coldfusion.cloud.util.ValidationUtil;
import coldfusion.cloud.validator.NotNullValidator;
import coldfusion.gcp.storage.request.ObjectMetadataBuilder;
import java.util.Collections;
import java.util.Map;

public class ObjectMetadataConsumer
extends ConsumerMap<ObjectMetadataBuilder> {
    private static final long serialVersionUID = 28499306442667301L;
    private static ObjectMetadataConsumer instance;
    private FieldTypecastUtil cast = FieldTypecastUtil.INSTANCE;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ObjectMetadataConsumer getInstance() {
        if (instance != null) return instance;
        Class<ObjectMetadataConsumer> clazz = ObjectMetadataConsumer.class;
        synchronized (ObjectMetadataConsumer.class) {
            instance = new ObjectMetadataConsumer();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private ObjectMetadataConsumer() {
        this.put("key", new ConsumerValidator((builder, value) -> {
            String objectName = this.cast.getStringProperty(value);
            ValidationUtil.validNonEmptyString((String)objectName, (String)"key");
            builder.setObjectName(objectName);
        }, Collections.singletonList(NotNullValidator.INSTANCE)));
        this.put("tags", new ConsumerValidator((builder, value) -> {
            Map labelsMap = this.cast.getMapProperty(value);
            for (String key : labelsMap.keySet()) {
                String val = (String)labelsMap.get(key);
                ValidationUtil.validNonBlankString((String)key, (String)"tags");
                ValidationUtil.validNonEmptyString((String)val, (String)"tags");
            }
            builder.setMetadata(labelsMap);
        }, Collections.singletonList(NotNullValidator.INSTANCE)));
    }
}

