/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.gcp.storage.consumer;

import coldfusion.cloud.util.ConsumerMap;
import coldfusion.cloud.util.ConsumerValidator;
import coldfusion.cloud.util.FieldTypecastUtil;
import coldfusion.cloud.validator.CFPositiveLongValidator;
import coldfusion.cloud.validator.NotNullValidator;
import coldfusion.gcp.BucketReference;
import coldfusion.gcp.storage.exception.CFStorageException;
import coldfusion.gcp.storage.request.ForceDeleteBuilder;
import coldfusion.util.RB;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.concurrent.TimeUnit;

public class ForceDeleteConsumer
extends ConsumerMap<ForceDeleteBuilder> {
    private static final long serialVersionUID = -7995789578197597547L;
    private FieldTypecastUtil cast = FieldTypecastUtil.INSTANCE;
    private static ForceDeleteConsumer instance;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ForceDeleteConsumer getInstance() {
        if (instance != null) return instance;
        Class<ForceDeleteConsumer> clazz = ForceDeleteConsumer.class;
        synchronized (ForceDeleteConsumer.class) {
            if (instance != null) return instance;
            instance = new ForceDeleteConsumer();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private ForceDeleteConsumer() {
        this.put("timeout", new ConsumerValidator((builder, value) -> {
            long timeout = this.cast.getLongProperty(value);
            builder.setTimeout(timeout);
        }, Collections.singletonList(new CFPositiveLongValidator("timeout"))));
        this.put("unit", new ConsumerValidator((builder, value) -> {
            String unit = this.cast.getStringProperty(value).toUpperCase();
            HashSet<TimeUnit> validValue = new HashSet<TimeUnit>(Arrays.asList(TimeUnit.values()));
            try {
                builder.setUnit(TimeUnit.valueOf(unit));
            }
            catch (IllegalArgumentException e) {
                throw new CFStorageException(RB.getString(BucketReference.class, (String)"INVALID_UNIT", (Object)value, (Object)((Object)validValue).toString()));
            }
        }, Collections.singletonList(NotNullValidator.INSTANCE)));
    }
}

