/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.gcp.storage.consumer;

import coldfusion.cloud.util.ConsumerMap;
import coldfusion.cloud.util.ConsumerValidator;
import coldfusion.cloud.util.FieldTypecastUtil;
import coldfusion.cloud.util.ValidationUtil;
import coldfusion.cloud.validator.NotNullValidator;
import coldfusion.gcp.storage.request.BucketBoundHostNameBuilder;
import com.google.cloud.storage.Storage;
import java.util.Collections;

public class BucketBoundHostNameConsumer
extends ConsumerMap<BucketBoundHostNameBuilder> {
    private static final long serialVersionUID = 1L;
    private FieldTypecastUtil cast = FieldTypecastUtil.INSTANCE;
    private static BucketBoundHostNameConsumer instance;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static BucketBoundHostNameConsumer getInstance() {
        if (instance != null) return instance;
        Class<BucketBoundHostNameConsumer> clazz = BucketBoundHostNameConsumer.class;
        synchronized (BucketBoundHostNameConsumer.class) {
            instance = new BucketBoundHostNameConsumer();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private BucketBoundHostNameConsumer() {
        this.put("bucketBoundHostname", new ConsumerValidator((bucketBoundHostNameBuilder, value) -> {
            String bucketBoundHostname = this.cast.getStringProperty(value);
            ValidationUtil.validNonBlankString((String)bucketBoundHostname, (String)"bucketBoundHostname");
            bucketBoundHostNameBuilder.setBucketBoundHostname(bucketBoundHostname);
        }, Collections.singletonList(NotNullValidator.INSTANCE)));
        this.put("uriScheme", new ConsumerValidator((bucketBoundHostNameBuilder, value) -> {
            String uriScheme = this.cast.getStringProperty(value);
            ValidationUtil.validNonBlankString((String)uriScheme, (String)"uriScheme");
            bucketBoundHostNameBuilder.setUriScheme(Storage.UriScheme.valueOf((String)uriScheme));
        }, Collections.emptyList()));
    }
}

