/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.gcp.storage.consumer;

import coldfusion.cloud.util.ConsumerMap;
import coldfusion.cloud.util.ConsumerValidator;
import coldfusion.cloud.util.FieldTypecastUtil;
import coldfusion.cloud.util.ValidationUtil;
import coldfusion.cloud.util.ValidatorFiller;
import coldfusion.gcp.storage.consumer.AclProjectConsumer;
import coldfusion.gcp.storage.request.AclEntityBuilder;
import coldfusion.gcp.storage.request.AclProjectBuilder;
import com.google.cloud.storage.Acl;
import java.util.Collections;
import java.util.Map;

public class AclEntityConsumer
extends ConsumerMap<AclEntityBuilder> {
    private static final long serialVersionUID = -9077995796092623898L;
    private final FieldTypecastUtil cast = FieldTypecastUtil.INSTANCE;
    private static AclEntityConsumer instance;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static AclEntityConsumer getInstance() {
        if (instance != null) return instance;
        Class<AclEntityConsumer> clazz = AclEntityConsumer.class;
        synchronized (AclEntityConsumer.class) {
            instance = new AclEntityConsumer();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private AclEntityConsumer() {
        this.put("domain", new ConsumerValidator((entityBuilder, val) -> {
            String domain = this.cast.getStringProperty(val);
            ValidationUtil.validNonBlankString((String)domain, (String)"domain");
            entityBuilder.setDomain(domain);
        }, Collections.emptyList()));
        this.put("group", new ConsumerValidator((entityBuilder, val) -> {
            String group = this.cast.getStringProperty(val);
            ValidationUtil.validNonBlankString((String)group, (String)"group");
            entityBuilder.setGroup(group);
        }, Collections.emptyList()));
        this.put("project", new ConsumerValidator((entityBuilder, val) -> {
            Map map = this.cast.getStringStringMapProperty(val);
            AclProjectBuilder projectBuilder = new AclProjectBuilder();
            ValidatorFiller.INSTANCE.fillObject((Object)projectBuilder, map, (ConsumerMap)AclProjectConsumer.getInstance());
            entityBuilder.setProject(new Acl.Project(Acl.Project.ProjectRole.valueOfStrict((String)projectBuilder.getProjectRole()), projectBuilder.getProjectId()));
        }, Collections.emptyList()));
        this.put("user", new ConsumerValidator((entityBuilder, val) -> {
            String user = this.cast.getStringProperty(val);
            ValidationUtil.validNonBlankString((String)user, (String)"user");
            entityBuilder.setUser(user);
        }, Collections.emptyList()));
    }
}

