/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.core.retry.conditions;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.core.retry.RetryPolicyContext;
import software.amazon.awssdk.core.retry.conditions.RetryCondition;
import software.amazon.awssdk.utils.ToString;

@SdkPublicApi
public final class OrRetryCondition
implements RetryCondition {
    private Set<RetryCondition> conditions = new HashSet<RetryCondition>();

    private OrRetryCondition(RetryCondition ... conditions) {
        Collections.addAll(this.conditions, conditions);
    }

    @Override
    public boolean shouldRetry(RetryPolicyContext context) {
        return this.conditions.stream().anyMatch(r -> r.shouldRetry(context));
    }

    public static OrRetryCondition create(RetryCondition ... conditions) {
        return new OrRetryCondition(conditions);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OrRetryCondition that = (OrRetryCondition)o;
        return this.conditions.equals(that.conditions);
    }

    public int hashCode() {
        return this.conditions.hashCode();
    }

    public String toString() {
        return ToString.builder((String)"OrRetryCondition").add("conditions", this.conditions).build();
    }
}

