/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.core.retry.conditions;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.core.retry.RetryPolicyContext;
import software.amazon.awssdk.core.retry.conditions.RetryCondition;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.Validate;

@SdkPublicApi
public final class AndRetryCondition
implements RetryCondition {
    private Set<RetryCondition> conditions = new HashSet<RetryCondition>();

    private AndRetryCondition(RetryCondition ... conditions) {
        Collections.addAll(this.conditions, Validate.notEmpty((Object[])conditions, (String)"%s cannot be empty.", (Object[])new Object[]{"conditions"}));
    }

    @Override
    public boolean shouldRetry(RetryPolicyContext context) {
        return this.conditions.stream().allMatch(r -> r.shouldRetry(context));
    }

    public static AndRetryCondition create(RetryCondition ... conditions) {
        return new AndRetryCondition(conditions);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AndRetryCondition that = (AndRetryCondition)o;
        return this.conditions != null ? this.conditions.equals(that.conditions) : that.conditions == null;
    }

    public int hashCode() {
        return this.conditions != null ? this.conditions.hashCode() : 0;
    }

    public String toString() {
        return ToString.builder((String)"AndRetryCondition").add("conditions", this.conditions).build();
    }
}

