/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.core.internal.http.pipeline.stages;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.internal.http.HttpClientDependencies;
import software.amazon.awssdk.core.internal.http.RequestExecutionContext;
import software.amazon.awssdk.core.internal.http.pipeline.MutableRequestToRequestPipeline;
import software.amazon.awssdk.http.SdkHttpFullRequest;

@SdkInternalApi
public class MergeCustomHeadersStage
implements MutableRequestToRequestPipeline {
    private final SdkClientConfiguration config;

    public MergeCustomHeadersStage(HttpClientDependencies dependencies) {
        this.config = dependencies.clientConfiguration();
    }

    @Override
    public SdkHttpFullRequest.Builder execute(SdkHttpFullRequest.Builder request, RequestExecutionContext context) throws Exception {
        return request.headers(this.mergeHeaders(request.headers(), this.config.option(SdkClientOption.ADDITIONAL_HTTP_HEADERS), this.adaptHeaders(context.requestConfig().headers())));
    }

    @SafeVarargs
    private final Map<String, List<String>> mergeHeaders(Map<String, List<String>> ... headers) {
        LinkedHashMap<String, List<String>> result = new LinkedHashMap<String, List<String>>();
        for (Map<String, List<String>> header : headers) {
            header.forEach((k, v) -> result.computeIfAbsent((String)k, ignored -> new ArrayList()).addAll(v));
        }
        return result;
    }

    private Map<String, List<String>> adaptHeaders(Map<String, List<String>> toConvert) {
        TreeMap<String, List<String>> adapted = new TreeMap<String, List<String>>();
        toConvert.forEach((name, value) -> {
            List cfr_ignored_0 = adapted.put((String)name, new ArrayList(value));
        });
        return adapted;
    }
}

