/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.core.internal;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkException;
import software.amazon.awssdk.http.SdkHttpFullResponse;

@SdkInternalApi
public final class Response<T> {
    private final boolean isSuccess;
    private final T response;
    private final SdkException exception;
    private final SdkHttpFullResponse httpResponse;

    private Response(boolean isSuccess, T response, SdkException exception, SdkHttpFullResponse httpResponse) {
        this.isSuccess = isSuccess;
        this.response = response;
        this.exception = exception;
        this.httpResponse = httpResponse;
    }

    public T response() {
        return this.response;
    }

    public SdkException exception() {
        return this.exception;
    }

    public SdkHttpFullResponse httpResponse() {
        return this.httpResponse;
    }

    public boolean isSuccess() {
        return this.isSuccess;
    }

    public boolean isFailure() {
        return !this.isSuccess;
    }

    public static <T> Response<T> fromSuccess(T response, SdkHttpFullResponse httpResponse) {
        return new Response<T>(true, response, null, httpResponse);
    }

    public static <T> Response<T> fromFailure(SdkException exception, SdkHttpFullResponse httpResponse) {
        return new Response<Object>(false, null, exception, httpResponse);
    }
}

