/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.core.async;

import java.io.File;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Optional;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.internal.async.ByteArrayAsyncRequestBody;
import software.amazon.awssdk.core.internal.async.FileAsyncRequestBody;
import software.amazon.awssdk.utils.BinaryUtils;

@SdkPublicApi
public interface AsyncRequestBody
extends SdkPublisher<ByteBuffer> {
    public Optional<Long> contentLength();

    public static AsyncRequestBody fromPublisher(final Publisher<ByteBuffer> publisher) {
        return new AsyncRequestBody(){

            @Override
            public Optional<Long> contentLength() {
                return Optional.empty();
            }

            public void subscribe(Subscriber<? super ByteBuffer> s) {
                publisher.subscribe(s);
            }
        };
    }

    public static AsyncRequestBody fromFile(Path path) {
        return (AsyncRequestBody)FileAsyncRequestBody.builder().path(path).build();
    }

    public static AsyncRequestBody fromFile(File file) {
        return (AsyncRequestBody)FileAsyncRequestBody.builder().path(file.toPath()).build();
    }

    public static AsyncRequestBody fromString(String string, Charset cs) {
        return new ByteArrayAsyncRequestBody(string.getBytes(cs));
    }

    public static AsyncRequestBody fromString(String string) {
        return AsyncRequestBody.fromString(string, StandardCharsets.UTF_8);
    }

    public static AsyncRequestBody fromBytes(byte[] bytes) {
        return new ByteArrayAsyncRequestBody(Arrays.copyOf(bytes, bytes.length));
    }

    public static AsyncRequestBody fromByteBuffer(ByteBuffer byteBuffer) {
        return new ByteArrayAsyncRequestBody(BinaryUtils.copyAllBytesFrom((ByteBuffer)byteBuffer));
    }

    public static AsyncRequestBody empty() {
        return AsyncRequestBody.fromBytes(new byte[0]);
    }
}

