/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.vfs.s3.credentials;

import coldfusion.log.Logger;
import coldfusion.server.ServiceFactory;
import coldfusion.vfs.s3.credentials.AWSCredentialsProvider;
import coldfusion.vfs.s3.credentials.AWSCredentialsWithRegion;
import coldfusion.vfs.s3.credentials.AWSSystemSettings;
import org.jets3t.service.security.AWSCredentials;

public final class EnvironmentVariableCredentialsProvider
implements AWSCredentialsProvider {
    private final Logger logger = ServiceFactory.getLoggingService().getLogger("awsS3Legacy");

    @Override
    public AWSCredentials loadCredentials() {
        Object awsCredentials = null;
        String accessKeyId = System.getenv(AWSSystemSettings.ENV_AWS_ACCESS_KEY_ID.getValue());
        String secretKey = System.getenv(AWSSystemSettings.ENV_AWS_SECRET_ACCESS_KEY.getValue());
        String region = System.getenv(AWSSystemSettings.ENV_AWS_REGION.getValue());
        if (accessKeyId != null && secretKey != null) {
            awsCredentials = region == null ? new AWSCredentials(accessKeyId.trim(), secretKey.trim()) : new AWSCredentialsWithRegion(accessKeyId.trim(), secretKey.trim(), region);
            this.logger.info((Object)"AWS Credentials found from Environment Variables.");
            return awsCredentials;
        }
        this.logger.info((Object)"AWS Credentials NOT found in Environment Variables.");
        return null;
    }
}

