/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.store;

import coldfusion.runtime.ApplicationException;
import coldfusion.runtime.Cast;
import coldfusion.server.StoreService;
import coldfusion.tagext.io.FileTag;
import coldfusion.util.CaseInsensitiveMap;
import coldfusion.vfs.VFile;
import coldfusion.vfs.s3.S3FileObject;
import coldfusion.vfs.s3.S3FileSystem;
import coldfusion.vfs.s3.S3FileSystemConfigBuilder;
import coldfusion.vfs.s3.S3FileUploadUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.vfs2.FileContent;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.FileType;
import org.apache.commons.vfs2.FilesCache;
import org.apache.commons.vfs2.cache.NullFilesCache;
import org.apache.commons.vfs2.impl.StandardFileSystemManager;
import org.jets3t.service.ServiceException;
import org.jets3t.service.acl.AccessControlList;
import org.jets3t.service.acl.CanonicalGrantee;
import org.jets3t.service.acl.EmailAddressGrantee;
import org.jets3t.service.acl.GrantAndPermission;
import org.jets3t.service.acl.GranteeInterface;
import org.jets3t.service.acl.GroupGrantee;
import org.jets3t.service.acl.Permission;
import org.jets3t.service.model.StorageOwner;

public class S3StoreService
extends StoreService {
    public static final String ALL_USERS = "all";
    public static final String AUTHENTICATED_USERS = "authenticated";
    public static final String LOG_DELIVERY = "log_delivery";
    private static final String DISPLAY_NAME = "displayName";
    private static final String EMAIL_ID = "email";
    private static final String ID = "id";
    private static final String GROUP = "group";
    private static final String PERMISSION = "permission";
    public static final String PRIVATE = "private";
    public static final String PUBLIC_READ = "public_read";
    public static final String PUBLIC_READ_WRITE = "public_read_write";
    public static final String AUTHENTICATED_READ = "authenticated_read";
    public static final String AUTHENTICATED_READ_WRITE = "authenticated_read_write";
    private static final AccessControlList CANNED_AUTHENTICATED_READ_WRITE = new AccessControlList();
    private static final Map<String, String> metadataKeys = new CaseInsensitiveMap();
    private static final Map<String, String> cfMetadataKeys = new HashMap<String, String>();
    private static final String LAST_MODIFIED = "last_modified";
    private static final String CONTENT_DISPOSITION = "content_disposition";
    private static final String CONTENT_ENCODING = "content_encoding";
    private static final String CONTENT_LANGUAGE = "content_language";
    private static final String CONTENT_LENGTH = "content_length";
    private static final String CONTENT_MD5 = "content_md5";
    private static final String CONTENT_TYPE = "content_type";
    private static final String MD5_HASH = "md5_hash";
    private static final String ETAG = "etag";
    private static final String OWNER = "owner";
    private static final String DATE = "date";
    protected static StandardFileSystemManager s3fsManager;

    public void setAccessControlList(String url, VFile vfile, Object aclObj) {
        S3FileObject fileObject = (S3FileObject)vfile.getFileObject();
        S3FileSystem fileSystem = (S3FileSystem)fileObject.getFileSystem();
        AccessControlList acl = this.buildAccessControlList(aclObj);
        if (acl == null) {
            return;
        }
        try {
            AccessControlList oldACL = fileObject.getACL();
            StorageOwner aclOwner = oldACL != null ? oldACL.getOwner() : fileSystem.getAccountOwner();
            acl.setOwner(aclOwner);
            fileObject.setACL(acl);
        }
        catch (Exception e) {
            throw new StoreService.StoreOperationException((Throwable)e);
        }
    }

    private AccessControlList buildAccessControlList(Object acl) {
        if (acl == null) {
            return null;
        }
        if (acl instanceof String) {
            String aclString = ((String)acl).toLowerCase();
            return this.buildAccessControlList(aclString);
        }
        if (acl instanceof List) {
            return this.buildAccessControlList((List)acl);
        }
        throw new InvalidACLObjectException();
    }

    private AccessControlList buildAccessControlList(String aclString) {
        if (aclString.equals(PRIVATE)) {
            return AccessControlList.REST_CANNED_PRIVATE;
        }
        if (aclString.equals(PUBLIC_READ)) {
            return AccessControlList.REST_CANNED_PUBLIC_READ;
        }
        if (aclString.equals(PUBLIC_READ_WRITE)) {
            return AccessControlList.REST_CANNED_PUBLIC_READ_WRITE;
        }
        if (aclString.equals(AUTHENTICATED_READ)) {
            return AccessControlList.REST_CANNED_AUTHENTICATED_READ;
        }
        if (aclString.equals(AUTHENTICATED_READ_WRITE)) {
            return CANNED_AUTHENTICATED_READ_WRITE;
        }
        throw new InvalidAccessControlException(aclString);
    }

    private AccessControlList buildAccessControlList(List aclList) {
        if (aclList == null || aclList.size() == 0) {
            return null;
        }
        AccessControlList acl = new AccessControlList();
        GrantAndPermission[] grants = this.getACLGrants(aclList);
        acl.grantAllPermissions(grants);
        return acl;
    }

    private GrantAndPermission[] getACLGrants(List aclList) {
        GrantAndPermission[] grants = new GrantAndPermission[aclList.size()];
        for (int i = 0; i < aclList.size(); ++i) {
            GrantAndPermission grantPermission;
            Map aclMap = (Map)aclList.get(i);
            grants[i] = grantPermission = this.getGrantPermission(aclMap);
        }
        return grants;
    }

    private GrantAndPermission getGrantPermission(Map aclMap) {
        String permissions = (String)aclMap.get(PERMISSION);
        GranteeInterface grantee = this.getGrantee(aclMap);
        Permission permission = Permission.parsePermission((String)permissions.toUpperCase());
        if (permission == null) {
            throw new InvalidPermissionException(permissions);
        }
        return new GrantAndPermission(grantee, permission);
    }

    private GranteeInterface getGrantee(Map aclMap) {
        String group = (String)aclMap.get(GROUP);
        if (group != null) {
            if (group.equalsIgnoreCase(ALL_USERS)) {
                return GroupGrantee.ALL_USERS;
            }
            if (group.equalsIgnoreCase(AUTHENTICATED_USERS)) {
                return GroupGrantee.AUTHENTICATED_USERS;
            }
            if (group.equalsIgnoreCase(LOG_DELIVERY)) {
                return GroupGrantee.LOG_DELIVERY;
            }
            throw new InvalidS3GroupException();
        }
        String emailId = (String)aclMap.get(EMAIL_ID);
        if (emailId != null) {
            return new EmailAddressGrantee(emailId);
        }
        String displayName = (String)aclMap.get(DISPLAY_NAME);
        String id = (String)aclMap.get(ID);
        if (id != null) {
            CanonicalGrantee grantee = new CanonicalGrantee(id);
            grantee.setDisplayName(displayName);
            return grantee;
        }
        throw new InvalidS3UserGroupException();
    }

    public Object getAccessControlList(String url, VFile vfile) {
        GrantAndPermission[] grants;
        AccessControlList acl;
        S3FileObject fileObject = (S3FileObject)vfile.getFileObject();
        ArrayList<CaseInsensitiveMap> aclList = new ArrayList<CaseInsensitiveMap>();
        try {
            acl = fileObject.getACL();
        }
        catch (ServiceException e) {
            throw new StoreService.StoreOperationException((Throwable)e);
        }
        if (acl != null && (grants = acl.getGrantAndPermissions()) != null) {
            for (int i = 0; i < grants.length; ++i) {
                CaseInsensitiveMap aclMap = new CaseInsensitiveMap();
                GrantAndPermission grant = grants[i];
                GranteeInterface grantee = grant.getGrantee();
                this.buildAclMap(grantee, (Map)aclMap);
                Permission permission = grant.getPermission();
                String permStr = permission.toString();
                aclMap.put(PERMISSION, permStr);
                aclList.add(aclMap);
            }
        }
        return aclList;
    }

    private void buildAclMap(GranteeInterface grantee, Map aclMap) {
        aclMap.put(ID, grantee.getIdentifier());
        if (grantee instanceof GroupGrantee) {
            if (grantee.equals(GroupGrantee.ALL_USERS)) {
                aclMap.put(GROUP, ALL_USERS);
            }
            if (grantee.equals(GroupGrantee.AUTHENTICATED_USERS)) {
                aclMap.put(GROUP, AUTHENTICATED_USERS);
            }
            if (grantee.equals(GroupGrantee.LOG_DELIVERY)) {
                aclMap.put(GROUP, LOG_DELIVERY);
            }
        } else if (grantee instanceof EmailAddressGrantee) {
            aclMap.put(EMAIL_ID, grantee.getIdentifier());
        } else if (grantee instanceof CanonicalGrantee) {
            aclMap.put(DISPLAY_NAME, ((CanonicalGrantee)grantee).getDisplayName());
        }
    }

    public void addAccessControlList(String url, VFile vfile, Object aclObj) {
        if (!(aclObj instanceof List)) {
            throw new InvalidACLObjectException();
        }
        List aclList = (List)aclObj;
        if (aclList.size() == 0) {
            return;
        }
        S3FileObject fileObject = (S3FileObject)vfile.getFileObject();
        GrantAndPermission[] grants = this.getACLGrants(aclList);
        try {
            AccessControlList acl = fileObject.getACL();
            acl.grantAllPermissions(grants);
            fileObject.setACL(acl);
        }
        catch (Exception e) {
            throw new StoreService.StoreOperationException((Throwable)e);
        }
    }

    public void setMetadata(String url, VFile vfile, Map metadata) {
        S3FileObject fileObject = (S3FileObject)vfile.getFileObject();
        try {
            FileContent content = fileObject.getContent();
            if (metadata != null) {
                for (String key : metadata.keySet()) {
                    Object value = metadata.get(key);
                    String s3KeyName = metadataKeys.get(key);
                    s3KeyName = s3KeyName == null ? key : s3KeyName;
                    content.setAttribute(s3KeyName, value);
                }
                fileObject.updateMetadata();
            }
        }
        catch (Exception e) {
            throw new StoreService.StoreOperationException((Throwable)e);
        }
    }

    public Map getMetadata(String url, VFile vfile) {
        return this.getMetadata(url, vfile, true);
    }

    public Map getMetadata(String url, VFile vfile, boolean checkExists) {
        S3FileObject fileObject = (S3FileObject)vfile.getFileObject();
        CaseInsensitiveMap map = new CaseInsensitiveMap();
        try {
            if (!checkExists || fileObject.exists()) {
                FileContent content = fileObject.getContent();
                Map attributes = content.getAttributes();
                for (String keyName : attributes.keySet()) {
                    String cfkeyName = cfMetadataKeys.get(keyName);
                    cfkeyName = cfkeyName == null ? keyName : cfkeyName;
                    map.put(cfkeyName, attributes.get(keyName));
                }
                StorageOwner owner = fileObject.getOwner();
                if (owner != null) {
                    map.put(OWNER, owner.getDisplayName());
                }
                if (fileObject.getType() == FileType.FOLDER) {
                    map.put("location", fileObject.getBucketLocation());
                }
            }
        }
        catch (FileSystemException e) {
            throw new StoreService.StoreOperationException((Throwable)e);
        }
        return map;
    }

    public void createBucket(VFile file, String location, Object acl) {
        S3FileObject fileObject = (S3FileObject)file.getFileObject();
        S3FileSystem fileSystem = (S3FileSystem)fileObject.getFileSystem();
        try {
            AccessControlList s3Acl = this.buildAccessControlList(acl);
            if (s3Acl != null) {
                s3Acl.setOwner(fileSystem.getAccountOwner());
            }
            fileSystem.createBucket(location, s3Acl);
        }
        catch (Exception e) {
            throw new StoreService.StoreOperationException((Throwable)e);
        }
    }

    public boolean isInstanceOfS3FileObject(Object obj) {
        return obj != null && obj instanceof S3FileObject;
    }

    public void copyFile(File dataFile, VFile dest) throws IOException {
        S3FileUploadUtil.copyFile(dataFile, dest);
    }

    public String[] doListChildren(Object s3Object) throws Exception {
        return ((S3FileObject)((Object)s3Object)).doListChildren();
    }

    public void setFileSystemOptions(FileSystemOptions fso, String accessKeyId, String secretAccessKey, String defaultLocation, boolean enableDefaultCredentialProviderChain) {
        S3FileSystemConfigBuilder configBuilder = S3FileSystemConfigBuilder.getInstance();
        configBuilder.setAccessKeyID(fso, accessKeyId);
        configBuilder.setSecretAccessKey(fso, secretAccessKey);
        configBuilder.setDefaultLocation(fso, defaultLocation);
        configBuilder.setCredentialProviderChain(fso, enableDefaultCredentialProviderChain);
    }

    public void setUploaderMaxSize(Object multipartFileSize) {
        S3FileUploadUtil.SIMPLE_UPLOADER_MAX_FILE_SIZE = Cast._int((Object)multipartFileSize, (boolean)false);
    }

    public boolean isSchemeSupported(String scheme) {
        return this.getFileSystemManager(scheme).hasProvider(scheme);
    }

    public StandardFileSystemManager getFileSystemManager(String scheme) {
        if (s3fsManager != null) {
            return s3fsManager;
        }
        s3fsManager = new StandardFileSystemManager();
        try {
            s3fsManager.setConfiguration(((Object)((Object)this)).getClass().getClassLoader().getResource("META-INF/vfs-providers.xml"));
            s3fsManager.setFilesCache((FilesCache)new NullFilesCache());
            s3fsManager.init();
        }
        catch (FileSystemException e) {
            throw new FileTag.SingleFileOperationException("create", (Throwable)e, "");
        }
        return s3fsManager;
    }

    static {
        metadataKeys.put(LAST_MODIFIED, "Last-Modified");
        metadataKeys.put(DATE, "Date");
        metadataKeys.put(CONTENT_DISPOSITION, "Content-Disposition");
        metadataKeys.put(CONTENT_ENCODING, "Content-Encoding");
        metadataKeys.put(CONTENT_LANGUAGE, "Content-Language");
        metadataKeys.put(CONTENT_LENGTH, "Content-Length");
        metadataKeys.put(CONTENT_MD5, "Content-MD5");
        metadataKeys.put(CONTENT_TYPE, "Content-Type");
        metadataKeys.put(ETAG, "ETag");
        metadataKeys.put(MD5_HASH, "md5-hash");
        cfMetadataKeys.put("Last-Modified", LAST_MODIFIED);
        cfMetadataKeys.put("Content-Disposition", CONTENT_DISPOSITION);
        cfMetadataKeys.put("Content-Encoding", CONTENT_ENCODING);
        cfMetadataKeys.put("Content-Language", CONTENT_LANGUAGE);
        cfMetadataKeys.put("Content-Length", CONTENT_LENGTH);
        cfMetadataKeys.put("Content-MD5", CONTENT_MD5);
        cfMetadataKeys.put("Content-Type", CONTENT_TYPE);
        cfMetadataKeys.put("md5-hash", MD5_HASH);
        CANNED_AUTHENTICATED_READ_WRITE.grantPermission((GranteeInterface)GroupGrantee.AUTHENTICATED_USERS, Permission.PERMISSION_READ);
        CANNED_AUTHENTICATED_READ_WRITE.grantPermission((GranteeInterface)GroupGrantee.AUTHENTICATED_USERS, Permission.PERMISSION_WRITE);
    }

    public static class InvalidACLObjectException
    extends ApplicationException {
    }

    public static class InvalidS3GroupException
    extends ApplicationException {
    }

    public static class InvalidS3UserGroupException
    extends ApplicationException {
    }

    public static class InvalidAccessControlException
    extends ApplicationException {
        public String aclString;

        public InvalidAccessControlException(String aclString) {
            this.aclString = aclString;
        }
    }

    public static class InvalidPermissionException
    extends ApplicationException {
        public String perms;

        public InvalidPermissionException(String permissions) {
            this.perms = permissions;
        }
    }
}

