/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.eventgateway.flex;

import coldfusion.eventgateway.CFEvent;
import coldfusion.eventgateway.Gateway;
import coldfusion.eventgateway.GenericGateway;
import coldfusion.eventgateway.Logger;
import coldfusion.eventgateway.flex.CFEventGatewayAdapter;
import coldfusion.eventgateway.flex.FlexGatewayExceptions;
import coldfusion.eventgateway.flex.rmi.CFToFlexProxy;
import coldfusion.eventgateway.flex.rmi.FlexToCFProxyServer;
import coldfusion.flash.messaging.io.RemotingContext;
import coldfusion.flash.messaging.io.amf.Translator.CFASDeserializer;
import coldfusion.flash.messaging.io.amf.Translator.CFASSerializer;
import coldfusion.flex.rmi.DataServicesRMIRegistry;
import coldfusion.runtime.ApplicationException;
import coldfusion.runtime.Cast;
import coldfusion.runtime.Struct;
import coldfusion.server.ServiceException;
import coldfusion.util.IPAddressUtils;
import coldfusion.util.UUIDUtils;
import flex.messaging.Destination;
import flex.messaging.MessageBroker;
import flex.messaging.messages.AsyncMessage;
import flex.messaging.services.Service;
import flex.messaging.services.ServiceAdapter;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.rmi.Naming;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.rmi.ServerException;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;

public class FlexMessagingGateway
extends GenericGateway
implements Gateway {
    private static final String LOG = "flexmessaginggateway";
    private String config;
    private String host = "localhost";
    private String destination;
    private Logger log;
    private Properties configProperties;
    private String[] allowedIPs = null;
    private int rmiport = DataServicesRMIRegistry.getDefaultPort();
    private String myLocation;
    private boolean localFlex = true;

    public FlexMessagingGateway(String gatewayID, String conf) throws ServiceException {
        super(gatewayID);
        this.config = conf;
        this.log = this.getGatewayServices().getLogger(LOG);
        this.readConfig();
    }

    protected void startGateway() throws Exception {
        this.status = 1;
        this.readConfig();
        if (!this.localFlex) {
            DataServicesRMIRegistry.startRegistry();
            this.registerServer();
        }
        this.status = 2;
    }

    private void registerServer() throws Exception {
        try {
            FlexToCFProxyServer proxy = new FlexToCFProxyServer(this);
            this.myLocation = "//localhost:" + this.rmiport + "/" + "cfeventgateway/" + this.getGatewayID();
            Naming.rebind(this.myLocation, proxy);
        }
        catch (Exception e) {
            this.log.error("Gateway " + this.getGatewayID() + ": Problem registering RMI proxy: " + e.toString(), (Throwable)e);
            this.status = 5;
            throw e;
        }
    }

    protected void stopGateway() throws Exception {
        if (!this.localFlex) {
            try {
                Naming.unbind(this.myLocation);
            }
            catch (Exception e) {
                this.log.debug("Gateway " + this.getGatewayID() + ": Problem unbinding: " + e.toString(), (Throwable)e);
            }
        }
        this.status = 4;
    }

    public String outgoingMessage(CFEvent cfmsg) {
        Object o;
        String ret = "TRUE";
        this.log.debug("+++++++++++++++Entering outgoingMessage+++++++++++++++++=");
        String dest = this.destination;
        if (dest == null && (o = cfmsg.getData().get("destination")) instanceof String) {
            dest = (String)o;
        }
        if (dest == null) {
            throw new UnknownDestinationException();
        }
        this.log.debug("+++++++++++++++Using destination: " + dest + "+++++++++++++++");
        if (this.localFlex) {
            MessageBroker mb = MessageBroker.getMessageBroker(null);
            if (mb == null) {
                throw new FlexGatewayExceptions.CantFindFlexException();
            }
            Service service = mb.getService("message-service");
            if (service == null) {
                throw new FlexGatewayExceptions.CantFindFlexService("message-service");
            }
            Destination d = service.getDestination(dest);
            if (d == null) {
                throw new FlexGatewayExceptions.CantFindFlexDestination("Message Service", dest);
            }
            ServiceAdapter a = d.getAdapter();
            if (a == null || !(a instanceof CFEventGatewayAdapter)) {
                throw new FlexGatewayExceptions.NotCFDestination("Event Gateway", dest);
            }
            CFEventGatewayAdapter adapter = (CFEventGatewayAdapter)a;
            AsyncMessage msg = this.convertToFlexMessage(cfmsg, dest);
            adapter.send(msg);
        } else {
            CFToFlexProxy proxy = this.findFlexProxy(dest);
            this.log.debug("+++++++++++++++Found RMI proxy+++++++++++++++");
            try {
                AsyncMessage msg = this.convertToFlexMessage(cfmsg, dest);
                this.log.debug("+++++++++++++++Converted ColdFusion Message to Flex AsyncMessage:\n" + msg.toString());
                this.log.debug("+++++++++++++++Calling sendToFlexAdapter()+++++++++++++++");
                boolean ok = proxy.sendToFlexAdapter(msg);
                this.log.debug("+++++++++++++++Returned from sendToFlexAdapter(), result is " + ok + "+++++++++++++++");
                if (!ok) {
                    ret = "FALSE: Flex Server returned failure, see Flex server log messages for details.";
                }
            }
            catch (ServerException se) {
                this.log.debug("+++++++++++++++Caught Server Exception while sending message: " + se.toString() + "+++++++++++++++");
                if (se.detail != null) {
                    ret = "FALSE: Error on server: " + se.detail.toString();
                }
            }
            catch (Exception e) {
                this.log.debug("+++++++++++++++Caught exception while converting or sending message: " + e.toString() + "+++++++++++++++");
                ret = "FALSE: " + e.toString();
            }
        }
        return ret;
    }

    public boolean incomingMessage(AsyncMessage msg) {
        this.log.debug("+++++++++++++++incomingMessage: " + msg.toString() + "+++++++++++++++");
        CFEvent cfevent = this.convertToCFEvent(msg);
        this.log.debug("+++++++++++++++Message converted:\n" + msg.toString());
        boolean ret = super.sendMessage(cfevent);
        this.log.debug("+++++++++++++++Sent message, result: " + ret + "+++++++++++++++");
        return ret;
    }

    private void readConfig() throws ServiceException {
        if (this.config == null || this.config.trim().length() == 0) {
            return;
        }
        try {
            this.configProperties = new Properties();
            FileInputStream propsFile = new FileInputStream(this.config);
            this.configProperties.load(propsFile);
            propsFile.close();
        }
        catch (IOException e) {
            throw new ServiceException("Unable to read configuration file: " + e.toString());
        }
        this.destination = this.configProperties.getProperty("destination");
        this.host = this.configProperties.getProperty("host");
        if (this.host != null) {
            this.host = this.host.trim();
            this.localFlex = false;
        }
        String iplist = this.configProperties.getProperty("allowedIPs");
        this.allowedIPs = null;
        if (iplist != null) {
            StringTokenizer tok = new StringTokenizer(iplist, ",");
            String[] ipArray = new String[tok.countTokens()];
            int i = 0;
            while (tok.hasMoreTokens()) {
                ipArray[i++] = tok.nextToken().trim();
            }
            if (ipArray.length > 0) {
                this.allowedIPs = ipArray;
            }
        }
    }

    private synchronized CFToFlexProxy findFlexProxy(String destination) throws UnableToFindProxyException, UnableToContactRMIRegistryException {
        String name = "//" + this.host + ":" + this.rmiport + "/" + "cfeventadapter/" + destination;
        try {
            return (CFToFlexProxy)Naming.lookup(name);
        }
        catch (NotBoundException nbe) {
            throw new UnableToFindProxyException(destination, this.host, this.rmiport);
        }
        catch (RemoteException remex) {
            if (this.host != null && !IPAddressUtils.isLocalHost((String)this.host)) {
                throw new UnableToContactRMIRegistryException(destination, this.host, this.rmiport, remex);
            }
            try {
                DataServicesRMIRegistry.forceStartRegistry();
                this.registerServer();
                return (CFToFlexProxy)Naming.lookup(name);
            }
            catch (Exception e) {
                throw new UnableToFindProxyException(destination, this.host, this.rmiport);
            }
        }
        catch (Exception e) {
            throw new UnableToFindProxyException(destination, this.host, this.rmiport);
        }
    }

    private AsyncMessage convertToFlexMessage(CFEvent cfmsg, String dest) {
        AsyncMessage out = new AsyncMessage();
        Map data = cfmsg.getData();
        out.setMessageId(UUIDUtils.createUUID((boolean)false));
        out.setTimestamp(System.currentTimeMillis());
        out.setClientId((Object)cfmsg.getGatewayID());
        out.setDestination(dest);
        Object o = data.get("correlationid");
        if (o instanceof String) {
            out.setCorrelationId((String)o);
        }
        if ((o = data.get("timetolive")) != null) {
            out.setTimeToLive(Cast._long(o));
        }
        CFASSerializer serializer = null;
        RemotingContext rContext = RemotingContext.getCurrent();
        if (rContext == null) {
            rContext = new RemotingContext();
            RemotingContext.setCurrent((RemotingContext)rContext);
        }
        if (!rContext.isCallthroughCFSpecificEndPoint()) {
            serializer = new CFASSerializer();
        }
        if (this.configProperties != null) {
            rContext.setProperties((Map)this.configProperties);
        }
        rContext.setProperties(data);
        Object body = data.get("body");
        if (body == null) {
            throw new MissingBodyException();
        }
        if (rContext.isCallthroughCFSpecificEndPoint()) {
            out.setBody(body);
        } else {
            out.setBody(serializer.translate(body));
        }
        Object h = data.get("headers");
        if (h instanceof Map) {
            Map headers = null;
            headers = rContext.isCallthroughCFSpecificEndPoint() ? (Map)h : (Map)serializer.translate(h);
            out.setHeaders(headers);
        }
        return out;
    }

    private CFEvent convertToCFEvent(AsyncMessage msg) {
        CFEvent event = new CFEvent(this.getGatewayID());
        event.setGatewayType("DataServicesMessaging");
        RemotingContext rContext = RemotingContext.getCurrent();
        if (rContext == null) {
            rContext = new RemotingContext();
            RemotingContext.setCurrent((RemotingContext)rContext);
        }
        Object body = msg.getBody();
        CFASDeserializer deserializer = null;
        if (this.configProperties != null) {
            rContext.setProperties((Map)this.configProperties);
        }
        Object translatedBody = null;
        deserializer = new CFASDeserializer();
        if (!rContext.isCallthroughCFSpecificEndPoint()) {
            translatedBody = deserializer.translate(body);
        }
        Hashtable<String, Object> mydata = new Hashtable<String, Object>();
        mydata.put("messageid", msg.getMessageId());
        mydata.put("destination", msg.getDestination());
        if (rContext.isCallthroughCFSpecificEndPoint()) {
            mydata.put("body", body);
        } else {
            mydata.put("body", translatedBody);
        }
        mydata.put("correlationid", msg.getCorrelationId());
        mydata.put("timestamp", new Date(msg.getTimestamp()));
        mydata.put("timetolive", Long.toString(msg.getTimeToLive()));
        String clientID = msg.getClientId().toString();
        mydata.put("clientid", clientID);
        event.setOriginatorID(clientID);
        Map headers = msg.getHeaders();
        if (headers != null) {
            Iterator itr = headers.keySet().iterator();
            Struct struct = new Struct();
            while (itr.hasNext()) {
                Object key = itr.next();
                struct.put(key, deserializer.translate(headers.get(key)));
            }
            mydata.put("headers", struct);
        }
        event.setData(mydata);
        return event;
    }

    public boolean verifyHost(String host) {
        try {
            InetAddress addr = InetAddress.getByName(host);
            String remote = addr.getHostAddress();
            if (this.allowedIPs != null && this.allowedIPs.length > 0) {
                for (int i = 0; i < this.allowedIPs.length; ++i) {
                    InetAddress localhost;
                    if (this.allowedIPs[i].equals(remote)) {
                        return true;
                    }
                    if (!IPAddressUtils.isLocalHost((String)this.allowedIPs[i]) || !(localhost = InetAddress.getLocalHost()).getHostAddress().equals(remote)) continue;
                    return true;
                }
            } else {
                InetAddress localhost = InetAddress.getLocalHost();
                if (localhost.getHostAddress().equals(remote)) {
                    return true;
                }
            }
            return false;
        }
        catch (UnknownHostException e) {
            return false;
        }
    }

    public class MissingBodyException
    extends ApplicationException {
    }

    public class UnknownDestinationException
    extends ApplicationException {
    }

    public class UnableToContactRMIRegistryException
    extends ApplicationException {
        public String msg;
        public String destination;
        public String host;

        public UnableToContactRMIRegistryException(String destination, String host, int port, Throwable throwable) {
            this.msg = throwable.toString();
            this.destination = destination;
            this.host = host + ":" + port;
        }
    }

    public class UnableToFindProxyException
    extends ApplicationException {
        public String destination;
        public String host;

        public UnableToFindProxyException(String destination, String host, int port) {
            this.destination = destination;
            this.host = (host != null ? host : "localhost") + ":" + port;
        }
    }
}

