/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.graphql.graphqlClient;

import coldfusion.graphql.graphqlClient.CFGraphQLClientException;
import coldfusion.graphql.graphqlClient.CFGraphQLUtils;
import coldfusion.graphql.graphqlClient.GraphQLClientProducer;
import coldfusion.graphql.graphqlClient.GraphQLSubscriptionCallImpl;
import coldfusion.graphql.graphqlClient.PMTGraphQlApis;
import coldfusion.log.CFLogs;
import coldfusion.monitor.Configuration;
import coldfusion.monitor.beans.TagAttributeList;
import coldfusion.monitor.datastore.Client;
import coldfusion.monitor.datastore.JSONConverter;
import coldfusion.monitor.event.RequestMonitorEventProcessor;
import coldfusion.monitor.util.RequestMonitorData;
import coldfusion.runtime.Struct;
import coldfusion.util.DateUtils;
import coldfusion.util.RB;
import com.apollographql.apollo.api.Response;
import com.apollographql.apollo.exception.ApolloException;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class PMTUtilsForGraphQlClient {
    static Calendar calendar = DateUtils.getDefaultCalendar();

    public static TagAttributeList startGraphQlMonitoring(PMTGraphQlApis name, TagAttributeList tagAttributeList, String serviceName, String clientAlias, String serviceUrl) {
        RequestMonitorData rmd = RequestMonitorData.getCurrent();
        if (rmd != null && rmd.doMonitor()) {
            long requestStartTime = calendar.getTimeInMillis();
            RequestMonitorEventProcessor.onFunctionStart((String)name.name(), null, (boolean)true);
            TagAttributeList tempAttributeList = TagAttributeList.getInstance((TagAttributeList)tagAttributeList);
            tempAttributeList.addTagAttribute("start_time", (Object)requestStartTime);
            tempAttributeList.addTagAttribute("service_name", (Object)serviceName);
            tempAttributeList.addTagAttribute("client", (Object)clientAlias);
            tempAttributeList.addTagAttribute("service_url", (Object)serviceUrl);
            return tempAttributeList;
        }
        return null;
    }

    public static void endGraphQlmonitoring(PMTGraphQlApis api, TagAttributeList tempAttributeList, String opName, Object param, Map response) {
        if (tempAttributeList == null) {
            return;
        }
        PMTUtilsForGraphQlClient.updateTagAttributeList(tempAttributeList, opName, response);
        long requestEndTime = calendar.getTimeInMillis();
        tempAttributeList.addTagAttribute("end_time", (Object)requestEndTime);
        RequestMonitorEventProcessor.onFunctionEnd((String)api.name(), null, (List)TagAttributeList.getInstance((TagAttributeList)tempAttributeList).getTagAttributes(), (boolean)true);
    }

    public static void endGraphQlmonitoring(PMTGraphQlApis api, TagAttributeList tempAttributeList, String opName, Object param, String queryDoc, String operationId) {
        if (tempAttributeList == null) {
            return;
        }
        if (!CFGraphQLUtils.isNullOrEmpty(queryDoc)) {
            tempAttributeList.addTagAttribute("query_document", (Object)queryDoc);
            PMTUtilsForGraphQlClient.extractOperationNameAndType(queryDoc, tempAttributeList);
        }
        if (!CFGraphQLUtils.isNullOrEmpty(operationId)) {
            tempAttributeList.addTagAttribute("operation_id", (Object)operationId);
        }
        PMTUtilsForGraphQlClient.endGraphQlmonitoring(api, tempAttributeList, opName, param, null);
    }

    private static void updateTagAttributeList(TagAttributeList tempAttributeList, String opName, Map response) {
        if (opName != null) {
            tempAttributeList.addTagAttribute("operation_name", (Object)opName);
        }
        if (response != null) {
            tempAttributeList.addTagAttribute("request_size", (Object)Integer.toString((Integer)(response.get("RequestSize (Bytes)") != null ? response.get("RequestSize (Bytes)") : Integer.valueOf(0))));
            tempAttributeList.addTagAttribute("response_size", (Object)Integer.toString((Integer)(response.get("ResponseSize (Bytes)") != null ? response.get("ResponseSize (Bytes)") : Integer.valueOf(0))));
            tempAttributeList.addTagAttribute("is_error", response.get("hasErrors"));
            tempAttributeList.addTagAttribute("operation_id", response.get("OperationId"));
            tempAttributeList.addTagAttribute("exception", response.get("Error"));
            tempAttributeList.addTagAttribute("query_document", response.get("QueryDocument"));
            String statusCode = Integer.toString(response.get("Response_code") == null ? Integer.valueOf(-1) : response.get("Response_code"));
            tempAttributeList.addTagAttribute("status_code", (Object)statusCode);
            tempAttributeList.addTagAttribute("variables", (Object)response.get("variables").toString());
        }
    }

    public static <T extends CFGraphQLClientException> TagAttributeList catchErrorMetrics(T e, TagAttributeList tagAttributeList) {
        if (tagAttributeList != null) {
            CFLogs.MONITOR_LOG.error((Object)("Error in graphql " + e.getMessage()));
            if (e == null || tagAttributeList == null || !Configuration.INSTANCE.getMonitorSettings().getAdvancedMonitoring().isGraphqlMetricsEnabled()) {
                return tagAttributeList;
            }
            String[] errorType = e.getClass().getName().split("\\.");
            tagAttributeList.addTagAttribute("is_error", (Object)true);
            return tagAttributeList.addTagAttribute("statustext", (Object)e.getMessage()).addTagAttribute("ERRORTYPE", (Object)errorType[errorType.length - 1]).addTagAttribute("status_code", (Object)"Failure");
        }
        return null;
    }

    public static void persistClientMonitoringMetrics(Map<String, Object> inputConfig, String graphQLClientId) {
        Configuration configuration = Configuration.INSTANCE;
        inputConfig.put("instance_id", configuration.getInstanceId());
        inputConfig.put("group_id", configuration.getGroupId());
        inputConfig.put("cluster_id", configuration.getClusterId());
        Client.get().indexDocument(JSONConverter.toJson(inputConfig), "graphql_clients", graphQLClientId);
    }

    public static void persistServerMonitoringMetrics(Struct inputConfig) {
        Configuration configuration = Configuration.INSTANCE;
        Struct server = new Struct();
        server.put((Object)"name", inputConfig.get((Object)"service_name"));
        server.put((Object)"service_url", inputConfig.get((Object)"service_url"));
        server.put((Object)"instance_id", (Object)configuration.getInstanceId());
        server.put((Object)"group_id", (Object)configuration.getGroupId());
        server.put((Object)"cluster_id", (Object)configuration.getClusterId());
        String docId = Integer.toString(Objects.hash(server));
        Client.get().indexDocument(JSONConverter.toJson((Object)server), "graphql_service", docId);
    }

    public static String extractOperationNameAndType(String gqlQuery, TagAttributeList tagAttributeList) {
        if (tagAttributeList == null) {
            return "";
        }
        String temp = gqlQuery.trim().toLowerCase();
        String operationType = null;
        if (temp.startsWith("query")) {
            operationType = String.valueOf((Object)PMTGraphQlApis.GraphQL_query);
            temp = temp.replaceFirst("query", "");
        }
        if (temp.startsWith("mutation")) {
            operationType = String.valueOf((Object)PMTGraphQlApis.GraphQL_mutation);
            temp = temp.replaceFirst("mutation", "");
        }
        if (temp.startsWith("subscription")) {
            operationType = String.valueOf((Object)PMTGraphQlApis.GraphQL_subscription);
            temp = temp.replaceFirst("subscription", "");
        }
        tagAttributeList.addTagAttribute("operation_type", (Object)operationType);
        int index = gqlQuery.indexOf(40) != -1 ? gqlQuery.indexOf(40) : (gqlQuery.indexOf(123) != -1 ? gqlQuery.indexOf(123) : 0);
        String operationName = gqlQuery.substring(0, index).trim().substring(operationType.length() - "GraphQL".length());
        return operationName;
    }

    public static void subscriptionCallbacksMonitoring(Object[] args, RequestMonitorData rmd, long startTime, PMTGraphQlApis name) {
        try {
            if (rmd != null && rmd.doMonitor() && Configuration.INSTANCE.getMonitorSettings().getAdvancedMonitoring().isGraphqlMetricsEnabled()) {
                GraphQLSubscriptionCallImpl graphQLSubscriptionCall = (GraphQLSubscriptionCallImpl)args[1];
                Struct data = new Struct();
                data.put((Object)"request_id", (Object)rmd.getRequestId());
                data.put((Object)"template_path", (Object)rmd.getTemplatePath());
                data.put((Object)"service_url", (Object)graphQLSubscriptionCall.getCfGraphQLConfig().getGraphQLServiceURL());
                data.put((Object)"config_alias", (Object)graphQLSubscriptionCall.getCfGraphQLConfig().getClientName());
                data.put((Object)"service", (Object)graphQLSubscriptionCall.getCfGraphQLConfig().getServiceName());
                data.put((Object)"websocket_url", (Object)graphQLSubscriptionCall.getCfGraphQLConfig().getCfGraphQLSubscriptionConfig().getWebsocketUrl());
                data.put((Object)"operation_name", (Object)graphQLSubscriptionCall.getOperationName());
                switch (name) {
                    case GraphQL_Subscription_onResponse: {
                        Response response = (Response)args[0];
                        data.put((Object)"operation_id", (Object)response.getOperation().operationId());
                        data.put((Object)"is_error", (Object)response.hasErrors());
                        data.put((Object)"response_size", (Object)response.getData().toString().getBytes().length);
                        data.put((Object)"query_document", (Object)response.getOperation().queryDocument());
                        data.put((Object)"start_time", (Object)startTime);
                        break;
                    }
                    case GraphQL_Subscription_onFailure: {
                        ApolloException apolloException = (ApolloException)args[0];
                        data.put((Object)"is_error", (Object)true);
                        data.put((Object)"error_message", (Object)apolloException.getMessage());
                        data.put((Object)"error_name", (Object)apolloException.getClass().getName());
                        break;
                    }
                    case GraphQL_Subscription_onCompleted: {
                        break;
                    }
                    case GraphQL_Subscription_onConnected: {
                        break;
                    }
                }
                Client.get().indexDocument(JSONConverter.toJson((Object)data), "graphql_subscriptions", 1);
            }
        }
        catch (Exception ex) {
            CFLogs.MONITOR_LOG.error((Object)RB.getString(GraphQLClientProducer.class, (String)"MONITORING_DATA_PERSISTENCE_ERROR_SUBSCRIPTION"), (Throwable)ex);
        }
    }
}

