/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.graphql.graphqlClient;

import coldfusion.filter.FusionContext;
import coldfusion.graphql.graphqlClient.CFGraphQLClient;
import coldfusion.graphql.graphqlClient.CFGraphQLClientException;
import coldfusion.graphql.graphqlClient.CFGraphQLUtils;
import coldfusion.graphql.graphqlClient.GraphQLCall;
import coldfusion.graphql.graphqlClient.PMTGraphQlApis;
import coldfusion.graphql.graphqlClient.PMTUtilsForGraphQlClient;
import coldfusion.graphql.graphqlClient.config.CFGraphQLConfig;
import coldfusion.graphql.graphqlClient.metadata.CFGraphQLCallHandler;
import coldfusion.monitor.beans.TagAttributeList;
import coldfusion.monitor.util.RequestMonitorData;
import coldfusion.runtime.Closure;
import coldfusion.runtime.Struct;
import coldfusion.util.DateUtils;
import coldfusion.util.RB;
import com.apollographql.apollo.ApolloCall;
import com.apollographql.apollo.ApolloMutationCall;
import com.apollographql.apollo.ApolloQueryCall;
import com.apollographql.apollo.api.Operation;
import com.apollographql.apollo.api.Response;
import com.apollographql.apollo.rx3.Rx3Apollo;
import io.reactivex.rxjava3.core.Observable;
import java.io.IOException;
import java.util.Arrays;
import java.util.Calendar;
import java.util.List;
import java.util.Map;

public class GraphQLCallImpl<T>
implements GraphQLCall<T> {
    private ApolloCall apolloCall;
    private String callName;
    private CFGraphQLConfig cfGraphQLConfig;

    public GraphQLCallImpl(ApolloCall apolloCall, CFGraphQLConfig graphQLConfig) {
        this.apolloCall = apolloCall;
        this.callName = apolloCall.operation().name().name();
        this.cfGraphQLConfig = graphQLConfig;
    }

    @Override
    public void cancel() {
        this.apolloCall.cancel();
    }

    @Override
    public boolean isCanceled() {
        return this.apolloCall.isCanceled();
    }

    @Override
    public GraphQLCallImpl clone() {
        return new GraphQLCallImpl<T>(this.apolloCall.clone(), this.cfGraphQLConfig);
    }

    public Operation operation() {
        return this.apolloCall.operation();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void enqueue(Closure onResponse, Closure onFailure) {
        GraphQLCallImpl responseObject = null;
        TagAttributeList tempAttributeList = null;
        try {
            tempAttributeList = PMTUtilsForGraphQlClient.startGraphQlMonitoring(PMTGraphQlApis.GraphQL_enqueue, CFGraphQLClient.tagAttributeList, this.cfGraphQLConfig.getServiceName(), this.cfGraphQLConfig.getClientName(), this.cfGraphQLConfig.getGraphQLServiceURL());
            CFGraphQLCallHandler cfGraphQLQueryCallHandler = new CFGraphQLCallHandler(onResponse, onFailure, FusionContext.getCurrent(), this, FusionContext.getCurrent().pageContext, RequestMonitorData.getCurrent());
            responseObject = (GraphQLCallImpl)cfGraphQLQueryCallHandler.getGraphQLCall();
            this.apolloCall.enqueue(cfGraphQLQueryCallHandler.getCallback());
        }
        catch (Exception e) {
            PMTUtilsForGraphQlClient.catchErrorMetrics(new CFGraphQLClientException(e.getMessage()), tempAttributeList);
        }
        finally {
            if (responseObject != null) {
                PMTUtilsForGraphQlClient.endGraphQlmonitoring(PMTGraphQlApis.GraphQL_enqueue, tempAttributeList, String.valueOf(responseObject.operation().name()), responseObject.operation().variables(), responseObject.operation().queryDocument(), responseObject.operation().operationId());
            }
        }
    }

    public Struct variables() {
        Struct variablesMap = new Struct();
        variablesMap.putAll(this.apolloCall.operation().variables().valueMap());
        return variablesMap;
    }

    public List fields() {
        return Arrays.asList(this.apolloCall.operation().variables().valueMap().keySet().toArray());
    }

    public String marshalVariablesJson() {
        try {
            return this.apolloCall.operation().variables().marshal();
        }
        catch (IOException ioException) {
            throw new CFGraphQLClientException(RB.getString(GraphQLCallImpl.class, (String)"Exception in Marshalling Variables : "), ioException);
        }
    }

    @Override
    public String rawOperation() {
        return this.apolloCall.operation().queryDocument();
    }

    @Override
    public String opName() {
        return this.callName;
    }

    @Override
    public ApolloCall.Builder<T> toBuilder() {
        return this.apolloCall.toBuilder();
    }

    @Override
    public ApolloQueryCall.Builder<T> canBeBatched(boolean toBatch) {
        if (this.apolloCall instanceof ApolloQueryCall) {
            return ((ApolloQueryCall)this.apolloCall).toBuilder().canBeBatched(toBatch);
        }
        if (this.apolloCall instanceof ApolloMutationCall) {
            throw new CFGraphQLClientException(RB.getString(GraphQLCallImpl.class, (String)"Batching not supported in Mutation Operations"));
        }
        throw new CFGraphQLClientException(RB.getString(GraphQLCallImpl.class, (String)("Batching not supported for :" + this.apolloCall.operation())));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map execute() {
        Map customResponse = null;
        TagAttributeList tempAttributeList = null;
        try {
            tempAttributeList = PMTUtilsForGraphQlClient.startGraphQlMonitoring(PMTGraphQlApis.GraphQL_execute, CFGraphQLClient.tagAttributeList, this.cfGraphQLConfig.getServiceName(), this.cfGraphQLConfig.getClientName(), this.cfGraphQLConfig.getGraphQLServiceURL());
            Calendar calendar = DateUtils.getDefaultCalendar();
            long requestTime = calendar.getTimeInMillis();
            Observable observable = Rx3Apollo.from((ApolloCall)this.apolloCall);
            Response response = (Response)observable.blockingFirst();
            long responseTime = calendar.getTimeInMillis();
            customResponse = CFGraphQLUtils.populateResponseStruct(response, requestTime, responseTime);
        }
        catch (Exception e) {
            try {
                PMTUtilsForGraphQlClient.catchErrorMetrics(new CFGraphQLClientException(e.getMessage()), tempAttributeList);
            }
            catch (Throwable throwable) {
                String opName = PMTUtilsForGraphQlClient.extractOperationNameAndType((String)customResponse.get("QueryDocument"), tempAttributeList);
                PMTUtilsForGraphQlClient.endGraphQlmonitoring(PMTGraphQlApis.GraphQL_execute, tempAttributeList, opName, null, customResponse);
                throw throwable;
            }
            String opName = PMTUtilsForGraphQlClient.extractOperationNameAndType((String)customResponse.get("QueryDocument"), tempAttributeList);
            PMTUtilsForGraphQlClient.endGraphQlmonitoring(PMTGraphQlApis.GraphQL_execute, tempAttributeList, opName, null, customResponse);
        }
        String opName = PMTUtilsForGraphQlClient.extractOperationNameAndType((String)customResponse.get("QueryDocument"), tempAttributeList);
        PMTUtilsForGraphQlClient.endGraphQlmonitoring(PMTGraphQlApis.GraphQL_execute, tempAttributeList, opName, null, customResponse);
        return customResponse;
    }

    public CFGraphQLConfig getCfGraphQLConfig() {
        return this.cfGraphQLConfig;
    }
}

