/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.orm.mapping;

import coldfusion.orm.mapping.CFCPersistenceMetadata;
import coldfusion.orm.mapping.CFPropertyBinder;
import coldfusion.orm.mapping.ManyToOneField;
import coldfusion.orm.mapping.PropertyField;
import coldfusion.orm.mapping.RelationField;
import coldfusion.sql.DBMetaData;
import coldfusion.sql.ForeignKeyMetaData;
import coldfusion.sql.TableMetaData;
import coldfusion.util.RB;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class OneToManyField
extends RelationField {
    private String collectionType = "array";
    private String orderBy;
    private String structKeyColumn;
    private String structKeyDataType = "string";
    private boolean readOnly;
    private int batchSize = 1;
    private boolean optimisticLock = true;
    private String cacheStrategy;
    private String cacheName;
    private String whereString;
    private String onDelete;

    public String getCollectionType() {
        return this.collectionType;
    }

    public void setCollectionType(String collectionType) {
        this.collectionType = collectionType.toLowerCase();
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    public String getOrderBy() {
        return this.orderBy;
    }

    public void setOrderBy(String orderBy) {
        this.orderBy = orderBy;
    }

    public String getStructKeyColumn() {
        return this.structKeyColumn;
    }

    public void setStructKeyColumn(String structKeyColumn) {
        this.structKeyColumn = structKeyColumn;
    }

    public String getStructKeyDataType() {
        return this.structKeyDataType;
    }

    public void setStructKeyDataType(String structKeyDataType) {
        this.structKeyDataType = structKeyDataType;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }

    public void setOptimisticLock(boolean optimisticLock) {
        this.optimisticLock = optimisticLock;
    }

    public boolean isOptimisticLock() {
        return this.optimisticLock;
    }

    @Override
    public void resolve(CFCPersistenceMetadata cfcPmd, Map<String, CFCPersistenceMetadata> cfcMetaDataMap, DBMetaData dbMetaData) {
        CFCPersistenceMetadata targetCfcPmd = cfcMetaDataMap.get(this.targetComponent);
        if (targetCfcPmd == null) {
            return;
        }
        this.validateMappedByValue(cfcPmd);
        if (this.fkColumns != null) {
            return;
        }
        ManyToOneField targetManyToOneFied = (ManyToOneField)targetCfcPmd.getRelationField(cfcPmd.getCfcName(), 3);
        if (this.linkTable == null && targetManyToOneFied != null && targetManyToOneFied.getFkColumns() != null) {
            this.fkColumns = targetManyToOneFied.getFkColumns();
            return;
        }
        try {
            TableMetaData thisTableMetadata = null;
            TableMetaData thatTableMetadata = null;
            if (dbMetaData != null) {
                thisTableMetadata = dbMetaData.getTableMetaData(cfcPmd.getTableName(), cfcPmd.getSchema(), cfcPmd.getCatalog());
                thatTableMetadata = dbMetaData.getTableMetaData(targetCfcPmd.getTableName(), targetCfcPmd.getSchema(), targetCfcPmd.getCatalog());
            }
            if (thisTableMetadata == null && thatTableMetadata == null && this.linkTable == null) {
                String relName = targetManyToOneFied == null ? null : targetManyToOneFied.getName();
                this.fkColumns = this.generateFKColumnNames(cfcPmd, relName);
                if (this.fkColumns != null) {
                    if (targetManyToOneFied != null) {
                        targetManyToOneFied.setFkColumns(this.fkColumns);
                    }
                    return;
                }
            }
            if (dbMetaData == null || thisTableMetadata == null || thatTableMetadata == null) {
                return;
            }
            if (this.linkTable != null) {
                TableMetaData linkTableMetadata = dbMetaData.getTableMetaData(this.linkTable, this.linkTableSchema, this.linkTableCatalog);
                if (linkTableMetadata != null) {
                    Map fkMap = linkTableMetadata.getForeignKeys();
                    for (String fkCol : fkMap.keySet()) {
                        ForeignKeyMetaData fkMetadata = (ForeignKeyMetaData)fkMap.get(fkCol);
                        String pktableName = fkMetadata.getPktableName();
                        if (this.fkColumns == null && pktableName.equalsIgnoreCase(cfcPmd.getTableName())) {
                            this.fkColumns = new String[]{fkCol};
                            continue;
                        }
                        if (this.inverseJoinColumn != null || !pktableName.equalsIgnoreCase(targetCfcPmd.getTableName())) continue;
                        this.inverseJoinColumn = new String[]{fkCol};
                    }
                    if (targetManyToOneFied != null) {
                        if (targetManyToOneFied.getFkColumns() == null) {
                            targetManyToOneFied.setFkColumns(this.inverseJoinColumn);
                        }
                        if (targetManyToOneFied.getInverseJoinColumn() == null) {
                            targetManyToOneFied.setInverseJoinColumn(this.fkColumns);
                        }
                    }
                }
                return;
            }
            Map fkMap = thatTableMetadata.getForeignKeys();
            for (ForeignKeyMetaData fkMetaData : fkMap.values()) {
                if (!fkMetaData.getPktableName().equalsIgnoreCase(cfcPmd.getTableName())) continue;
                this.fkColumns = new String[]{fkMetaData.getFkColName()};
                if (targetManyToOneFied != null) {
                    if (targetManyToOneFied.getFkColumns() == null) {
                        targetManyToOneFied.setFkColumns(this.fkColumns);
                    }
                    String pkColName = fkMetaData.getPkColName();
                    Set pkColumns = thisTableMetadata.getPkColumns();
                    if (!pkColumns.contains(pkColName) && targetManyToOneFied.getMappedBy() == null) {
                        String mappedPropertyField = cfcPmd.getMappedPropertyField(pkColName);
                        targetManyToOneFied.setMappedBy(mappedPropertyField);
                    }
                }
                return;
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    private void validateMappedByValue(CFCPersistenceMetadata cfcPmd) {
        if (this.mappedBy == null || this.linkTable != null) {
            return;
        }
        List<PropertyField> propertyFields = cfcPmd.getPropertyFields();
        boolean found = false;
        for (int i = 0; i < propertyFields.size(); ++i) {
            PropertyField field = propertyFields.get(i);
            if (!field.getName().equals(this.mappedBy)) continue;
            found = true;
            break;
        }
        if (!found) {
            List<RelationField> relFields = cfcPmd.getRelationFields();
            int relFieldSize = relFields != null ? relFields.size() : 0;
            for (int i = 0; i < relFieldSize; ++i) {
                RelationField relationField = relFields.get(i);
                if (relationField.getRelationType() != 1 || !relationField.getName().equals(this.mappedBy)) continue;
                found = true;
                break;
            }
        }
        if (!found) {
            throw new CFPropertyBinder.AttributeValidationException(RB.getString((Object)this, (String)"invalidMappedByValue", (Object)this.name, (Object)cfcPmd.getCfcName(), (Object)this.mappedBy, (Object)cfcPmd.getCfcName()));
        }
    }

    @Override
    public boolean isResolved() {
        return this.fkColumns != null;
    }

    @Override
    public int getRelationType() {
        return 2;
    }

    public void setCacheStrategy(String cacheStrategy) {
        this.cacheStrategy = cacheStrategy;
    }

    public String getCacheStrategy() {
        return this.cacheStrategy;
    }

    public void setCacheName(String cacheName) {
        this.cacheName = cacheName;
    }

    public String getCacheName() {
        return this.cacheName;
    }

    public String getWhereString() {
        return this.whereString;
    }

    public void setWhereString(String whereString) {
        this.whereString = whereString;
    }

    public void setOnDelete(String onDeleteCascade) {
        this.onDelete = onDeleteCascade;
    }

    public String getOnDelete() {
        return this.onDelete;
    }
}

