/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.orm.hibernate;

import coldfusion.filter.FusionContext;
import coldfusion.orm.ORMUtils;
import coldfusion.orm.hibernate.ConfigurationManager;
import coldfusion.orm.hibernate.HibernateConfiguration;
import coldfusion.orm.hibernate.SessionWrapper;
import coldfusion.tagext.sql.TransactionTag;
import coldfusion.util.CaseInsensitiveMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.SessionFactory;

public class HibernateSessionManager {
    private static HibernateSessionManager instance = new HibernateSessionManager();

    private HibernateSessionManager() {
    }

    public static HibernateSessionManager getInstance() {
        return instance;
    }

    private static String getORMDefaultDatasource() {
        HibernateConfiguration config = ConfigurationManager.getCurrentConfiguration();
        if (config != null) {
            return config.getDataSource();
        }
        return null;
    }

    public Session getCurrentSession() {
        String datasource = HibernateSessionManager.getORMDefaultDatasource();
        if (datasource != null) {
            return this.getCurrentSession(datasource);
        }
        throw new ORMUtils.ORMNotConfiguredException();
    }

    public Session getCurrentSession(String datasource) {
        Map<String, Session> sessionMap = this.getORMSession();
        return sessionMap == null ? null : sessionMap.get(datasource);
    }

    public Session getSession() {
        String datasource = HibernateSessionManager.getORMDefaultDatasource();
        if (datasource != null) {
            return this.getSession(datasource);
        }
        throw new ORMUtils.ORMNotConfiguredException();
    }

    public Session getSession(String datasource) {
        Session session;
        CaseInsensitiveMap sessionMap = this.getORMSession();
        if (sessionMap == null) {
            sessionMap = new CaseInsensitiveMap();
            this.setORMSession((Map<String, Session>)sessionMap);
        }
        if ((session = sessionMap.get(datasource)) == null && (session = this.createNewSession(datasource)) != null) {
            sessionMap.put(datasource, session);
        }
        if (session == null) {
            throw new ORMUtils.ORMNotConfiguredException();
        }
        return session;
    }

    public void closeSession() {
        this.closeSession(true);
    }

    public void closeSession(boolean flush) {
        String datasource = HibernateSessionManager.getORMDefaultDatasource();
        if (datasource != null) {
            this.closeSession(datasource, flush);
        }
    }

    public void closeSession(String datasource) {
        this.closeSession(datasource, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeSession(String datasource, boolean flush) {
        Session session;
        Map<String, Session> sessionMap = this.getORMSession();
        if (sessionMap != null && (session = sessionMap.get(datasource)) != null) {
            try {
                this.closeSession(session, flush);
            }
            finally {
                sessionMap.remove(datasource);
            }
        }
    }

    public void closeSession(Session session, boolean flush) {
        if (flush) {
            session.flush();
        }
        session.close();
    }

    public void closeAllCurrentSessions() {
        this.closeAllCurrentSessions(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeAllCurrentSessions(boolean flush) {
        Map<String, Session> sessionMap = this.getORMSession();
        if (sessionMap == null) {
            return;
        }
        try {
            for (Map.Entry<String, Session> sessions : sessionMap.entrySet()) {
                if (!(sessions.getValue() instanceof Session)) continue;
                this.closeSession(sessions.getValue(), flush);
            }
        }
        finally {
            sessionMap.clear();
        }
    }

    public void clearCurrentSession() {
        Session session = this.getCurrentSession();
        if (session != null) {
            session.clear();
        }
    }

    public void clearCurrentSession(String datasource) {
        Session session = this.getCurrentSession(datasource);
        if (session != null) {
            session.clear();
        }
    }

    public void clearSession(Session session) {
        if (session != null) {
            session.clear();
        }
    }

    public void flushSession() {
        String datasource = HibernateSessionManager.getORMDefaultDatasource();
        if (datasource != null) {
            this.flushSession(datasource);
        }
    }

    public void flushSession(String datasource) {
        Session session = this.getCurrentSession(datasource);
        if (session != null) {
            session.flush();
        }
    }

    public void flushSession(Session session) {
        if (session != null) {
            session.flush();
        }
    }

    public Session createNewSession(String datasource) {
        HibernateConfiguration config = ConfigurationManager.getCurrentConfiguration();
        if (config != null) {
            SessionFactory sf = config.getSessionFactory(datasource);
            Session session = sf.openSession();
            return new SessionWrapper(config, session, datasource);
        }
        return null;
    }

    public void discardSession(Session session) {
        try {
            session.close();
        }
        catch (HibernateException hibernateException) {
        }
        finally {
            this.discardSessionFromThreadLocal(session);
        }
    }

    private void discardSessionFromThreadLocal(Object session) {
        Map<String, Session> sessionMap = this.getORMSession();
        if (sessionMap == null) {
            return;
        }
        for (String ds : sessionMap.keySet()) {
            Session obj = sessionMap.get(ds);
            if (obj != session) continue;
            sessionMap.remove(ds);
            break;
        }
    }

    public void flushAllCurrentSessions() {
        Map<String, Session> sessionMap = this.getORMSession();
        if (sessionMap != null) {
            for (Map.Entry<String, Session> sessions : sessionMap.entrySet()) {
                if (!(sessions.getValue() instanceof Session)) continue;
                this.flushSession(sessions.getValue());
            }
        }
    }

    public List<Session> getAllDirtySessions() {
        Map<String, Session> sessionMap = this.getORMSession();
        ArrayList<Session> dsList = null;
        if (sessionMap != null) {
            for (Session session : sessionMap.values()) {
                if (!session.isDirty()) continue;
                if (dsList == null) {
                    dsList = new ArrayList<Session>();
                }
                dsList.add(session);
            }
        }
        return dsList;
    }

    public Session getSessionInTransaction() {
        Map<String, Session> sessionMap = this.getORMSession();
        if (sessionMap == null) {
            return null;
        }
        TransactionTag txn = TransactionTag.getCurrent();
        if (txn == null) {
            return null;
        }
        String txDataSource = txn.getDatasource();
        return txDataSource == null ? null : sessionMap.get(txDataSource);
    }

    Map<String, Session> getORMSession() {
        FusionContext fusionContext = FusionContext.getCurrent();
        if (fusionContext != null) {
            return fusionContext.getORMSession();
        }
        return null;
    }

    private void setORMSession(Map<String, Session> sessionMap) {
        FusionContext.getCurrent().setORMSession(sessionMap);
    }
}

