/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.util;

import java.awt.Color;
import java.awt.GraphicsEnvironment;
import java.awt.font.TextAttribute;
import java.io.IOException;
import java.io.StringReader;
import java.text.AttributedCharacterIterator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.util.JRStyledText;
import net.sf.jasperreports.engine.util.JRTextAttribute;
import net.sf.jasperreports.engine.xml.JRXmlConstants;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class JRStyledTextParser {
    private static final String ROOT_START = "<st>";
    private static final String ROOT_END = "</st>";
    private static final String NODE_style = "style";
    private static final String NODE_bold = "b";
    private static final String NODE_italic = "i";
    private static final String NODE_sup = "sup";
    private static final String NODE_sub = "sub";
    private static final String NODE_font = "font";
    private static final String NODE_br = "br";
    private static final String NODE_li = "li";
    private static final String ATTRIBUTE_fontName = "fontName";
    private static final String ATTRIBUTE_fontFace = "face";
    private static final String ATTRIBUTE_color = "color";
    private static final String ATTRIBUTE_size = "size";
    private static final String ATTRIBUTE_isBold = "isBold";
    private static final String ATTRIBUTE_isItalic = "isItalic";
    private static final String ATTRIBUTE_isUnderline = "isUnderline";
    private static final String ATTRIBUTE_isStrikeThrough = "isStrikeThrough";
    private static final String ATTRIBUTE_forecolor = "forecolor";
    private static final String ATTRIBUTE_backcolor = "backcolor";
    private static final String ATTRIBUTE_pdfFontName = "pdfFontName";
    private static final String ATTRIBUTE_pdfEncoding = "pdfEncoding";
    private static final String ATTRIBUTE_isPdfEmbedded = "isPdfEmbedded";
    private static final String ATTRIBUTE_href = "href";
    private static final String ATTRIBUTE_anchor = "anchor";
    private static final String NODE_p = "p";
    private static final String NODE_strong = "strong";
    private static final String NODE_em = "em";
    private static final String NODE_u = "u";
    private static final String NODE_underline = "underline";
    private static final String NODE_s = "s";
    private static final String NODE_strike = "strike";
    private static final String NODE_a = "a";
    private static final String NODE_ul = "ul";
    private static final String NODE_ol = "ol";
    private static final String SPACE = " ";
    private static final String EQUAL_QUOTE = "=\"";
    private static final String QUOTE = "\"";
    private static final String SHARP = "#";
    private static final String LESS = "<";
    private static final String LESS_SLASH = "</";
    private static final String GREATER = ">";
    private static final String SIX_ZEROS = "000000";
    private static final int colorMask = Integer.parseInt("FFFFFF", 16);
    private static final float FONTSIZE_1 = 7.5f;
    private static final float FONTSIZE_2 = 10.0f;
    private static final float FONTSIZE_3 = 12.0f;
    private static final float FONTSIZE_4 = 13.5f;
    private static final float FONTSIZE_5 = 18.0f;
    private static final float FONTSIZE_6 = 24.0f;
    private static final float FONTSIZE_7 = 36.0f;
    private DocumentBuilder documentBuilder = null;
    private Vector listTracker;
    private boolean inLI;

    public JRStyledTextParser() {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            this.documentBuilder = factory.newDocumentBuilder();
            this.listTracker = new Vector(0);
            this.inLI = false;
        }
        catch (ParserConfigurationException e) {
            throw new JRRuntimeException(e);
        }
    }

    protected String replaceAll(String in, String match, String replacement) {
        if (match == null || match.length() == 0 || replacement == null || in == null) {
            return in;
        }
        int fromIndex = 0;
        int index = in.indexOf(match, fromIndex);
        if (index < 0) {
            return in;
        }
        StringBuffer buf = new StringBuffer("");
        while ((index = in.indexOf(match, fromIndex)) >= 0) {
            buf.append(in.substring(fromIndex, index));
            buf.append(replacement);
            fromIndex = index + match.length();
        }
        buf.append(in.substring(fromIndex));
        return buf.toString();
    }

    protected String unescapeEscapeChars(String buf) {
        int length = buf.length();
        StringBuffer newbuf = new StringBuffer(length);
        for (int i = 0; i < length; ++i) {
            char c = buf.charAt(i);
            if (c != '&') {
                newbuf.append(c);
                continue;
            }
            int start = i;
            if (i < length - 1) {
                c = buf.charAt(++i);
            }
            while (c != ';' && c != '&' && i < length - 1) {
                c = buf.charAt(++i);
            }
            int end = i;
            String esc = buf.substring(start, end);
            if (c == '&') {
                newbuf.append(esc);
                if (i == length - 1) {
                    newbuf.append(c);
                    continue;
                }
                --i;
                continue;
            }
            if (c != ';') {
                newbuf.append(esc);
                continue;
            }
            if (esc.equalsIgnoreCase("&nbsp")) {
                newbuf.append(' ');
                continue;
            }
            if (esc.equalsIgnoreCase("&cent")) {
                newbuf.append('\u00a2');
                continue;
            }
            if (esc.equalsIgnoreCase("&iexcl")) {
                newbuf.append('\u00a1');
                continue;
            }
            if (esc.equalsIgnoreCase("&pound")) {
                newbuf.append('\u00a3');
                continue;
            }
            if (esc.equalsIgnoreCase("&curren")) {
                newbuf.append('\u00a4');
                continue;
            }
            if (esc.equalsIgnoreCase("&brvbar")) {
                newbuf.append('\u00a6');
                continue;
            }
            if (esc.equalsIgnoreCase("&yen")) {
                newbuf.append('\u00a5');
                continue;
            }
            if (esc.equalsIgnoreCase("&sect")) {
                newbuf.append('\u00a7');
                continue;
            }
            if (esc.equalsIgnoreCase("&uml")) {
                newbuf.append('\u00a8');
                continue;
            }
            if (esc.equalsIgnoreCase("&ordf")) {
                newbuf.append('\u00aa');
                continue;
            }
            if (esc.equalsIgnoreCase("&copy")) {
                newbuf.append('\u00a9');
                continue;
            }
            if (esc.equalsIgnoreCase("&laquo")) {
                newbuf.append('\u00ab');
                continue;
            }
            if (esc.equalsIgnoreCase("&not")) {
                newbuf.append('\u00ac');
                continue;
            }
            if (esc.equalsIgnoreCase("&reg")) {
                newbuf.append('\u00ae');
                continue;
            }
            if (esc.equalsIgnoreCase("&shy")) {
                newbuf.append('\u00ad');
                continue;
            }
            if (esc.equalsIgnoreCase("&macr")) {
                newbuf.append('\u00af');
                continue;
            }
            if (esc.equalsIgnoreCase("&deg")) {
                newbuf.append('\u00b0');
                continue;
            }
            if (esc.equalsIgnoreCase("&sup2")) {
                newbuf.append('\u00b2');
                continue;
            }
            if (esc.equalsIgnoreCase("&plusmn")) {
                newbuf.append('\u00b1');
                continue;
            }
            if (esc.equalsIgnoreCase("&sup3")) {
                newbuf.append('\u00b3');
                continue;
            }
            if (esc.equalsIgnoreCase("&acute")) {
                newbuf.append('\u00b4');
                continue;
            }
            if (esc.equalsIgnoreCase("&para")) {
                newbuf.append('\u00b6');
                continue;
            }
            if (esc.equalsIgnoreCase("&micro")) {
                newbuf.append('\u00b5');
                continue;
            }
            if (esc.equalsIgnoreCase("&middot")) {
                newbuf.append('\u00b7');
                continue;
            }
            if (esc.equalsIgnoreCase("&cedil")) {
                newbuf.append('\u00b8');
                continue;
            }
            if (esc.equalsIgnoreCase("&ordm")) {
                newbuf.append('\u00ba');
                continue;
            }
            if (esc.equalsIgnoreCase("&sup1")) {
                newbuf.append('\u00b9');
                continue;
            }
            if (esc.equalsIgnoreCase("&raquo")) {
                newbuf.append('\u00bb');
                continue;
            }
            if (esc.equalsIgnoreCase("&frac14")) {
                newbuf.append('\u00bc');
                continue;
            }
            if (esc.equalsIgnoreCase("&frac34")) {
                newbuf.append('\u00be');
                continue;
            }
            if (esc.equalsIgnoreCase("&frac12")) {
                newbuf.append('\u00bd');
                continue;
            }
            if (esc.equalsIgnoreCase("&iquest")) {
                newbuf.append('\u00bf');
                continue;
            }
            if (esc.equalsIgnoreCase("&Agrave")) {
                newbuf.append('\u00c0');
                continue;
            }
            if (esc.equalsIgnoreCase("&Acirc")) {
                newbuf.append('\u00c2');
                continue;
            }
            if (esc.equalsIgnoreCase("&Aacute")) {
                newbuf.append('\u00c1');
                continue;
            }
            if (esc.equalsIgnoreCase("&Atilde")) {
                newbuf.append('\u00c3');
                continue;
            }
            if (esc.equalsIgnoreCase("&Auml")) {
                newbuf.append('\u00c4');
                continue;
            }
            if (esc.equalsIgnoreCase("&AElig")) {
                newbuf.append('\u00c6');
                continue;
            }
            if (esc.equalsIgnoreCase("&Aring")) {
                newbuf.append('\u00c5');
                continue;
            }
            if (esc.equalsIgnoreCase("&Ccedil")) {
                newbuf.append('\u00c7');
                continue;
            }
            if (esc.equalsIgnoreCase("&Egrave")) {
                newbuf.append('\u00c8');
                continue;
            }
            if (esc.equalsIgnoreCase("&Ecirc")) {
                newbuf.append('\u00ca');
                continue;
            }
            if (esc.equalsIgnoreCase("&Eacute")) {
                newbuf.append('\u00c9');
                continue;
            }
            if (esc.equalsIgnoreCase("&Euml")) {
                newbuf.append('\u00cb');
                continue;
            }
            if (esc.equalsIgnoreCase("&Igrave")) {
                newbuf.append('\u00cc');
                continue;
            }
            if (esc.equalsIgnoreCase("&Icirc")) {
                newbuf.append('\u00ce');
                continue;
            }
            if (esc.equalsIgnoreCase("&Iacute")) {
                newbuf.append('\u00cd');
                continue;
            }
            if (esc.equalsIgnoreCase("&Iuml")) {
                newbuf.append('\u00cf');
                continue;
            }
            if (esc.equalsIgnoreCase("&ETH")) {
                newbuf.append('\u00d0');
                continue;
            }
            if (esc.equalsIgnoreCase("&Ograve")) {
                newbuf.append('\u00d2');
                continue;
            }
            if (esc.equalsIgnoreCase("&Ntilde")) {
                newbuf.append('\u00d1');
                continue;
            }
            if (esc.equalsIgnoreCase("&Oacute")) {
                newbuf.append('\u00d3');
                continue;
            }
            if (esc.equalsIgnoreCase("&Ocirc")) {
                newbuf.append('\u00d4');
                continue;
            }
            if (esc.equalsIgnoreCase("&Ouml")) {
                newbuf.append('\u00d6');
                continue;
            }
            if (esc.equalsIgnoreCase("&Otilde")) {
                newbuf.append('\u00d5');
                continue;
            }
            if (esc.equalsIgnoreCase("&times")) {
                newbuf.append('\u00d7');
                continue;
            }
            if (esc.equalsIgnoreCase("&Oslash")) {
                newbuf.append('\u00d8');
                continue;
            }
            if (esc.equalsIgnoreCase("&Uacute")) {
                newbuf.append('\u00da');
                continue;
            }
            if (esc.equalsIgnoreCase("&Ugrave")) {
                newbuf.append('\u00d9');
                continue;
            }
            if (esc.equalsIgnoreCase("&Ucirc")) {
                newbuf.append('\u00db');
                continue;
            }
            if (esc.equalsIgnoreCase("&Uuml")) {
                newbuf.append('\u00dc');
                continue;
            }
            if (esc.equalsIgnoreCase("&THORN")) {
                newbuf.append('\u00de');
                continue;
            }
            if (esc.equalsIgnoreCase("&Yacute")) {
                newbuf.append('\u00dd');
                continue;
            }
            if (esc.equalsIgnoreCase("&szlig")) {
                newbuf.append('\u00df');
                continue;
            }
            if (esc.equalsIgnoreCase("&agrave")) {
                newbuf.append('\u00e0');
                continue;
            }
            if (esc.equalsIgnoreCase("&acirc")) {
                newbuf.append('\u00e2');
                continue;
            }
            if (esc.equalsIgnoreCase("&aacute")) {
                newbuf.append('\u00e1');
                continue;
            }
            if (esc.equalsIgnoreCase("&atilde")) {
                newbuf.append('\u00e3');
                continue;
            }
            if (esc.equalsIgnoreCase("&auml")) {
                newbuf.append('\u00e4');
                continue;
            }
            if (esc.equalsIgnoreCase("&aelig")) {
                newbuf.append('\u00e6');
                continue;
            }
            if (esc.equalsIgnoreCase("&aring")) {
                newbuf.append('\u00e5');
                continue;
            }
            if (esc.equalsIgnoreCase("&ccedil")) {
                newbuf.append('\u00e7');
                continue;
            }
            if (esc.equalsIgnoreCase("&egrave")) {
                newbuf.append('\u00e8');
                continue;
            }
            if (esc.equalsIgnoreCase("&ecirc")) {
                newbuf.append('\u00ea');
                continue;
            }
            if (esc.equalsIgnoreCase("&eacute")) {
                newbuf.append('\u00e9');
                continue;
            }
            if (esc.equalsIgnoreCase("&euml")) {
                newbuf.append('\u00eb');
                continue;
            }
            if (esc.equalsIgnoreCase("&igrave")) {
                newbuf.append('\u00ec');
                continue;
            }
            if (esc.equalsIgnoreCase("&icirc")) {
                newbuf.append('\u00ee');
                continue;
            }
            if (esc.equalsIgnoreCase("&iacute")) {
                newbuf.append('\u00ed');
                continue;
            }
            if (esc.equalsIgnoreCase("&iuml")) {
                newbuf.append('\u00ef');
                continue;
            }
            if (esc.equalsIgnoreCase("&eth")) {
                newbuf.append('\u00f0');
                continue;
            }
            if (esc.equalsIgnoreCase("&ograve")) {
                newbuf.append('\u00f2');
                continue;
            }
            if (esc.equalsIgnoreCase("&ntilde")) {
                newbuf.append('\u00f1');
                continue;
            }
            if (esc.equalsIgnoreCase("&oacute")) {
                newbuf.append('\u00f3');
                continue;
            }
            if (esc.equalsIgnoreCase("&ocirc")) {
                newbuf.append('\u00f4');
                continue;
            }
            if (esc.equalsIgnoreCase("&ouml")) {
                newbuf.append('\u00f6');
                continue;
            }
            if (esc.equalsIgnoreCase("&otilde")) {
                newbuf.append('\u00f5');
                continue;
            }
            if (esc.equalsIgnoreCase("&divide")) {
                newbuf.append('\u00f7');
                continue;
            }
            if (esc.equalsIgnoreCase("&oslash")) {
                newbuf.append('\u00f8');
                continue;
            }
            if (esc.equalsIgnoreCase("&uacute")) {
                newbuf.append('\u00fa');
                continue;
            }
            if (esc.equalsIgnoreCase("&ugrave")) {
                newbuf.append('\u00f9');
                continue;
            }
            if (esc.equalsIgnoreCase("&ucirc")) {
                newbuf.append('\u00fb');
                continue;
            }
            if (esc.equalsIgnoreCase("&uuml")) {
                newbuf.append('\u00fc');
                continue;
            }
            if (esc.equalsIgnoreCase("&thorn")) {
                newbuf.append('\u00fe');
                continue;
            }
            if (esc.equalsIgnoreCase("&yacute")) {
                newbuf.append('\u00fd');
                continue;
            }
            if (esc.equalsIgnoreCase("&yuml")) {
                newbuf.append('\u00ff');
                continue;
            }
            if (esc.equalsIgnoreCase("&ndash")) {
                newbuf.append('\u2013');
                continue;
            }
            if (esc.equalsIgnoreCase("&lsquo")) {
                newbuf.append('\u2018');
                continue;
            }
            if (esc.equalsIgnoreCase("&mdash")) {
                newbuf.append('\u2014');
                continue;
            }
            if (esc.equalsIgnoreCase("&rsquo")) {
                newbuf.append('\u2019');
                continue;
            }
            if (esc.equalsIgnoreCase("&ldquo")) {
                newbuf.append('\u201c');
                continue;
            }
            if (esc.equalsIgnoreCase("&euro")) {
                newbuf.append('\u20ac');
                continue;
            }
            if (esc.equalsIgnoreCase("&rdquo")) {
                newbuf.append('\u201d');
                continue;
            }
            newbuf.append(esc);
            newbuf.append(';');
        }
        return newbuf.toString();
    }

    public JRStyledText parse(Map attributes, String text) throws SAXException {
        return this.parse(attributes, text, false);
    }

    public JRStyledText parse(Map attributes, String text, boolean doHTMLReplace) throws SAXException {
        Document document;
        JRStyledText styledText = new JRStyledText();
        String replacedText = text;
        if (doHTMLReplace) {
            text = this.replaceAll(text, "<br>", "<br/>");
            text = this.replaceAll(text, "<BR>", "<br/>");
            if ((text = this.replaceAll(text, "<Br>", "<br/>")).indexOf("&") >= 0) {
                this.unescapeEscapeChars(text);
            }
            replacedText = text;
        }
        try {
            document = this.documentBuilder.parse(new InputSource(new StringReader(ROOT_START + replacedText + ROOT_END)));
        }
        catch (IOException e) {
            throw new JRRuntimeException(e);
        }
        this.parseStyle(styledText, document.getDocumentElement(), doHTMLReplace, attributes);
        styledText.addRun(new JRStyledText.Run(attributes, 0, styledText.length()));
        return styledText;
    }

    public String write(Map parentAttrs, AttributedCharacterIterator iterator, String text) {
        StringBuffer sbuffer = new StringBuffer();
        int runLimit = 0;
        while (runLimit < iterator.getEndIndex() && (runLimit = iterator.getRunLimit()) <= iterator.getEndIndex()) {
            String chunk = text.substring(iterator.getIndex(), runLimit);
            Map<AttributedCharacterIterator.Attribute, Object> attrs = iterator.getAttributes();
            StringBuffer styleBuffer = this.writeStyleAttributes(parentAttrs, attrs);
            if (styleBuffer.length() > 0) {
                sbuffer.append(LESS);
                sbuffer.append(NODE_style);
                sbuffer.append(styleBuffer.toString());
                sbuffer.append(GREATER);
                this.writeChunk(sbuffer, parentAttrs, attrs, chunk);
                sbuffer.append(LESS_SLASH);
                sbuffer.append(NODE_style);
                sbuffer.append(GREATER);
            } else {
                this.writeChunk(sbuffer, parentAttrs, attrs, chunk);
            }
            iterator.setIndex(runLimit);
        }
        return sbuffer.toString();
    }

    public void writeChunk(StringBuffer sbuffer, Map parentAttrs, Map attrs, String chunk) {
        Object value = attrs.get(TextAttribute.SUPERSCRIPT);
        Object oldValue = parentAttrs.get(TextAttribute.SUPERSCRIPT);
        boolean isSuper = false;
        boolean isSub = false;
        if (value != null && !value.equals(oldValue)) {
            isSuper = TextAttribute.SUPERSCRIPT_SUPER.equals(value);
            isSub = TextAttribute.SUPERSCRIPT_SUB.equals(value);
        }
        if (isSuper || isSub) {
            String node = isSuper ? NODE_sup : NODE_sub;
            sbuffer.append(LESS);
            sbuffer.append(node);
            sbuffer.append(GREATER);
            sbuffer.append(chunk);
            sbuffer.append(LESS_SLASH);
            sbuffer.append(node);
            sbuffer.append(GREATER);
        } else {
            sbuffer.append(chunk);
        }
    }

    private Map getStyleHashMap(Map startHash) {
        if (startHash == null) {
            return new HashMap();
        }
        return new HashMap(startHash);
    }

    private String convertHTMLEntities(String startString) {
        if (startString.indexOf(38) >= 0 || startString.indexOf(60) >= 0 || startString.indexOf(62) >= 0) {
            startString = this.replaceAll(startString, "&", "&amp;");
            startString = this.replaceAll(startString, LESS, "&lt;");
            startString = this.replaceAll(startString, GREATER, "&gt;");
            return startString;
        }
        return startString;
    }

    private void parseStyle(JRStyledText styledText, Node parentNode, boolean doHTMLReplace) throws SAXException {
        this.parseStyle(styledText, parentNode, doHTMLReplace, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseStyle(JRStyledText styledText, Node parentNode, boolean doHTMLReplace, Map startHash) throws SAXException {
        NodeList nodeList = parentNode.getChildNodes();
        int currentOrderedCount = 1;
        for (int i = 0; i < nodeList.getLength(); ++i) {
            int startIndex;
            Node node = nodeList.item(i);
            if (node.getNodeType() == 3) {
                if (this.listTracker.size() > 0 && !this.inLI) continue;
                String tmpValue = doHTMLReplace ? this.convertHTMLEntities(node.getNodeValue()) : node.getNodeValue();
                if (this.listTracker.size() > 0 && this.inLI) {
                    tmpValue.trim();
                }
                styledText.append(tmpValue);
                continue;
            }
            if (node.getNodeType() == 1 && NODE_style.equals(node.getNodeName())) {
                Color color;
                NamedNodeMap nodeAttrs = node.getAttributes();
                HashMap<AttributedCharacterIterator.Attribute, Object> styleAttrs = new HashMap<AttributedCharacterIterator.Attribute, Object>();
                if (nodeAttrs.getNamedItem(ATTRIBUTE_fontName) != null) {
                    styleAttrs.put(TextAttribute.FAMILY, nodeAttrs.getNamedItem(ATTRIBUTE_fontName).getNodeValue());
                }
                if (nodeAttrs.getNamedItem(ATTRIBUTE_isBold) != null) {
                    styleAttrs.put(TextAttribute.WEIGHT, Boolean.valueOf(nodeAttrs.getNamedItem(ATTRIBUTE_isBold).getNodeValue()) != false ? TextAttribute.WEIGHT_BOLD : TextAttribute.WEIGHT_REGULAR);
                }
                if (nodeAttrs.getNamedItem(ATTRIBUTE_isItalic) != null) {
                    styleAttrs.put(TextAttribute.POSTURE, Boolean.valueOf(nodeAttrs.getNamedItem(ATTRIBUTE_isItalic).getNodeValue()) != false ? TextAttribute.POSTURE_OBLIQUE : TextAttribute.POSTURE_REGULAR);
                }
                if (nodeAttrs.getNamedItem(ATTRIBUTE_isUnderline) != null) {
                    styleAttrs.put(TextAttribute.UNDERLINE, Boolean.valueOf(nodeAttrs.getNamedItem(ATTRIBUTE_isUnderline).getNodeValue()) != false ? TextAttribute.UNDERLINE_ON : null);
                }
                if (nodeAttrs.getNamedItem(ATTRIBUTE_isStrikeThrough) != null) {
                    styleAttrs.put(TextAttribute.STRIKETHROUGH, Boolean.valueOf(nodeAttrs.getNamedItem(ATTRIBUTE_isStrikeThrough).getNodeValue()) != false ? TextAttribute.STRIKETHROUGH_ON : null);
                }
                if (nodeAttrs.getNamedItem(ATTRIBUTE_size) != null) {
                    styleAttrs.put(TextAttribute.SIZE, new Float(nodeAttrs.getNamedItem(ATTRIBUTE_size).getNodeValue()));
                }
                if (nodeAttrs.getNamedItem(ATTRIBUTE_pdfFontName) != null) {
                    styleAttrs.put(JRTextAttribute.PDF_FONT_NAME, nodeAttrs.getNamedItem(ATTRIBUTE_pdfFontName).getNodeValue());
                }
                if (nodeAttrs.getNamedItem(ATTRIBUTE_pdfEncoding) != null) {
                    styleAttrs.put(JRTextAttribute.PDF_ENCODING, nodeAttrs.getNamedItem(ATTRIBUTE_pdfEncoding).getNodeValue());
                }
                if (nodeAttrs.getNamedItem(ATTRIBUTE_isPdfEmbedded) != null) {
                    styleAttrs.put(JRTextAttribute.IS_PDF_EMBEDDED, Boolean.valueOf(nodeAttrs.getNamedItem(ATTRIBUTE_isPdfEmbedded).getNodeValue()));
                }
                if (nodeAttrs.getNamedItem(ATTRIBUTE_forecolor) != null) {
                    color = JRXmlConstants.getColor(nodeAttrs.getNamedItem(ATTRIBUTE_forecolor).getNodeValue(), Color.black);
                    styleAttrs.put(TextAttribute.FOREGROUND, color);
                }
                if (nodeAttrs.getNamedItem(ATTRIBUTE_backcolor) != null) {
                    color = JRXmlConstants.getColor(nodeAttrs.getNamedItem(ATTRIBUTE_backcolor).getNodeValue(), Color.black);
                    styleAttrs.put(TextAttribute.BACKGROUND, color);
                }
                startIndex = styledText.length();
                this.parseStyle(styledText, node, doHTMLReplace);
                styledText.addRun(new JRStyledText.Run(styleAttrs, startIndex, styledText.length()));
                continue;
            }
            if (node.getNodeType() == 1 && (NODE_bold.equalsIgnoreCase(node.getNodeName()) || NODE_strong.equalsIgnoreCase(node.getNodeName()))) {
                Map styleAttrs = this.getStyleHashMap(startHash);
                styleAttrs.put(TextAttribute.WEIGHT, TextAttribute.WEIGHT_BOLD);
                int startIndex2 = styledText.length();
                this.parseStyle(styledText, node, doHTMLReplace, styleAttrs);
                styledText.addRun(new JRStyledText.Run(styleAttrs, startIndex2, styledText.length()));
                continue;
            }
            if (node.getNodeType() == 1 && (NODE_italic.equalsIgnoreCase(node.getNodeName()) || NODE_em.equalsIgnoreCase(node.getNodeName()))) {
                Map styleAttrs = this.getStyleHashMap(startHash);
                styleAttrs.put(TextAttribute.POSTURE, TextAttribute.POSTURE_OBLIQUE);
                int startIndex3 = styledText.length();
                this.parseStyle(styledText, node, doHTMLReplace, styleAttrs);
                styledText.addRun(new JRStyledText.Run(styleAttrs, startIndex3, styledText.length()));
                continue;
            }
            if (node.getNodeType() == 1 && (NODE_u.equalsIgnoreCase(node.getNodeName()) || NODE_underline.equalsIgnoreCase(node.getNodeName()))) {
                Map styleAttrs = this.getStyleHashMap(startHash);
                styleAttrs.put(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_ON);
                int startIndex4 = styledText.length();
                this.parseStyle(styledText, node, doHTMLReplace, styleAttrs);
                styledText.addRun(new JRStyledText.Run(styleAttrs, startIndex4, styledText.length()));
                continue;
            }
            if (node.getNodeType() == 1 && NODE_sup.equalsIgnoreCase(node.getNodeName())) {
                Map styleAttrs = this.getStyleHashMap(startHash);
                styleAttrs.put(TextAttribute.SUPERSCRIPT, TextAttribute.SUPERSCRIPT_SUPER);
                int startIndex5 = styledText.length();
                this.parseStyle(styledText, node, doHTMLReplace, styleAttrs);
                styledText.addRun(new JRStyledText.Run(styleAttrs, startIndex5, styledText.length()));
                continue;
            }
            if (node.getNodeType() == 1 && NODE_sub.equalsIgnoreCase(node.getNodeName())) {
                Map styleAttrs = this.getStyleHashMap(startHash);
                styleAttrs.put(TextAttribute.SUPERSCRIPT, TextAttribute.SUPERSCRIPT_SUB);
                int startIndex6 = styledText.length();
                this.parseStyle(styledText, node, doHTMLReplace, styleAttrs);
                styledText.addRun(new JRStyledText.Run(styleAttrs, startIndex6, styledText.length()));
                continue;
            }
            if (node.getNodeType() == 1 && NODE_font.equalsIgnoreCase(node.getNodeName())) {
                NamedNodeMap nodeAttrs = node.getAttributes();
                Map styleAttrs = this.getStyleHashMap(startHash);
                if (nodeAttrs.getNamedItem(ATTRIBUTE_fontFace) != null) {
                    styleAttrs.put(JRTextAttribute.HTML_FONT_FACE, nodeAttrs.getNamedItem(ATTRIBUTE_fontFace).getNodeValue());
                }
                if (nodeAttrs.getNamedItem(ATTRIBUTE_size) != null) {
                    String size = nodeAttrs.getNamedItem(ATTRIBUTE_size).getNodeValue();
                    Float fSize = null;
                    try {
                        Integer tmpSize = size.indexOf(43) == 0 ? new Integer(size.substring(1)) : new Integer(size);
                        if (size.indexOf(43) == 0 || size.indexOf(45) == 0) {
                            int newValue;
                            Object currentSize = styleAttrs.get(TextAttribute.SIZE);
                            int curVal = 3;
                            if (currentSize != null) {
                                float tmpFloatSize = ((Float)currentSize).floatValue();
                                curVal = tmpFloatSize <= 7.5f ? 1 : (tmpFloatSize > 7.5f && tmpFloatSize <= 10.0f ? 2 : (tmpFloatSize > 10.0f && tmpFloatSize <= 12.0f ? 3 : (tmpFloatSize > 12.0f && tmpFloatSize <= 13.5f ? 4 : (tmpFloatSize > 13.5f && tmpFloatSize <= 18.0f ? 5 : (tmpFloatSize > 18.0f && tmpFloatSize <= 24.0f ? 6 : 7)))));
                            }
                            tmpSize = (newValue = curVal + tmpSize) < 1 ? new Integer(1) : (newValue > 7 ? new Integer(7) : new Integer(newValue));
                        }
                        switch (tmpSize) {
                            case 1: {
                                fSize = new Float(7.5f);
                                break;
                            }
                            case 2: {
                                fSize = new Float(10.0f);
                                break;
                            }
                            case 3: {
                                fSize = new Float(12.0f);
                                break;
                            }
                            case 4: {
                                fSize = new Float(13.5f);
                                break;
                            }
                            case 5: {
                                fSize = new Float(18.0f);
                                break;
                            }
                            case 6: {
                                fSize = new Float(24.0f);
                                break;
                            }
                            case 7: {
                                fSize = new Float(36.0f);
                            }
                        }
                    }
                    catch (Throwable tmpSize) {
                        // empty catch block
                    }
                    if (fSize != null) {
                        styleAttrs.put(TextAttribute.SIZE, fSize);
                    }
                }
                if (nodeAttrs.getNamedItem(ATTRIBUTE_color) != null) {
                    Color color = JRXmlConstants.getColor(nodeAttrs.getNamedItem(ATTRIBUTE_color).getNodeValue(), Color.black);
                    styleAttrs.put(TextAttribute.FOREGROUND, color);
                }
                if (nodeAttrs.getNamedItem(ATTRIBUTE_fontFace) != null) {
                    String[] fontList = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
                    String fontFaces = nodeAttrs.getNamedItem(ATTRIBUTE_fontFace).getNodeValue();
                    StringTokenizer t = new StringTokenizer(fontFaces, ",");
                    block15: while (t.hasMoreTokens()) {
                        String face = t.nextToken().trim();
                        for (int j = 0; j < fontList.length; ++j) {
                            if (!fontList[j].equals(face)) continue;
                            styleAttrs.put(TextAttribute.FAMILY, face);
                            break block15;
                        }
                    }
                }
                startIndex = styledText.length();
                this.parseStyle(styledText, node, doHTMLReplace, styleAttrs);
                styledText.addRun(new JRStyledText.Run(styleAttrs, startIndex, styledText.length()));
                continue;
            }
            if (node.getNodeType() == 1 && NODE_br.equalsIgnoreCase(node.getNodeName())) {
                styledText.append("\n");
                continue;
            }
            if (node.getNodeType() == 1 && NODE_li.equalsIgnoreCase(node.getNodeName())) {
                styledText.append(SPACE);
                for (int indent = 1; indent < this.listTracker.size(); ++indent) {
                    styledText.append("  ");
                }
                if (this.listTracker.size() > 0 && ((Boolean)this.listTracker.get(this.listTracker.size() - 1)).booleanValue()) {
                    styledText.append(String.valueOf(currentOrderedCount));
                    styledText.append(". ");
                    ++currentOrderedCount;
                } else {
                    styledText.append("\u2022 ");
                }
                int startIndex7 = styledText.length();
                this.resizeRuns(styledText.getRuns(), startIndex7, 1);
                this.inLI = true;
                try {
                    this.parseStyle(styledText, node, doHTMLReplace);
                }
                finally {
                    this.inLI = false;
                }
                styledText.append("\n");
                styledText.addRun(new JRStyledText.Run(new HashMap(), startIndex7, styledText.length()));
                this.resizeRuns(styledText.getRuns(), startIndex7, 1);
                continue;
            }
            if (node.getNodeType() == 1 && (NODE_ul.equalsIgnoreCase(node.getNodeName()) || NODE_ol.equalsIgnoreCase(node.getNodeName()))) {
                this.listTracker.add(new Boolean(NODE_ol.equalsIgnoreCase(node.getNodeName())));
                int curSize = this.listTracker.size();
                int startIndex8 = styledText.length();
                this.parseStyle(styledText, node, doHTMLReplace);
                styledText.addRun(new JRStyledText.Run(new HashMap(), startIndex8, styledText.length()));
                while (this.listTracker.size() >= curSize) {
                    this.listTracker.removeElementAt(curSize - 1);
                }
                continue;
            }
            if (node.getNodeType() == 1 && NODE_a.equalsIgnoreCase(node.getNodeName())) {
                Map styleAttrs = this.getStyleHashMap(startHash);
                NamedNodeMap nodeAttrs = node.getAttributes();
                if (nodeAttrs.getNamedItem(ATTRIBUTE_href) != null) {
                    String href = nodeAttrs.getNamedItem(ATTRIBUTE_href).getNodeValue();
                    styleAttrs.put(JRTextAttribute.HREF, href);
                    styleAttrs.put(TextAttribute.FOREGROUND, Color.blue);
                    styleAttrs.put(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_ON);
                } else if (nodeAttrs.getNamedItem(ATTRIBUTE_anchor) != null) {
                    String anchor = nodeAttrs.getNamedItem(ATTRIBUTE_anchor).getNodeValue();
                    styleAttrs.put(JRTextAttribute.ANCHOR, anchor);
                }
                startIndex = styledText.length();
                this.parseStyle(styledText, node, doHTMLReplace, styleAttrs);
                styledText.addRun(new JRStyledText.Run(styleAttrs, startIndex, styledText.length()));
                continue;
            }
            if (node.getNodeType() == 1 && NODE_p.equalsIgnoreCase(node.getNodeName())) {
                this.parseStyle(styledText, node, doHTMLReplace, startHash);
                styledText.append("\n");
                continue;
            }
            if (node.getNodeType() == 1 && (NODE_s.equalsIgnoreCase(node.getNodeName()) || NODE_strike.equalsIgnoreCase(node.getNodeName()))) {
                Map styleAttrs = this.getStyleHashMap(startHash);
                styleAttrs.put(TextAttribute.STRIKETHROUGH, TextAttribute.STRIKETHROUGH_ON);
                int startIndex9 = styledText.length();
                this.parseStyle(styledText, node, doHTMLReplace, styleAttrs);
                styledText.addRun(new JRStyledText.Run(styleAttrs, startIndex9, styledText.length()));
                continue;
            }
            this.parseStyle(styledText, node, doHTMLReplace);
        }
    }

    private void resizeRuns(List runs, int startIndex, int count) {
        for (int j = 0; j < runs.size(); ++j) {
            JRStyledText.Run run = (JRStyledText.Run)runs.get(j);
            if (run.startIndex > startIndex || run.endIndex <= startIndex - count) continue;
            run.endIndex += count;
        }
    }

    private StringBuffer writeStyleAttributes(Map parentAttrs, Map attrs) {
        StringBuffer sbuffer = new StringBuffer();
        Object value = attrs.get(TextAttribute.FAMILY);
        Object oldValue = parentAttrs.get(TextAttribute.FAMILY);
        if (value != null && !value.equals(oldValue)) {
            sbuffer.append(SPACE);
            sbuffer.append(ATTRIBUTE_fontName);
            sbuffer.append(EQUAL_QUOTE);
            sbuffer.append(value);
            sbuffer.append(QUOTE);
        }
        value = attrs.get(TextAttribute.WEIGHT);
        oldValue = parentAttrs.get(TextAttribute.WEIGHT);
        if (value != null && !value.equals(oldValue)) {
            sbuffer.append(SPACE);
            sbuffer.append(ATTRIBUTE_isBold);
            sbuffer.append(EQUAL_QUOTE);
            sbuffer.append(value.equals(TextAttribute.WEIGHT_BOLD));
            sbuffer.append(QUOTE);
        }
        value = attrs.get(TextAttribute.POSTURE);
        oldValue = parentAttrs.get(TextAttribute.POSTURE);
        if (value != null && !value.equals(oldValue)) {
            sbuffer.append(SPACE);
            sbuffer.append(ATTRIBUTE_isItalic);
            sbuffer.append(EQUAL_QUOTE);
            sbuffer.append(value.equals(TextAttribute.POSTURE_OBLIQUE));
            sbuffer.append(QUOTE);
        }
        value = attrs.get(TextAttribute.UNDERLINE);
        oldValue = parentAttrs.get(TextAttribute.UNDERLINE);
        if (value == null && oldValue != null || value != null && !value.equals(oldValue)) {
            sbuffer.append(SPACE);
            sbuffer.append(ATTRIBUTE_isUnderline);
            sbuffer.append(EQUAL_QUOTE);
            sbuffer.append(value != null);
            sbuffer.append(QUOTE);
        }
        value = attrs.get(TextAttribute.STRIKETHROUGH);
        oldValue = parentAttrs.get(TextAttribute.STRIKETHROUGH);
        if (value == null && oldValue != null || value != null && !value.equals(oldValue)) {
            sbuffer.append(SPACE);
            sbuffer.append(ATTRIBUTE_isStrikeThrough);
            sbuffer.append(EQUAL_QUOTE);
            sbuffer.append(value != null);
            sbuffer.append(QUOTE);
        }
        value = attrs.get(TextAttribute.SIZE);
        oldValue = parentAttrs.get(TextAttribute.SIZE);
        if (value != null && !value.equals(oldValue)) {
            sbuffer.append(SPACE);
            sbuffer.append(ATTRIBUTE_size);
            sbuffer.append(EQUAL_QUOTE);
            sbuffer.append(((Float)value).intValue());
            sbuffer.append(QUOTE);
        }
        value = attrs.get(JRTextAttribute.PDF_FONT_NAME);
        oldValue = parentAttrs.get(JRTextAttribute.PDF_FONT_NAME);
        if (value != null && !value.equals(oldValue)) {
            sbuffer.append(SPACE);
            sbuffer.append(ATTRIBUTE_pdfFontName);
            sbuffer.append(EQUAL_QUOTE);
            sbuffer.append(value);
            sbuffer.append(QUOTE);
        }
        value = attrs.get(JRTextAttribute.PDF_ENCODING);
        oldValue = parentAttrs.get(JRTextAttribute.PDF_ENCODING);
        if (value != null && !value.equals(oldValue)) {
            sbuffer.append(SPACE);
            sbuffer.append(ATTRIBUTE_pdfEncoding);
            sbuffer.append(EQUAL_QUOTE);
            sbuffer.append(value);
            sbuffer.append(QUOTE);
        }
        value = attrs.get(JRTextAttribute.IS_PDF_EMBEDDED);
        oldValue = parentAttrs.get(JRTextAttribute.IS_PDF_EMBEDDED);
        if (value != null && !value.equals(oldValue)) {
            sbuffer.append(SPACE);
            sbuffer.append(ATTRIBUTE_isPdfEmbedded);
            sbuffer.append(EQUAL_QUOTE);
            sbuffer.append(value);
            sbuffer.append(QUOTE);
        }
        value = attrs.get(TextAttribute.FOREGROUND);
        oldValue = parentAttrs.get(TextAttribute.FOREGROUND);
        if (value != null && !value.equals(oldValue)) {
            sbuffer.append(SPACE);
            sbuffer.append(ATTRIBUTE_forecolor);
            sbuffer.append(EQUAL_QUOTE);
            sbuffer.append(SHARP);
            sbuffer.append(this.getHexaColor((Color)value));
            sbuffer.append(QUOTE);
        }
        value = attrs.get(TextAttribute.BACKGROUND);
        oldValue = parentAttrs.get(TextAttribute.BACKGROUND);
        if (value != null && !value.equals(oldValue)) {
            sbuffer.append(SPACE);
            sbuffer.append(ATTRIBUTE_backcolor);
            sbuffer.append(EQUAL_QUOTE);
            sbuffer.append(SHARP);
            sbuffer.append(this.getHexaColor((Color)value));
            sbuffer.append(QUOTE);
        }
        value = attrs.get(JRTextAttribute.ANCHOR);
        oldValue = parentAttrs.get(JRTextAttribute.ANCHOR);
        if (value != null && !value.equals(oldValue)) {
            sbuffer.append(SPACE);
            sbuffer.append(ATTRIBUTE_href);
            sbuffer.append(EQUAL_QUOTE);
            sbuffer.append(value);
            sbuffer.append(QUOTE);
        }
        value = attrs.get(JRTextAttribute.HREF);
        oldValue = parentAttrs.get(JRTextAttribute.HREF);
        if (value != null && !value.equals(oldValue)) {
            sbuffer.append(SPACE);
            sbuffer.append(ATTRIBUTE_href);
            sbuffer.append(EQUAL_QUOTE);
            sbuffer.append(value);
            sbuffer.append(QUOTE);
        }
        return sbuffer;
    }

    private String getHexaColor(Color color) {
        String hexa = Integer.toHexString(color.getRGB() & colorMask).toUpperCase();
        return (SIX_ZEROS + hexa).substring(hexa.length());
    }
}

