/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.fill;

import java.awt.Color;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.sf.jasperreports.engine.JRDefaultStyleProvider;
import net.sf.jasperreports.engine.JRElement;
import net.sf.jasperreports.engine.JRElementGroup;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRExpressionChunk;
import net.sf.jasperreports.engine.JRGroup;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JRStyle;
import net.sf.jasperreports.engine.fill.JRBaseFiller;
import net.sf.jasperreports.engine.fill.JRCloneable;
import net.sf.jasperreports.engine.fill.JREvaluationTime;
import net.sf.jasperreports.engine.fill.JRFillBand;
import net.sf.jasperreports.engine.fill.JRFillCloneFactory;
import net.sf.jasperreports.engine.fill.JRFillElementContainer;
import net.sf.jasperreports.engine.fill.JRFillElementGroup;
import net.sf.jasperreports.engine.fill.JRFillExpressionEvaluator;
import net.sf.jasperreports.engine.fill.JRFillField;
import net.sf.jasperreports.engine.fill.JRFillObjectFactory;
import net.sf.jasperreports.engine.fill.JRFillVariable;
import net.sf.jasperreports.engine.fill.JRRecordedValues;
import net.sf.jasperreports.engine.fill.JRRecordedValuesPrintElement;
import net.sf.jasperreports.engine.fill.JRTemplateElement;
import net.sf.jasperreports.engine.util.JRStyleResolver;

public abstract class JRFillElement
implements JRElement,
JRCloneable {
    protected JRElement parent = null;
    protected Map templates = new HashMap();
    protected JRBaseFiller filler = null;
    protected JRFillExpressionEvaluator expressionEvaluator = null;
    protected JRGroup printWhenGroupChanges = null;
    protected JRFillElementGroup elementGroup = null;
    protected JRFillBand band = null;
    private boolean isPrintWhenExpressionNull = true;
    private boolean isPrintWhenTrue = true;
    private boolean isToPrint = true;
    private boolean isReprinted = false;
    private boolean isAlreadyPrinted = false;
    private Collection dependantElements = new ArrayList();
    private int relativeY = 0;
    private int stretchHeight = 0;
    private int bandBottomY = 0;
    private int x;
    private int y;
    private int width;
    private int height;
    private boolean isValueRepeating = false;
    protected byte currentEvaluation;
    protected Map delayedEvaluationsMap;
    protected JRFillElementContainer conditionalStylesContainer;
    protected final JRStyle initStyle;
    private boolean shrinkable;

    protected JRFillElement(JRBaseFiller filler, JRElement element, JRFillObjectFactory factory) {
        factory.put(element, this);
        this.parent = element;
        this.filler = filler;
        this.expressionEvaluator = factory.getExpressionEvaluator();
        this.printWhenGroupChanges = factory.getGroup(element.getPrintWhenGroupChanges());
        this.elementGroup = (JRFillElementGroup)factory.getElementGroup(element.getElementGroup());
        this.x = element.getX();
        this.y = element.getY();
        this.width = element.getWidth();
        this.height = element.getHeight();
        this.initStyle = factory.getStyle(this.parent.getStyle());
    }

    protected JRFillElement(JRFillElement element, JRFillCloneFactory factory) {
        factory.put(element, this);
        this.parent = element.parent;
        this.filler = element.filler;
        this.expressionEvaluator = element.expressionEvaluator;
        this.printWhenGroupChanges = element.printWhenGroupChanges;
        this.elementGroup = (JRFillElementGroup)factory.getClone((JRFillElementGroup)element.getElementGroup());
        this.x = element.getX();
        this.y = element.getY();
        this.width = element.getWidth();
        this.height = element.getHeight();
        this.templates = element.templates;
        this.initStyle = element.initStyle;
        this.shrinkable = element.shrinkable;
    }

    @Override
    public JRDefaultStyleProvider getDefaultStyleProvider() {
        return this.parent.getDefaultStyleProvider();
    }

    @Override
    public String getKey() {
        return this.parent.getKey();
    }

    @Override
    public byte getPositionType() {
        return this.parent.getPositionType();
    }

    @Override
    public void setPositionType(byte positionType) {
    }

    @Override
    public byte getStretchType() {
        return this.parent.getStretchType();
    }

    @Override
    public void setStretchType(byte stretchType) {
    }

    @Override
    public boolean isPrintRepeatedValues() {
        return this.parent.isPrintRepeatedValues();
    }

    @Override
    public void setPrintRepeatedValues(boolean isPrintRepeatedValues) {
    }

    @Override
    public byte getMode() {
        return JRStyleResolver.getMode(this, (byte)1);
    }

    @Override
    public Byte getOwnMode() {
        return this.parent.getOwnMode();
    }

    @Override
    public void setMode(byte mode) {
    }

    @Override
    public void setMode(Byte mode) {
    }

    @Override
    public int getX() {
        return this.x;
    }

    @Override
    public void setX(int x) {
        this.x = x;
    }

    public void setY(int y) {
        this.y = y;
    }

    @Override
    public int getY() {
        return this.y;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public void setWidth(int width) {
        this.width = width;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public boolean isRemoveLineWhenBlank() {
        return this.parent.isRemoveLineWhenBlank();
    }

    @Override
    public void setRemoveLineWhenBlank(boolean isRemoveLine) {
    }

    @Override
    public boolean isPrintInFirstWholeBand() {
        return this.parent.isPrintInFirstWholeBand();
    }

    @Override
    public void setPrintInFirstWholeBand(boolean isPrint) {
    }

    @Override
    public boolean isPrintWhenDetailOverflows() {
        return this.parent.isPrintWhenDetailOverflows();
    }

    @Override
    public void setPrintWhenDetailOverflows(boolean isPrint) {
    }

    @Override
    public Color getForecolor() {
        return JRStyleResolver.getForecolor(this);
    }

    @Override
    public Color getOwnForecolor() {
        return this.parent.getOwnForecolor();
    }

    @Override
    public void setForecolor(Color forecolor) {
    }

    @Override
    public Color getBackcolor() {
        return JRStyleResolver.getBackcolor(this);
    }

    @Override
    public Color getOwnBackcolor() {
        return this.parent.getOwnBackcolor();
    }

    @Override
    public void setBackcolor(Color backcolor) {
    }

    @Override
    public JRExpression getPrintWhenExpression() {
        return this.parent.getPrintWhenExpression();
    }

    @Override
    public JRGroup getPrintWhenGroupChanges() {
        return this.printWhenGroupChanges;
    }

    @Override
    public JRElementGroup getElementGroup() {
        return this.elementGroup;
    }

    protected boolean isPrintWhenExpressionNull() {
        return this.isPrintWhenExpressionNull;
    }

    protected void setPrintWhenExpressionNull(boolean isPrintWhenExpressionNull) {
        this.isPrintWhenExpressionNull = isPrintWhenExpressionNull;
    }

    protected boolean isPrintWhenTrue() {
        return this.isPrintWhenTrue;
    }

    protected void setPrintWhenTrue(boolean isPrintWhenTrue) {
        this.isPrintWhenTrue = isPrintWhenTrue;
    }

    protected boolean isToPrint() {
        return this.isToPrint;
    }

    protected void setToPrint(boolean isToPrint) {
        this.isToPrint = isToPrint;
    }

    protected boolean isReprinted() {
        return this.isReprinted;
    }

    protected void setReprinted(boolean isReprinted) {
        this.isReprinted = isReprinted;
    }

    protected boolean isAlreadyPrinted() {
        return this.isAlreadyPrinted;
    }

    protected void setAlreadyPrinted(boolean isAlreadyPrinted) {
        this.isAlreadyPrinted = isAlreadyPrinted;
    }

    protected JRElement[] getGroupElements() {
        JRElement[] groupElements = null;
        if (this.elementGroup != null) {
            groupElements = this.elementGroup.getElements();
        }
        return groupElements;
    }

    protected Collection getDependantElements() {
        return this.dependantElements;
    }

    protected void addDependantElement(JRElement element) {
        this.dependantElements.add(element);
    }

    protected int getRelativeY() {
        return this.relativeY;
    }

    protected void setRelativeY(int relativeY) {
        this.relativeY = relativeY;
    }

    protected int getStretchHeight() {
        return this.stretchHeight;
    }

    protected void setStretchHeight(int stretchHeight) {
        this.stretchHeight = stretchHeight > this.getHeight() || this.shrinkable && this.isRemoveLineWhenBlank() ? stretchHeight : this.getHeight();
    }

    protected int getBandBottomY() {
        return this.bandBottomY;
    }

    protected void setBandBottomY(int bandBottomY) {
        this.bandBottomY = bandBottomY;
    }

    protected JRFillBand getBand() {
        return this.band;
    }

    protected void setBand(JRFillBand band) {
        this.band = band;
    }

    protected void reset() {
        this.relativeY = this.y;
        this.stretchHeight = this.height;
        if (this.elementGroup != null) {
            this.elementGroup.reset();
        }
    }

    protected void setCurrentEvaluation(byte evaluation) {
        this.currentEvaluation = evaluation;
    }

    protected abstract void evaluate(byte var1) throws JRException;

    protected void evaluatePrintWhenExpression(byte evaluation) throws JRException {
        boolean isExprNull = true;
        boolean isExprTrue = false;
        JRExpression expression = this.getPrintWhenExpression();
        if (expression != null) {
            isExprNull = false;
            Boolean printWhenExpressionValue = (Boolean)this.evaluateExpression(expression, evaluation);
            isExprTrue = printWhenExpressionValue == null ? false : printWhenExpressionValue;
        }
        this.setPrintWhenExpressionNull(isExprNull);
        this.setPrintWhenTrue(isExprTrue);
    }

    protected abstract void rewind() throws JRException;

    protected abstract JRPrintElement fill() throws JRException;

    protected boolean prepare(int availableStretchHeight, boolean isOverflow) throws JRException {
        if (this.isPrintWhenExpressionNull() || !this.isPrintWhenExpressionNull() && this.isPrintWhenTrue()) {
            this.setToPrint(true);
        } else {
            this.setToPrint(false);
        }
        this.setReprinted(false);
        return false;
    }

    protected void stretchElement(int bandStretch) {
        switch (this.getStretchType()) {
            case 2: {
                this.setStretchHeight(this.getHeight() + bandStretch);
                break;
            }
            case 1: {
                if (this.elementGroup == null) break;
                this.setStretchHeight(this.getHeight() + this.elementGroup.getStretchHeightDiff());
                break;
            }
        }
    }

    protected void moveDependantElements() {
        Collection elements = this.getDependantElements();
        if (elements != null && elements.size() > 0) {
            JRFillElement element2 = null;
            int diffY = 0;
            for (JRFillElement element2 : elements) {
                diffY = element2.getY() - this.getY() - this.getHeight() - (element2.getRelativeY() - this.getRelativeY() - this.getStretchHeight());
                if (diffY < 0) {
                    diffY = 0;
                }
                element2.setRelativeY(element2.getRelativeY() + diffY);
            }
        }
    }

    protected abstract void resolveElement(JRPrintElement var1, byte var2) throws JRException;

    protected final Object evaluateExpression(JRExpression expression, byte evaluation) throws JRException {
        return this.expressionEvaluator.evaluate(expression, evaluation);
    }

    protected boolean isValueRepeating() {
        return this.isValueRepeating;
    }

    protected void setValueRepeating(boolean isValueRepeating) {
        this.isValueRepeating = isValueRepeating;
    }

    protected JRFillVariable getVariable(String variableName) {
        return this.filler.getVariable(variableName);
    }

    protected JRFillField getField(String fieldName) {
        return this.filler.getField(fieldName);
    }

    protected byte getEvaluationTime() {
        return 1;
    }

    protected void resolveElement(JRPrintElement element, byte evaluation, JREvaluationTime evaluationTime) throws JRException {
        byte evaluationTimeType = this.getEvaluationTime();
        switch (evaluationTimeType) {
            case 1: {
                break;
            }
            case 7: {
                this.delayedEvaluate((JRRecordedValuesPrintElement)element, evaluationTime, evaluation);
                break;
            }
            default: {
                this.resolveElement(element, evaluation);
            }
        }
    }

    protected boolean delayedEvaluationsInitialized() {
        return this.delayedEvaluationsMap != null;
    }

    protected void initDelayedEvaluations() {
        this.delayedEvaluationsMap = new HashMap();
    }

    protected void collectDelayedEvaluations(JRExpression expression) {
        JRExpressionChunk[] chunks;
        if (expression != null && (chunks = expression.getChunks()) != null) {
            block4: for (int i = 0; i < chunks.length; ++i) {
                JRExpressionChunk chunk = chunks[i];
                switch (chunk.getType()) {
                    case 3: {
                        DelayedEvaluations delayedEvaluations = this.getDelayedEvaluations(JREvaluationTime.EVALUATION_TIME_NOW);
                        delayedEvaluations.fields.add(chunk.getText());
                        continue block4;
                    }
                    case 4: {
                        JREvaluationTime time = this.autogetVariableEvaluationTime(chunk.getText());
                        DelayedEvaluations delayedEvaluations = this.getDelayedEvaluations(time);
                        delayedEvaluations.variables.add(chunk.getText());
                        continue block4;
                    }
                }
            }
        }
    }

    private DelayedEvaluations getDelayedEvaluations(JREvaluationTime time) {
        DelayedEvaluations delayedEvaluations = (DelayedEvaluations)this.delayedEvaluationsMap.get(time);
        if (delayedEvaluations == null) {
            delayedEvaluations = new DelayedEvaluations();
            this.delayedEvaluationsMap.put(time, delayedEvaluations);
        }
        return delayedEvaluations;
    }

    private JREvaluationTime autogetVariableEvaluationTime(String variableName) {
        JREvaluationTime evaluationTime;
        JRFillVariable variable = this.getVariable(variableName);
        switch (variable.getResetType()) {
            case 1: {
                evaluationTime = JREvaluationTime.EVALUATION_TIME_REPORT;
                break;
            }
            case 2: {
                evaluationTime = JREvaluationTime.EVALUATION_TIME_PAGE;
                break;
            }
            case 3: {
                evaluationTime = JREvaluationTime.EVALUATION_TIME_COLUMN;
                break;
            }
            case 4: {
                evaluationTime = JREvaluationTime.getGroupEvaluationTime(variable.getResetGroup().getName());
                break;
            }
            default: {
                evaluationTime = JREvaluationTime.EVALUATION_TIME_NOW;
            }
        }
        if (!evaluationTime.equals(JREvaluationTime.EVALUATION_TIME_NOW) && this.band.isNowEvaluationTime(evaluationTime)) {
            evaluationTime = JREvaluationTime.EVALUATION_TIME_NOW;
        }
        if (variable.getCalculation() == 8 && evaluationTime.equals(JREvaluationTime.EVALUATION_TIME_NOW) && this.band.isVariableUsedInSubreportReturns(variableName)) {
            evaluationTime = JREvaluationTime.getBandEvaluationTime(this.band);
        }
        return evaluationTime;
    }

    protected void initDelayedEvaluationPrint(JRRecordedValuesPrintElement printElement) throws JRException {
        for (JREvaluationTime evaluationTime : this.delayedEvaluationsMap.keySet()) {
            if (evaluationTime.equals(JREvaluationTime.EVALUATION_TIME_NOW)) continue;
            this.filler.addBoundElement(this, printElement, evaluationTime);
        }
        printElement.initRecordedValues(this.delayedEvaluationsMap.keySet());
        if (this.delayedEvaluationsMap.containsKey(JREvaluationTime.EVALUATION_TIME_NOW)) {
            this.delayedEvaluate(printElement, JREvaluationTime.EVALUATION_TIME_NOW, this.currentEvaluation);
        }
    }

    protected void delayedEvaluate(JRRecordedValuesPrintElement printElement, JREvaluationTime evaluationTime, byte evaluation) throws JRException {
        JRRecordedValues recordedValues = printElement.getRecordedValues();
        if (!recordedValues.lastEvaluationTime()) {
            DelayedEvaluations delayedEvaluations = (DelayedEvaluations)this.delayedEvaluationsMap.get(evaluationTime);
            for (String fieldName : delayedEvaluations.fields) {
                JRFillField field = this.getField(fieldName);
                recordedValues.recordFieldValue(fieldName, field.getValue(evaluation));
            }
            for (String variableName : delayedEvaluations.variables) {
                JRFillVariable variable = this.getVariable(variableName);
                recordedValues.recordVariableValue(variableName, variable.getValue(evaluation));
            }
        }
        recordedValues.doneEvaluation(evaluationTime);
        if (recordedValues.finishedEvaluations()) {
            this.overwriteWithRecordedValues(recordedValues, evaluation);
            this.resolveElement(printElement, evaluation);
            this.restoreValues(recordedValues, evaluation);
            printElement.deleteRecordedValues();
        }
    }

    private void overwriteWithRecordedValues(JRRecordedValues recordedValues, byte evaluation) {
        Map variableValues;
        Map fieldValues = recordedValues.getRecordedFieldValues();
        if (fieldValues != null) {
            for (Map.Entry entry : fieldValues.entrySet()) {
                String fieldName = (String)entry.getKey();
                Object fieldValue = entry.getValue();
                JRFillField field = this.getField(fieldName);
                field.overwriteValue(fieldValue, evaluation);
            }
        }
        if ((variableValues = recordedValues.getRecordedVariableValues()) != null) {
            for (Map.Entry entry : variableValues.entrySet()) {
                String variableName = (String)entry.getKey();
                Object variableValue = entry.getValue();
                JRFillVariable variable = this.getVariable(variableName);
                variable.overwriteValue(variableValue, evaluation);
            }
        }
    }

    private void restoreValues(JRRecordedValues recordedValues, byte evaluation) {
        Map variableValues;
        Map fieldValues = recordedValues.getRecordedFieldValues();
        if (fieldValues != null) {
            for (String fieldName : fieldValues.keySet()) {
                JRFillField field = this.getField(fieldName);
                field.restoreValue(evaluation);
            }
        }
        if ((variableValues = recordedValues.getRecordedVariableValues()) != null) {
            for (String variableName : variableValues.keySet()) {
                JRFillVariable variable = this.getVariable(variableName);
                variable.restoreValue(evaluation);
            }
        }
    }

    protected void setConditionalStylesContainer(JRFillElementContainer conditionalStylesContainer) {
        this.conditionalStylesContainer = conditionalStylesContainer;
    }

    @Override
    public JRStyle getStyle() {
        JRStyle crtStyle = this.initStyle;
        boolean isUsingDefaultStyle = false;
        if (crtStyle == null) {
            crtStyle = this.filler.getDefaultStyle();
            isUsingDefaultStyle = true;
        }
        JRStyle evalStyle = crtStyle;
        if (this.conditionalStylesContainer != null) {
            evalStyle = this.conditionalStylesContainer.getEvaluatedConditionalStyle(crtStyle);
        }
        if (evalStyle == null) {
            evalStyle = crtStyle;
        }
        if (isUsingDefaultStyle && evalStyle == crtStyle) {
            evalStyle = null;
        }
        return evalStyle;
    }

    protected JRTemplateElement getTemplate(JRStyle style) {
        return (JRTemplateElement)this.templates.get(style);
    }

    protected void registerTemplate(JRStyle style, JRTemplateElement template) {
        this.templates.put(style, template);
    }

    protected final void setShrinkable(boolean shrinkable) {
        this.shrinkable = shrinkable;
    }

    protected void stretchHeightFinal() {
    }

    private static class DelayedEvaluations
    implements Serializable {
        final Set fields = new HashSet();
        final Set variables = new HashSet();

        DelayedEvaluations() {
        }
    }
}

