/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.fill;

import net.sf.jasperreports.engine.fill.AbstractValueProvider;
import net.sf.jasperreports.engine.fill.JRAbstractExtendedIncrementer;
import net.sf.jasperreports.engine.fill.JRByteIncrementerFactory;
import net.sf.jasperreports.engine.fill.JRCalculable;

class JRByteCountIncrementer
extends JRAbstractExtendedIncrementer {
    private static JRByteCountIncrementer mainInstance = new JRByteCountIncrementer();

    private JRByteCountIncrementer() {
    }

    public static JRByteCountIncrementer getInstance() {
        return mainInstance;
    }

    @Override
    public Object increment(JRCalculable variable, Object expressionValue, AbstractValueProvider valueProvider) {
        Number value = (Number)variable.getIncrementedValue();
        if (expressionValue == null) {
            if (variable.isInitialized()) {
                return JRByteIncrementerFactory.ZERO;
            }
            return value;
        }
        if (value == null || variable.isInitialized()) {
            value = JRByteIncrementerFactory.ZERO;
        }
        return new Byte((byte)(value.byteValue() + 1));
    }

    @Override
    public Object combine(JRCalculable calculable, JRCalculable calculableValue, AbstractValueProvider valueProvider) {
        Number value = (Number)calculable.getIncrementedValue();
        Number combineValue = (Number)calculableValue.getValue();
        if (value == null) {
            value = calculable.getValue() == null ? (Number)JRByteIncrementerFactory.ZERO : (Number)((Number)calculable.getValue());
        }
        if (combineValue == null) {
            return value;
        }
        return new Byte((byte)(value.byteValue() + combineValue.byteValue()));
    }

    @Override
    public Object initialValue(JRCalculable variable) {
        if (variable.getValue() == null) {
            return JRByteIncrementerFactory.ZERO;
        }
        return (Number)variable.getValue();
    }
}

