/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.design;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.design.JRAbstractMultiClassCompiler;
import net.sf.jasperreports.engine.util.JRClassLoader;

public class JRJdk13Compiler
extends JRAbstractMultiClassCompiler {
    private static final int MODERN_COMPILER_SUCCESS = 0;

    @Override
    public String compileClasses(File[] sourceFiles, String classpath) throws JRException {
        String[] source = new String[sourceFiles.length + 2];
        for (int i = 0; i < sourceFiles.length; ++i) {
            source[i] = sourceFiles[i].getPath();
        }
        source[sourceFiles.length] = "-classpath";
        source[sourceFiles.length + 1] = classpath;
        String errors = null;
        try {
            Class clazz = JRClassLoader.loadClassForName("com.sun.tools.javac.Main");
            Object compiler = clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            try {
                Method compileMethod = clazz.getMethod("compile", String[].class, PrintWriter.class);
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                int result = (Integer)compileMethod.invoke(compiler, source, new PrintWriter(baos));
                if (result != 0) {
                    errors = baos.toString();
                }
            }
            catch (NoSuchMethodException ex) {
                Method compileMethod = clazz.getMethod("compile", String[].class);
                int result = (Integer)compileMethod.invoke(compiler, new Object[]{source});
                if (result != 0) {
                    errors = "See error messages above.";
                }
            }
        }
        catch (Exception e) {
            StringBuffer files = new StringBuffer();
            for (int i = 0; i < sourceFiles.length; ++i) {
                files.append(sourceFiles[i].getPath());
                files.append(' ');
            }
            throw new JRException("Error compiling report java source files : " + files, e);
        }
        return errors;
    }
}

